<?php

/**
 * Janox Runtime
 * PHP5
 *
 * This file is part of Janox.
 *
 * THIS FILE HAS BEEN COMPRESSED TO SPEED UP EXECUTION.
 * See file src/jxdb_sqlite3.inc for a readable version of this script.
 */

 if (!extension_loaded('pdo_sqlite')) { throw new o2_exception('<b>SQLite3 PDO</b> driver not loaded:<br>'. 'check your PHP configuration for '. '<i>pdo</i> and <i>pdo_sqlite</i> extensions.', o2error_DBCONNECT); } define('o2_sqlite3_o', '`'); define('o2_sqlite3_c', '`'); $GLOBALS['o2_sqlite3_conn'] = array(); $GLOBALS['o2_sqlite3_trans'] = array(); $GLOBALS['o2_sqlite3_stms'] = array(); $GLOBALS['o2_sqlite3_error'] = array(); function o2_sqlite3_normalize($string, $untrim = false) { return strtr(($untrim ? $string : trim($string)), array("'" => "''")); } function o2_sqlite3_concat($strings) { return '('.implode('||', $strings).')'; } function o2_sqlite3_qualify($database, $owner, $name = '') { return o2_sqlite3_o.$database.($name ? $name.o2_sqlite3_c : ''); } function o2_sqlite3_connect($location, $user, $password, $trans) { $app = $_SESSION['o2_app']; if (!$location) { $location = $app->dir_data.$app->nome.'.db'; } elseif (strpos(strtolower($location), ':session:') === 0) { if (strtolower($location) == ':session:') { $location = $app->dir_tmp.$app->nome.'.db'; } else { $location = $app->dir_tmp.substr($location, 9); } } elseif (strpos(':memory:', strtolower($location)) === false && basename($location) == $location) { $location = $app->dir_data.$location; } if (!isset($GLOBALS['o2_sqlite3_conn'][$location])) { try { $conn_local = new PDO('sqlite:'.$location, null, null, array(PDO::ATTR_PERSISTENT => false, PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION)); } catch (Exception $o2e) { throw new o2_exception('<b>SQLite3</b> server: <i>'.$location.'</i><hr>'. $o2e->getMessage(), o2error_DBCONNECT); } if ($trans) { try { $conn_local->beginTransaction(); } catch (Exception $o2e) { throw new o2_exception('<b>SQLite3</b> server: <i>'.$location.'</i><hr>'. $o2e->getMessage(), o2error_DBCONNECT); } $GLOBALS['o2_sqlite3_trans'][$location] = true; } $GLOBALS['o2_sqlite3_conn'][$location] = $conn_local; } elseif ($trans && !isset($GLOBALS['o2_sqlite3_trans'][$location])) { $conn_local = $GLOBALS['o2_sqlite3_conn'][$location]; try { $conn_local->beginTransaction(); } catch (Exception $o2e) { throw new o2_exception('<b>SQLite3</b> server: <i>'.$location.'</i><hr>'. $o2e->getMessage(), o2error_DBCONNECT); } $GLOBALS['o2_sqlite3_trans'][$location] = true; } return $GLOBALS['o2_sqlite3_conn'][$location]; } function o2_sqlite3_execute($query, $server, $user, $password, $only_exe = false, $trans = true, $limit = 0, &$stm = false, $prepared_pars = false) { if ($_SESSION['o2_app']->sqltrace && !$stm) { if ($stm === 0) { o2log('(Start fetching) '.$query); } else { if ($prepared_pars) { $ppars = "\nWith parameters: ".print_r($prepared_pars, 1); } o2log($query.$ppars); } } if ($only_exe) { $conn = o2_sqlite3_connect($server, $user, $password, $trans); try { $res = $conn->exec($query); } catch (Exception $o2e) { $conn->rollBack && @$conn->rollBack(); $res = false; throw new o2_exception('<b>SQLite3</b> server: <i>'.$server. '</i><br>query: <code>'.$query.'</code><hr>'. $o2e->getMessage(), o2error_DBEXECUTE); return false; } return $res; } else { $conn = o2_sqlite3_connect($server, $user, $password, $trans); $loop = ($stm || ($stm === 0)); if (!$stm) { try { if ($prepared_pars) { $stm = $conn->prepare($query); } else { $stm = $conn->query($query); } } catch (Exception $o2e) { $conn->rollBack && @$conn->rollBack(); throw new o2_exception('<b>SQLite3</b> server: <i>'.$server. '</i><br>query: <code>'.$query.'</code><hr>'. $o2e->getMessage(), o2error_DBDATAQUERY); return false; } } if ($prepared_pars) { try { $stm->execute($prepared_pars); } catch (Exception $o2e) { $conn->rollBack && @$conn->rollBack(); $q = ($stm ? '<br>query: <code>'.$stm->queryString.'</code>' : $query); throw new o2_exception('<b>SQLite3</b> server: <i>'.$server. '</i>'.$q.'<hr>'.$o2e->getMessage(), o2error_DBDATAQUERY); return false; } } if ($loop) { $set = array(); $num = 0; try { while ((!$limit || $num < $limit) && ($row = $stm->fetch(PDO::FETCH_ASSOC))) { $num++; $set[] = $row; } if ($limit && $num < $limit && !$prepared_pars) { $stm->closeCursor(); $stm = null; } return $set; } catch (Exception $o2e) { $conn->rollBack && @$conn->rollBack(); $q = ($stm ? '<br>query: <code>'.$stm->queryString.'</code>' : $query); throw new o2_exception('<b>SQLite3</b> server: <i>'.$server. '</i>'.$q.'<hr>'.$o2e->getMessage(), o2error_DBDATAQUERY); return false; } } else { try { $data = $stm->fetchAll(PDO::FETCH_ASSOC); if (!$prepared_pars) { $stm->closeCursor(); $stm = null; } return $data; } catch (Exception $o2e) { $stm->closeCursor(); $stm = null; $conn->rollBack && @$conn->rollBack(); throw new o2_exception('<b>SQLite3</b> server: <i>'.$server. '</i><br>query: <code>'.$query. '</code><hr>'.$o2e->getMessage(), o2error_DBDATAQUERY); return false; } } } } function o2_sqlite3_tables($server, $user, $password, $database, $owner) { $query = 'SELECT name FROM sqlite_master '. "WHERE (type='table' OR type='view') AND name LIKE '".$database."%'"; $conn = o2_sqlite3_connect($server, $user, $password, false); try { $res = $conn->query($query)->fetchAll(PDO::FETCH_ASSOC); } catch (Exception $o2e) { throw new o2_exception('<b>SQLite3</b> server: <i>'.$server. '</i><hr>'.$o2e->getMessage(), o2error_DBTABLES); } $tables = array(); foreach ($res as $tab) { $tables[] = $tab['name']; } return $tables; } function o2_sqlite3_tabexists($server, $user, $password, $database, $owner, $table) { $query = 'SELECT 1 AS IT_EXISTS FROM sqlite_master WHERE '. "(type='table' OR type='view') AND name = '".$database.$table."'"; $conn = o2_sqlite3_connect($server, $user, $password, false); try { $res = $conn->query($query)->fetch(PDO::FETCH_ASSOC); } catch (Exception $o2e) { throw new o2_exception('<b>SQLite3</b> server: <i>'.$server. '</i><hr>'.$o2e->getMessage(), o2error_DBTABEXISTS); } return (isset($res['IT_EXISTS']) && $res['IT_EXISTS'] ? true : false); } function o2_sqlite3_tablefields($server, $user, $password, $database, $owner, $table) { $query = 'PRAGMA table_info('.o2_sqlite3_o.$database.$table.o2_sqlite3_c.')'; try { $res = o2_sqlite3_execute($query, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEINFO); throw $o2e; } $arr = array(); foreach ($res as $field) { $arr[] = array('field' => $field['name'], 'type' => $field['type'], 'default' => $field['dflt_value']); } return $arr; } function o2_sqlite3_tableindexes($server, $user, $password, $database, $owner, $table) { $ret_val = array(); $query_local = 'PRAGMA index_list('.o2_sqlite3_o.$database.$table.o2_sqlite3_c.')'; try { $res_local = o2_sqlite3_execute($query_local, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEINFO); throw $o2e; } foreach ($res_local as $single_key) { $key_name = $single_key['name']; if ($key_name != $database.$table.'_PK' && !strpos(strtoupper($key_name), 'AUTOINDEX')) { if (!isset($ret_val[$key_name])) { $ret_val[str_replace($database.$table.'_', '', $key_name)] = array('unique' => $single_key['unique'], 'segments' => array()); } $query_local = 'PRAGMA index_info('.o2_sqlite3_o.$key_name.o2_sqlite3_c.')'; $query_info = 'SELECT '.o2_sqlite3_o.'sql'.o2_sqlite3_c.' '. o2_sqlite3_o.'SQL'.o2_sqlite3_c. ' FROM '.o2_sqlite3_o.'sqlite_master'.o2_sqlite3_c. ' WHERE '.o2_sqlite3_o.'type'.o2_sqlite3_c."='index' and ". o2_sqlite3_o.'tbl_name'.o2_sqlite3_o."='".$table."' and ". o2_sqlite3_o.'name'.o2_sqlite3_c."='".$key_name."'"; try { $res_key = o2_sqlite3_execute($query_local, $server, $user, $password, false, false); $key_info = o2_sqlite3_execute($query_info, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEINFO); throw $o2e; } foreach ($res_key as $single_segment) { $parts = array(); preg_match('/'.o2_sqlite3_o.$single_segment['name'].o2_sqlite3_c. ' (ASC|DESC)/', $key_info[0]['SQL'], $parts); $ret_val[str_replace($database.$table.'_', '', $key_name)]['segments']+= array($single_segment['seqno'] => array('column' => $single_segment['name'], 'dir' => $parts[1] == 'ASC' ? 'A' : 'D')); } } } return $ret_val; } function o2_sqlite3_insertfrom($server, $user, $password, $database_from, $owner_from, $table_from, $database_to, $owner_to, $table_to, $values, $where = '') { $list_from = ''; $list_to = ''; foreach ($values as $field_from => $field_to) { $sep = ($list_from ? ',' : ''); if ($field_from == '@o2CloneArea') { $list_from.= $sep.$field_to; $list_to .= $sep.'O2ASPID'; } else { $list_from.= $sep.$field_from; $list_to .= $sep.$field_to; } } $query = 'INSERT INTO '.o2_sqlite3_o.$database_to.$table_to.o2_sqlite3_c. ' ('.$list_to.') SELECT '.$list_from. ' FROM '.o2_sqlite3_o.$database_from.$table_from.o2_sqlite3_c; if ($where) { $query.= ' WHERE '.$where; } try { $aff_rows = o2_sqlite3_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLECOPY); throw $o2e; return false; } return $aff_rows; } function o2_sqlite3_droptable($server, $user, $password, $database, $owner, $table) { $query_local = 'DROP TABLE '.o2_sqlite3_o.$database.$table.o2_sqlite3_c; try { o2_sqlite3_execute($query_local, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEDROP); throw $o2e; } o2_sqlite3_commit($server, $user, $password, $database); return true; } function o2_sqlite3_renametable($server, $user, $password, $database, $owner, $table, $new_name) { try { $keys_query = array(); $keys = o2_sqlite3_tableindexes($server, $user, $password, $database, $owner, $table); foreach ($keys as $keyname => $key) { $arr_local = array(); foreach ($key['segments'] as $keystructure) { $arr_local[] = o2_sqlite3_o.$keystructure['column'].o2_sqlite3_c. ($keystructure['dir'] == 'D' ? ' DESC' : ' ASC'); } $keys_query[]= 'CREATE'.($key['unique'] ? ' UNIQUE' : '').' INDEX '. o2_sqlite3_o.$database.$new_name."_".$keyname.o2_sqlite3_c. ' ON '.o2_sqlite3_o.$database.$new_name.o2_sqlite3_c.' ('. implode(',', $arr_local).")\n"; } $query_local = 'PRAGMA index_list('.o2_sqlite3_o.$database.$table.o2_sqlite3_c. ')'; $res_local = o2_sqlite3_execute($query_local, $server, $user, $password, false, false); foreach ($res_local as $single_key) { $key_name = $single_key['name']; if (stripos($key_name, 'sqlite_autoindex') === false) { o2_sqlite3_execute('DROP INDEX '.o2_sqlite3_o.$key_name.o2_sqlite3_c, $server, $user, $password, true, true); } } $query_local = 'ALTER TABLE '.o2_sqlite3_o.$database.$table.o2_sqlite3_c. ' RENAME TO '.o2_sqlite3_o.$database.$new_name.o2_sqlite3_c; o2_sqlite3_execute($query_local, $server, $user, $password, true, true); foreach ($keys_query as $single_query) { o2_sqlite3_execute($single_query, $server, $user, $password, true, true); } } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEREBUILD); throw $o2e; } o2_sqlite3_commit($server, $user, $password, $database); return true; } function o2_sqlite3_createtable($server, $user, $password, $database, $owner, $table, $structure, $execute = true) { $query_local = 'CREATE TABLE '.o2_sqlite3_o.$database.$table.o2_sqlite3_c." (\n"; $type = ''; $default = ''; foreach ($structure['fields'] as $field_name => $field_prop) { switch ($field_prop['type']) { case 'A': if ($field_prop['size'] <= 255) { $type = 'varchar('.$field_prop['size'].')'; } elseif ($field_prop['size'] <= 65530) { $type = 'text'; } else { $type = 'longtext'; } $default = "''"; break; case 'N': $type = ($field_prop['dec'] ? 'numeric('.($field_prop['int'] + $field_prop['dec']).', '. $field_prop['dec'].')' : ($field_prop['int'] > 9 ? 'bigint('.$field_prop['int'].')' : 'integer')); $default = '0'; break; case 'L': $type = 'char(1)'; $default = "'0'"; break; case 'D': $type = 'char(8)'; $default = "'00000000'"; break; case 'T': $type = 'char(6)'; $default = "'000000'"; break; case 'S': $type = 'text'; $default = "''"; break; } $query_local.= $field_name.' '.$type.' NOT NULL DEFAULT '.$default.",\n"; } $arr_local = array(); foreach ($structure['primary'] as $pk_name => $pk_segments) { foreach ($pk_segments as $field_name => $direction) { $arr_local[] = $field_name.($direction == 'D' ? ' DESC' : ' ASC'); } break; } $query_local.= 'CONSTRAINT '.$database.$table.'_PK PRIMARY KEY ('. implode(',', $arr_local)."))\n"; $indexes_queries = array(); foreach ($structure['keys'] as $index_name => $index_segs) { $arr_local = array(); foreach ($index_segs as $field_name => $direction) { $arr_local[] = $field_name.($direction == 'D' ? ' DESC' : ' ASC'); } $indexes_queries[]= 'CREATE UNIQUE INDEX '. o2_sqlite3_o.$database.$table.'_'.$index_name.o2_sqlite3_c. ' ON '.o2_sqlite3_o.$database.$table.o2_sqlite3_c.' ('. implode(',', $arr_local).")\n"; } foreach ($structure['indexes'] as $index_name => $index_segs) { $arr_local = array(); foreach ($index_segs as $field_name => $direction) { $arr_local[] = $field_name.($direction == 'D' ? ' DESC' : ' ASC'); } $indexes_queries[]= 'CREATE INDEX '. o2_sqlite3_o.$database.$table.'_'.$index_name.o2_sqlite3_c. ' ON '.o2_sqlite3_o.$database.$table.o2_sqlite3_c.' ('. implode(',', $arr_local).")\n"; } if ($execute) { try { o2_sqlite3_execute($query_local, $server, $user, $password, true, true); foreach ($indexes_queries as $single_query) { o2_sqlite3_execute($single_query, $server, $user, $password, true, true); } } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLECREATE); throw $o2e; } o2_sqlite3_commit($server, $user, $password, $database); return true; } else { return $query_local; } } function o2_sqlite3_aggregate($server, $user, $password, $database, $owner, $table, $table_alias, $where, $functions, $links = null) { $functions_list = ''; foreach ($functions as $func_name => $single_func) { $functions_list.= ($functions_list ? ',' : ''). $single_func['func'].'('.$single_func['field']. ') AS '.o2_sqlite3_o.$func_name.o2_sqlite3_c; } if (substr($table, 0, 1) != '(') { $table = o2_sqlite3_o.$database.$table.o2_sqlite3_c; } $query = 'SELECT '.$functions_list. ' FROM '.$table.' AS '.o2_sqlite3_o.$table_alias.o2_sqlite3_c; if ($links) { foreach ($links as $linktab => $linkon) { if ($database) { $linktab = substr($linktab, 0, 1).$database.substr($linktab, 1); } $query.= ' LEFT JOIN '.$linktab.' ON '.$linkon; } } if ($where) { $query.= ' WHERE '.$where; } try { $res_local = o2_sqlite3_execute($query, $server, $user, $password, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBAGGREGATE); throw $o2e; } return $res_local[0]; } function o2_sqlite3_verifyrec($server, $user, $password, $database, $owner, $table, $table_alias, $select_str, $where, $order_by) { if (substr($table, 0, 1) != '(') { $table = o2_sqlite3_o.$database.$table.o2_sqlite3_c; } $query = 'SELECT '.$select_str.' FROM '.$table. ' AS '.o2_sqlite3_o.$table_alias.o2_sqlite3_c; if ($where) { $query.= ' WHERE '.$where; } if ($order_by) { $query.= ' ORDER BY '.$order_by; } $query.= ' LIMIT 1'; try { $res = o2_sqlite3_execute($query, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECQUERY); throw $o2e; } if (!$res || $res === array()) { return false; } else { return $res[0]; } } function o2_sqlite3_modifyrec($server, $user, $password, $database, $owner, $table, $table_alias, $sets, $where) { $upd_str = ''; foreach ($sets as $field => $value) { $upd_str.= ($upd_str ? ',' : '').$field.' = '.$value; } $where = str_replace(o2_sqlite3_o.$table_alias.o2_sqlite3_c.'.', '', $where); $query = 'UPDATE '.o2_sqlite3_o.$database.$table.o2_sqlite3_c. ' SET '.$upd_str.' WHERE '.$where; try { o2_sqlite3_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECUPDATE); throw $o2e; } return true; } function o2_sqlite3_insertrec($server, $user, $password, $database, $owner, $table, $table_alias, $fields, $values) { $query_local = 'INSERT INTO '.o2_sqlite3_o.$database.$table.o2_sqlite3_c. ' ('.implode(',', $fields).') VALUES ('.implode(',', $values).')'; try { o2_sqlite3_execute($query_local, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECINSERT); throw $o2e; } return true; } function o2_sqlite3_deleterec($server, $user, $password, $database, $owner, $table, $table_alias, $where) { $query = 'DELETE FROM '.o2_sqlite3_o.$database.$table.o2_sqlite3_c; if ($where) { $where = str_replace(o2_sqlite3_o.$table_alias.o2_sqlite3_c.'.', '', $where); $query.= ' WHERE '.$where; } if (isset($GLOBALS['jxviewsql'])) { $GLOBALS['jxviewsql'] = $query; return true; } try { o2_sqlite3_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECDELETE); throw $o2e; } return true; } function o2_sqlite3_count($server, $user, $password, $database, $owner, $table, $table_alias, $where, $links = null) { if (substr($table, 0, 1) != '(') { $table = o2_sqlite3_o.$database.$table.o2_sqlite3_c; } $query = 'SELECT COUNT(*) AS COMPUTED FROM '.$table. ' AS '.o2_sqlite3_o.$table_alias.o2_sqlite3_c; if ($links) { foreach ($links as $linktab => $linkon) { if ($database) { $linktab = substr($linktab, 0, 1).$database.substr($linktab, 1); } $query.= ' LEFT JOIN '.$linktab.' ON '.$linkon; } } if ($where) { $query.= ' WHERE '.$where; } if ($_SESSION['o2_app']->sqltrace) { o2log($query); } $conn = o2_sqlite3_connect($server, $user, $password, false); try { $dset = $conn->query($query)->fetchAll(PDO::FETCH_ASSOC); } catch (Exception $o2e) { $rb = $conn->rollBack; $rb && @$rb(); throw new o2_exception('<b>SQLite3</b> server: <i>'.$server. '</i><br>Error counting dataset.<hr><code>'. $query.'</code><br><br>'.$o2e->getMessage(), o2error_DBCOUNT); return false; } return intval($dset[0]['COMPUTED']); } function o2_sqlite3_recordset($server, $user, $password, $database, $owner, $table, $table_alias, $select_str, $where, $order_by, $recs, $links = null, $lock = false, $page_where = false, $stm_id = false, $prepared_pars = false) { if ($page_where) { if ($stm_id && isset($GLOBALS['o2_sqlite3_stms'][$stm_id])) { return o2_sqlite3_execute(false, $server, $user, $password, false, false, $recs, $GLOBALS['o2_sqlite3_stms'][$stm_id], $prepared_pars); } $where = $page_where.$where; } elseif ($stm_id && isset($GLOBALS['o2_sqlite3_stms'][$stm_id]) && !$prepared_pars) { if ($GLOBALS['o2_sqlite3_stms'][$stm_id]) { $GLOBALS['o2_sqlite3_stms'][$stm_id]->closeCursor(); } $GLOBALS['o2_sqlite3_stms'][$stm_id] = null; unset($GLOBALS['o2_sqlite3_stms'][$stm_id]); } if (substr($table, 0, 1) != "(") { $table = o2_sqlite3_o.$database.$table.o2_sqlite3_c; } $query = 'SELECT '.$select_str.' FROM '.$table. ' AS '.o2_sqlite3_o.$table_alias.o2_sqlite3_c; if ($links) { foreach ($links as $linktab => $linkon) { if ($database) { $linktab = substr($linktab, 0, 1).$database.substr($linktab, 1); } $query.= ' LEFT JOIN '.$linktab.' ON '.$linkon; } } if ($where) { $query.= ' WHERE '.$where; } if ($order_by && (!isset($GLOBALS['jxviewsql']) || (strpos($GLOBALS['jxviewsql'], 'O') !== false))) { $query.= ' ORDER BY '.$order_by; } if ($stm_id && $prepared_pars && isset($GLOBALS['o2_sqlite3_stms'][$stm_id])) { $stm = $GLOBALS['o2_sqlite3_stms'][$stm_id]; } elseif ($stm_id) { $stm = 0; } else { $stm = false; if ((strtoupper(substr($select_str, 0, 8)) != 'DISTINCT') && (!isset($GLOBALS['jxviewsql']) || (strpos($GLOBALS['jxviewsql'], 'L') !== false))) { $query.= ' LIMIT '.$recs; } } if (isset($GLOBALS['jxviewsql'])) { $GLOBALS['jxviewsql'] = $query; return array(); } try { $res = o2_sqlite3_execute($query, $server, $user, $password, false, $lock, $recs, $stm, $prepared_pars); if ($stm_id) { if ($stm) { $GLOBALS['o2_sqlite3_stms'][$stm_id] = $stm; } elseif (isset($GLOBALS['o2_sqlite3_stms'][$stm_id])) { $GLOBALS['o2_sqlite3_stms'][$stm_id] = null; unset($GLOBALS['o2_sqlite3_stms'][$stm_id]); } } unset($stm); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBDATAQUERY); throw $o2e; } return $res; } function o2_sqlite3_fkeyadd($server, $user, $password, $main_db, $main_owner, $main_table, $main_fields, $ref_db, $ref_owner, $ref_table, $ref_fields, $key_name) { return false; } function o2_sqlite3_fkeyremove($server, $user, $password, $database, $owner, $table, $key_name) { return false; } function o2_sqlite3_fkeyvalidate($server, $user, $password, $database, $owner, $table, $key_name) { return false; } function o2_sqlite3_fkeystablist($server, $user, $password, $database, $owner, $table) { return array(); } function o2_sqlite3_fkeysinfo($server, $user, $password, $database, $owner) { return array(); } function o2_sqlite3_commit($server, $user, $password, $end = false) { $app = $_SESSION['o2_app']; if (!$server) { $server = $app->dir_data.$app->nome.'.db'; } elseif (strpos(':session:', strtolower($server)) === 0) { if (strtolower($server) == ':session:') { $server = $app->dir_tmp.$app->nome.'.db'; } else { $server = $app->dir_tmp.substr($server, 9); } } elseif (strpos(':memory:', strtolower($server)) === false && basename($server) == $server) { $server = $app->dir_data.$server; } if (isset($GLOBALS['o2_sqlite3_trans'][$server])) { if (isset($GLOBALS['o2_sqlite3_error'][$server])) { $GLOBALS['o2_sqlite3_conn'][$server]->rollBack(); unset($GLOBALS['o2_sqlite3_error'][$server]); } else { if ($end) { if (is_array($GLOBALS['o2_sqlite3_stms'])) { foreach ($GLOBALS['o2_sqlite3_stms'] as $id => $stm) { if ($GLOBALS['o2_sqlite3_stms'][$id]) { $GLOBALS['o2_sqlite3_stms'][$id]->closeCursor(); } $GLOBALS['o2_sqlite3_stms'][$id] = null; $stm = null; } } $GLOBALS['o2_sqlite3_stms'] = array(); } try { $GLOBALS['o2_sqlite3_conn'][$server]->commit(); } catch (Exception $o2e) { throw new o2_exception('<b>SQLite3</b> server: <i>'.$server. '</i><hr>'.$o2e->getMessage(), o2error_DBCOMMIT); } } unset($GLOBALS['o2_sqlite3_trans'][$server]); } if ($end && isset($GLOBALS['o2_sqlite3_conn'][$server])) { unset($GLOBALS['o2_sqlite3_conn'][$server]); } } ?>
