<?php

/**
 * Janox Runtime
 * PHP5
 *
 * This file is part of Janox.
 *
 * THIS FILE HAS BEEN COMPRESSED TO SPEED UP EXECUTION.
 * See file src/jxdb_mssql.inc for a readable version of this script.
 */

 if (extension_loaded("pdo_sqlsrv")) { $GLOBALS['dsn'] = "sqlsrv:server="; } elseif (extension_loaded("pdo_dblib")) { $GLOBALS['dsn'] = "mssql:host="; } else { throw new o2_exception("<b>MSSQL (neither SQLSRV nor FreeTDS) PDO</b> driver not ". "loaded:<br />check your PHP configuration for ". "<i>php_pdo_sqlsrv_*</i> or <i>php_pdo_dblib</i> extensions.", o2error_DBCONNECT); } define("o2_mssql_o", "["); define("o2_mssql_c", "]"); $GLOBALS['o2_mssql_conn'] = array(); $GLOBALS['o2_mssql_trans'] = array(); $GLOBALS['o2_mssql_stms'] = array(); $GLOBALS['o2_mssql_error'] = array(); function o2_mssql_normalize($string, $untrim = false) { return strtr(($untrim ? $string : trim($string)), array("'" => "''")); } function o2_mssql_concat($strings) { return 'CONCAT('.implode(',', $strings).')'; } function o2_mssql_qualify($database, $owner, $name = "") { return o2_mssql_o.$database.o2_mssql_c.".". o2_mssql_o.$owner.o2_mssql_c. ($name ? ".".o2_mssql_o.$name.o2_mssql_c : ""); } function o2_mssql_connect($server, $user, $password, $trans) { $app = $_SESSION['o2_app']; if (!$server) { $server = "localhost"; } if ($app->chr_encoding) { switch (strtolower(str_replace(array("-", "_"), "", $app->chr_encoding))) { case "windows1252": case "cp1252": $utf8 = false; break; case "utf8": $utf8 = true; break; } } if ($app->isolated_trans) { $key = $server.$user."jxext"; } else { $key = $server.$user; } $attr = array(PDO::ATTR_CASE => PDO::CASE_UPPER, PDO::SQLSRV_ATTR_ENCODING => ($utf8 ? PDO::SQLSRV_ENCODING_UTF8 : PDO::SQLSRV_ENCODING_SYSTEM), PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION); if (!isset($GLOBALS['o2_mssql_conn'][$key])) { try { $conn_local = new PDO($GLOBALS['dsn'].$server, $user, $password, $attr); } catch (Exception $o2e) { throw new o2_exception('<b>MSSQL</b> server: <i>'.$server. '</i><hr>'.$o2e->getMessage(), o2error_DBCONNECT); } if ($app->db_timeout_lock) { $conn_local->exec('SET lock_timeout '.intval($app->db_timeout_lock)); } if ($trans) { try { $conn_local->beginTransaction(); $conn_local->exec("SET XACT_ABORT ON"); } catch (Exception $o2e) { throw new o2_exception('<b>MSSQL</b> server: <i>'.$server. '</i><hr>'.$o2e->getMessage(), o2error_DBCONNECT); } $GLOBALS['o2_mssql_trans'][$key] = true; } $GLOBALS['o2_mssql_conn'][$key] = $conn_local; } elseif ($trans && !isset($GLOBALS['o2_mssql_trans'][$key])) { $conn_local = $GLOBALS['o2_mssql_conn'][$key]; try { $conn_local->beginTransaction(); $conn_local->exec("SET XACT_ABORT ON"); } catch (Exception $o2e) { throw new o2_exception('<b>MSSQL</b> server: <i>'.$server. '</i><hr>'.$o2e->getMessage(), o2error_DBCONNECT); } $GLOBALS['o2_mssql_trans'][$key] = true; } return $GLOBALS['o2_mssql_conn'][$key]; } function o2_mssql_execute($query, $server, $user, $password, $only_exe = false, $trans = true, $limit = 0, &$stm = false, $prepared_pars = false) { if ($_SESSION['o2_app']->sqltrace && !$stm) { if ($stm === 0) { o2log('(Start fetching) '.$query); } else { if ($prepared_pars) { $ppars = "\nWith parameters: ".print_r($prepared_pars, 1); } o2log($query.$ppars); } } if ($only_exe) { $conn = o2_mssql_connect($server, $user, $password, $trans); try { $res = $conn->exec($query); } catch (Exception $o2e) { $conn->rollBack && @$conn->rollBack(); $res = false; throw new o2_exception('<b>MSSQL</b> server: <i>'.$server. '</i><br>query: <code>'.$query. '</code><hr>'.$o2e->getMessage(), o2error_DBEXECUTE); return false; } return $res; } else { $conn = o2_mssql_connect($server, $user, $password, $trans); $loop = ($stm || ($stm === 0)); if (!$stm) { try { if ($prepared_pars) { $stm = $conn->prepare($query); } else { $stm = $conn->query($query); } } catch (Exception $o2e) { $conn->rollBack && @$conn->rollBack(); throw new o2_exception('<b>MSSQL</b> server: <i>'.$server. '</i><br>query: <code>'.$query. '</code><hr>'.$o2e->getMessage(), o2error_DBDATAQUERY); return false; } } if ($prepared_pars) { $stm->execute($prepared_pars); } if ($loop) { $set = array(); $num = 0; try { while($stm->columnCount() === 0 && $stm->nextRowset()) { } while ((!$limit || $num < $limit) && ($row = $stm->fetch(PDO::FETCH_ASSOC))) { $num++; $set[] = $row; } if ($limit && $num < $limit && !$prepared_pars) { $stm->closeCursor(); $stm = null; } return $set; } catch (Exception $o2e) { $conn->rollBack && @$conn->rollBack(); $q = ($stm ? '<br>query: <code>'.$stm->queryString.'</code>' : $query); throw new o2_exception('<b>MSSQL</b> server: <i>'.$server. '</i>'.$q.'<hr>'.$o2e->getMessage(), o2error_DBDATAQUERY); return false; } } else { try { while($stm->columnCount() === 0 && $stm->nextRowset()) { } $data = $stm->fetchAll(PDO::FETCH_ASSOC); if (!$prepared_pars) { $stm->closeCursor(); $stm = null; } return $data; } catch (Exception $o2e) { $stm->closeCursor(); $stm = null; $conn->rollBack && @$conn->rollBack(); throw new o2_exception('<b>MSSQL</b> server: <i>'.$server. '</i><br>query: <code>'.$query. '</code><hr>'.$o2e->getMessage(), o2error_DBDATAQUERY); return false; } } } } function o2_mssql_tables($server, $user, $password, $database, $owner) { $query = "USE ".o2_mssql_o.$database.o2_mssql_c; o2_mssql_execute($query, $server, $user, $password, false, false); $query = "EXEC sp_tables @table_qualifier = '".$database."', ". "@table_owner = '".$owner."'"; try { $res = o2_mssql_execute($query, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLES); throw $o2e; } $tables = array(); foreach ($res as $table) { $tables[] = $table['TABLE_NAME']; } return $tables; } function o2_mssql_tabexists($server, $user, $password, $database, $owner, $table) { $query = "SELECT 1 AS IT_EXISTS FROM ".o2_mssql_o.$database.o2_mssql_c.".". o2_mssql_o.$owner.o2_mssql_c. ".sysobjects WHERE (type='U' OR type='V') AND name='".$table."'"; try { $res = o2_mssql_execute($query, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABEXISTS); throw $o2e; } return (isset($res[0]["IT_EXISTS"]) && $res[0]["IT_EXISTS"] ? true : false); } function o2_mssql_tablefields($server, $user, $password, $database, $owner, $table) { try { $query = "USE ".o2_mssql_o.$database.o2_mssql_c.";\n"; o2_mssql_execute($query, $server, $user, $password, true, false); $query = "EXEC sp_columns @table_qualifier = '".$database."', ". "@table_owner = '".$owner."', ". "@table_name = '".$table."'\n"; $res = o2_mssql_execute($query, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEINFO); throw $o2e; } $arr = array(); foreach ($res as $field) { $arr[] = array('field' => $field['COLUMN_NAME'], 'type' => $field['TYPE_NAME']. ($field['TYPE_NAME'] != 'text' ? '('.$field['LENGTH'].')' : ''), 'default' => str_replace('(', '', str_replace(')', '', str_replace("'", '', $field['COLUMN_DEF'])))); } return $arr; } function o2_mssql_tableindexes($server, $user, $password, $database, $owner, $table) { $ret_val = array(); try { $query = 'USE '.o2_mssql_o.$database.o2_mssql_c; o2_mssql_execute($query, $server, $user, $password, true, false); $query = 'EXEC sp_helpindex '.o2_mssql_o.$table.o2_mssql_c; $res_local = o2_mssql_execute($query, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $res_local = array(); $o2e->set_error_class(o2error_DBTABLEINFO); throw $o2e; } foreach ($res_local as $single_key) { if (strtoupper($single_key['INDEX_NAME']) != 'JXPK_'.strtoupper($table)) { $seq_no = 0; $unique = stripos($single_key['INDEX_DESCRIPTION'], 'unique') !== false; $ret_val[$single_key['INDEX_NAME']] = array('unique' => $unique, 'segments' => array()); foreach (explode(",", $single_key['INDEX_KEYS']) as $single_segment) { if (strpos($single_segment, "(-)")) { $single_segment = trim(str_replace('(-)', '', $single_segment)); $dir_local = 'D'; } else { $single_segment = trim($single_segment); $dir_local = 'A'; } $ret_val[$single_key['INDEX_NAME']]['segments']+= array($seq_no => array('column' => $single_segment, 'dir' => $dir_local)); $seq_no++; } } } return $ret_val; } function o2_mssql_insertfrom($server, $user, $password, $database_from, $owner_from, $table_from, $database_to, $owner_to, $table_to, $values, $where = '') { $list_from = ''; $list_to = ''; foreach ($values as $field_from => $field_to) { $sep = ($list_from ? ',' : ''); if ($field_from == '@o2CloneArea') { $list_from.= $sep.$field_to; $list_to .= $sep.'O2ASPID'; } else { $list_from.= $sep.$field_from; $list_to .= $sep.$field_to; } } $query = 'INSERT INTO '.o2_mssql_o.$database_to.o2_mssql_c.'.'. o2_mssql_o.$owner_to.o2_mssql_c.'.'. o2_mssql_o.$table_to.o2_mssql_c. ' ('.$list_to.') SELECT '.$list_from. ' FROM '.o2_mssql_o.$database_from.o2_mssql_c.'.'. o2_mssql_o.$owner_from.o2_mssql_c.'.'. o2_mssql_o.$table_from.o2_mssql_c; if ($where) { $query.= ' WHERE '.$where; } try { $aff_rows = o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLECOPY); throw $o2e; return false; } return $aff_rows; } function o2_mssql_droptable($server, $user, $password, $database, $owner, $table) { $query = 'DROP TABLE '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c."\n"; try { o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEDROP); throw $o2e; } o2_mssql_commit($server, $user, $password, $database); return true; } function o2_mssql_renametable($server, $user, $password, $database, $owner, $table, $new_name) { try { $query = 'USE '.o2_mssql_o.$database.o2_mssql_c."\n"; o2_mssql_execute($query, $server, $user, $password, true, false); $query = 'EXEC sp_helpindex '.o2_mssql_o.$table.o2_mssql_c; $res = o2_mssql_execute($query, $server, $user, $password, false, false); $query = "EXEC sp_rename '".$database.'.'.$owner.'.'.$table."', "."'". $new_name."'\n"; o2_mssql_execute($query, $server, $user, $password, true, true); foreach ($res as $single_key) { if (strtoupper($single_key['INDEX_NAME']) == 'JXPK_'.strtoupper($table)) { $query = "EXEC sp_rename '".$single_key['INDEX_NAME']."','JXPK_". $new_name."','OBJECT'"; o2_mssql_execute($query, $server, $user, $password, true, true); break; } } } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEREBUILD); throw $o2e; } o2_mssql_commit($server, $user, $password, $database); return true; } function o2_mssql_createtable($server, $user, $password, $database, $owner, $table, $structure, $execute = true) { $query = 'CREATE TABLE '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c." (\n"; $type = ''; $default = ''; foreach ($structure['fields'] as $field_name => $field_prop) { $query.= o2_mssql_field_create($field_name, $field_prop['type'], $field_prop['size'], $field_prop['int'], $field_prop['dec']).",\n"; } $query = substr($query, 0, -2).")\n"; $query.= "ALTER TABLE ".o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c."\n"; $arr_local = array(); foreach ($structure['primary'] as $pk_name => $pk_segments) { break; } $query.= 'ADD CONSTRAINT JXPK_'.$table.' PRIMARY KEY CLUSTERED ('. o2_mssql_indexfields_create($pk_segments).") ON [PRIMARY]\n"; foreach ($structure['keys'] as $index_name => $index_segs) { $query.= o2_mssql_index_create($index_name, $index_segs, $table, $database, $owner, true)."\n"; } foreach ($structure['indexes'] as $index_name => $index_segs) { $query.= o2_mssql_index_create($index_name, $index_segs, $table, $database, $owner, false)."\n"; } if ($execute) { try { o2_mssql_execute($query, $server, $user, $password, true, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLECREATE); throw $o2e; } o2_mssql_commit($server, $user, $password, $database); return true; } else { return $query; } } function o2_mssql_field_create($name, $type, $size, $int, $dec, $for_change = false) { switch ($type) { case 'A': if ($size <= 8000) { $ftype = 'VARCHAR('.$size.')'; } else { $ftype = 'VARCHAR(max)'; } $default = "('')"; break; case 'N': if ($dec) { $ftype = 'DECIMAL('.($int + $dec).', '.$dec.')'; } elseif ($int < 5) { $ftype = 'SMALLINT'; } elseif ($int < 10) { $ftype = 'INT'; } else { $ftype = 'BIGINT'; } $default = '(0)'; break; case 'L': $ftype = 'CHAR(1)'; $default = "('0')"; break; case 'D': $ftype = 'CHAR(8)'; $default = "('00000000')"; break; case 'T': $ftype = 'CHAR(6)'; $default = "('000000')"; break; case 'S': $ftype = 'VARCHAR(max)'; $default = "('')"; break; } if ($for_change) { return $name.' '.$ftype.' NOT NULL'; } else { return $name.' '.$ftype.' NOT NULL DEFAULT '.$default; } } function o2_mssql_index_create($key_name, $key_segs, $table, $database, $owner, $unique = true) { return 'CREATE'.($unique ? ' UNIQUE' : ''). ' NONCLUSTERED INDEX '.o2_mssql_o.$key_name.o2_mssql_c. ' ON '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c. ' ('.o2_mssql_indexfields_create($key_segs).')'; } function o2_mssql_indexfields_create($fields) { $str = ''; foreach ($fields as $field => $direction) { $str.= ($str ? ',' : '').$field.($direction == 'D' ? ' DESC' : ' ASC'); } return $str; } function o2_mssql_field_add($server, $user, $password, $database, $owner, $table, $field_name, $field_type, $field_size, $field_int, $field_dec) { $query = 'ALTER TABLE '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c. ' ADD '.o2_mssql_field_create(o2_mssql_o.$field_name.o2_mssql_c, $field_type, $field_size, $field_int, $field_dec); try { $res = o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; } } function o2_mssql_field_remove($server, $user, $password, $database, $owner, $table, $field_name) { $query = 'select o.[NAME] from '. o2_mssql_o.$database.o2_mssql_c.'.sys.sysobjects o inner join '. o2_mssql_o.$database.o2_mssql_c. '.sys.syscolumns c on o.id = c.cdefault inner join '. o2_mssql_o.$database.o2_mssql_c. ".sys.sysobjects t on c.id = t.id where o.xtype = 'D' and t.name = '".$table. "' and c.name = '".$field_name."'"; try { $res = o2_mssql_execute($query, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; } if ($res[0]['NAME']) { $query = 'ALTER TABLE '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c. ' DROP CONSTRAINT '.o2_mssql_o.$res[0]['NAME'].o2_mssql_c; try { $res = o2_mssql_execute($query, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; } } $query = 'ALTER TABLE '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c. ' DROP COLUMN '.o2_mssql_o.$field_name.o2_mssql_c; try { $res = o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; } } function o2_mssql_field_change($server, $user, $password, $database, $owner, $table, $field_name, $field_type, $field_size, $field_int, $field_dec) { $query = 'SELECT COLUMN_DEFAULT AS [DEFAULT] FROM '.o2_mssql_o.$database.o2_mssql_c. ".INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='".$owner. "' AND TABLE_NAME = '".$table. "' AND COLUMN_NAME = '".$field_name."'"; try { $res = o2_mssql_execute($query, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; return false; } if ($res[0]['DEFAULT']) { $default = '('.ltrim(rtrim($res[0]['DEFAULT'], ')'), '(').')'; } else { $default = false; } $query = 'select o.[NAME] from '. o2_mssql_o.$database.o2_mssql_c.'.sys.sysobjects o inner join '. o2_mssql_o.$database.o2_mssql_c. '.sys.syscolumns c on o.id = c.cdefault inner join '. o2_mssql_o.$database.o2_mssql_c. ".sys.sysobjects t on c.id = t.id where o.xtype = 'D' and t.name = '".$table. "' and c.name = '".$field_name."'"; try { $res = o2_mssql_execute($query, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; return false; } if ($res[0]['NAME']) { $const = $res[0]['NAME']; $query = 'ALTER TABLE '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c. ' DROP CONSTRAINT '.o2_mssql_o.$const.o2_mssql_c; try { o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; return false; } } $query = 'ALTER TABLE '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c. ' ALTER COLUMN '.o2_mssql_field_create(o2_mssql_o.$field_name.o2_mssql_c, $field_type, $field_size, $field_int, $field_dec, true); try { o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; } if ($default !== false) { $query = 'ALTER TABLE '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c. ' ADD CONSTRAINT '.o2_mssql_o.$const.o2_mssql_c. ' DEFAULT '.$default.' FOR '.o2_mssql_o.$field_name.o2_mssql_c; try { o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; return false; } } } function o2_mssql_field_rename($server, $user, $password, $database, $owner, $table, $old_name, $new_name) { $query = "EXEC sp_rename '".$database.'.'. $owner.'.'. $table.'.'. $old_name."', '". $new_name."', 'COLUMN'"; try { $res = o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; } } function o2_mssql_index_add($server, $user, $password, $database, $owner, $table, $index_name, $key_segs, $unique = true) { $quoted_segs = array(); foreach ($key_segs as $field_name => $direction) { if ($field_name != 'O2ASPID') { $quoted_segs[o2_mssql_o.$field_name.o2_mssql_c] = $direction; } else { $quoted_segs[$field_name] = $direction; } } $query = o2_mssql_index_create($index_name, $quoted_segs, $table, $database, $owner, $unique); try { o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; } } function o2_mssql_index_remove($server, $user, $password, $database, $owner, $table, $index_name) { $query = 'DROP INDEX '.o2_mssql_o.$index_name.o2_mssql_c. ' ON '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c; try { o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; } } function o2_mssql_aggregate($server, $user, $password, $database, $owner, $table, $table_alias, $where, $functions, $links = null) { $functions_list = ''; foreach ($functions as $func_name => $single_func) { $functions_list.= ($functions_list == '' ? '' : ','). $single_func['func'].'('.$single_func['field'].') '. 'AS '.$func_name; } if (substr($table, 0, 1) != '(') { $table = o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c; } $query = 'SELECT '.$functions_list. ' FROM '.$table.' AS '.o2_mssql_o.$table_alias.o2_mssql_c; if ($links) { foreach ($links as $linktab => $linkon) { $query.= ' LEFT JOIN '.$linktab.' ON '.$linkon; } } if ($where) { $query.= ' WHERE '.$where; } try { $res = o2_mssql_execute($query, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBAGGREGATE); throw $o2e; } return $res[0]; } function o2_mssql_verifyrec($server, $user, $password, $database, $owner, $table, $table_alias, $select_str, $where, $order_by) { if (substr($table, 0, 1) != '(') { $table = o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c; } $query = 'SELECT TOP 1 '.$select_str.' FROM '.$table. ' AS '.o2_mssql_o.$table_alias.o2_mssql_c; if ($where) { $query.= ' WHERE '.$where; } if ($order_by) { $query.= ' ORDER BY '.$order_by; } try { $res = o2_mssql_execute($query, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECQUERY); throw $o2e; } if (!$res || $res === array()) { return false; } else { return $res[0]; } } function o2_mssql_modifyrec($server, $user, $password, $database, $owner, $table, $table_alias, $sets, $where) { $upd_str = ''; foreach ($sets as $field => $value) { $upd_str.= ($upd_str != '' ? ',' : ''). o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c.'.'.$field.' = '.$value; } $query = 'UPDATE '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c. ' SET '.$upd_str. ' FROM '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c. ' AS '.o2_mssql_o.$table_alias.o2_mssql_c. ' WHERE '.$where; try { o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECUPDATE); throw $o2e; } return true; } function o2_mssql_insertrec($server, $user, $password, $database, $owner, $table, $table_alias, $fields, $values) { $query = 'INSERT INTO '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c. ' ('.implode(',', $fields).') VALUES ('.implode(',', $values).')'; try { o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECINSERT); throw $o2e; } return true; } function o2_mssql_deleterec($server, $user, $password, $database, $owner, $table, $table_alias, $where) { $query = 'DELETE '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c. ' FROM '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c; if ($where) { $query.= ' AS '.o2_mssql_o.$table_alias.o2_mssql_c.' WHERE '.$where; } if (isset($GLOBALS['jxviewsql'])) { $GLOBALS['jxviewsql'] = $query; return true; } try { o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECDELETE); throw $o2e; } return true; } function o2_mssql_count($server, $user, $password, $database, $owner, $table, $table_alias, $where, $links = null) { if (substr($table, 0, 1) != '(') { $table = o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c; } $query = 'SELECT COUNT(*) AS COMPUTED FROM '.$table. ' AS '.o2_mssql_o.$table_alias.o2_mssql_c; if ($links) { foreach ($links as $linktab => $linkon) { $query.= ' LEFT JOIN '.$linktab.' ON '.$linkon; } } if ($where) { $query.= ' WHERE '.$where; } if ($_SESSION['o2_app']->sqltrace) { o2log($query); } $conn = o2_mssql_connect($server, $user, $password, false); try { $res = $conn->query($query); $dset = $res->fetchAll(PDO::FETCH_ASSOC); } catch (o2_exception $o2e) { $rb = $conn->rollBack; $rb && @$rb(); $o2e->set_error_class(o2error_DBCOUNT); throw $o2e; return false; } return intval($dset[0]['COMPUTED']); } function o2_mssql_recordset($server, $user, $password, $database, $owner, $table, $table_alias, $select_str, $where, $order_by, $recs, $links = null, $lock = false, $page_where = false, $stm_id = false, $prepared_pars = false) { if ($page_where) { if ($stm_id && isset($GLOBALS['o2_mssql_stms'][$stm_id])) { return o2_mssql_execute(false, $server, $user, $password, false, false, $recs, $GLOBALS['o2_mssql_stms'][$stm_id], $prepared_pars); } $where = $page_where.$where; } elseif ($stm_id && isset($GLOBALS['o2_mssql_stms'][$stm_id]) && !$prepared_pars) { if ($GLOBALS['o2_mssql_stms'][$stm_id]) { $GLOBALS['o2_mssql_stms'][$stm_id]->closeCursor(); } $GLOBALS['o2_mssql_stms'][$stm_id] = null; unset($GLOBALS['o2_mssql_stms'][$stm_id]); } if (substr($table, 0, 1) != '(') { $table = o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c; } $query = 'SELECT '; if ($stm_id && $prepared_pars && isset($GLOBALS['o2_mssql_stms'][$stm_id])) { $stm = $GLOBALS['o2_mssql_stms'][$stm_id]; } elseif ($stm_id) { $stm = 0; } else { $stm = false; if ((strtoupper(substr($select_str, 0, 8)) != 'DISTINCT') && (!isset($GLOBALS['jxviewsql']) || (strpos($GLOBALS['jxviewsql'], 'L') !== false))) { $query.= 'TOP '.$recs.' '; } } $query.= $select_str.' FROM '.$table.' AS '.o2_mssql_o.$table_alias.o2_mssql_c; if ($lock) { $query.= ' WITH (UPDLOCK, ROWLOCK)'; } if ($links) { foreach ($links as $linktab => $linkon) { $query.= ' LEFT JOIN '.$linktab.' ON '.$linkon; } } if ($where) { $query.= ' WHERE '.$where; } if ($order_by && (!isset($GLOBALS['jxviewsql']) || (strpos($GLOBALS['jxviewsql'], 'O') !== false))) { $query.= ' ORDER BY '.$order_by; } if (isset($GLOBALS['jxviewsql'])) { $GLOBALS['jxviewsql'] = $query; return array(); } try { $res = o2_mssql_execute($query, $server, $user, $password, false, ($stm_id || $lock ? true : false), $recs, $stm, $prepared_pars); if ($stm_id) { if ($stm) { $GLOBALS['o2_mssql_stms'][$stm_id] = $stm; } elseif (isset($GLOBALS['o2_mssql_stms'][$stm_id])) { $GLOBALS['o2_mssql_stms'][$stm_id] = null; unset($GLOBALS['o2_mssql_stms'][$stm_id]); } } unset($stm); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBDATAQUERY); throw $o2e; } return $res; } function o2_mssql_fkeyadd($server, $user, $password, $main_db, $main_owner, $main_table, $main_fields, $ref_db, $ref_owner, $ref_table, $ref_fields, $key_name) { $query = 'USE '.o2_mssql_o.$main_db.o2_mssql_c; o2_mssql_execute($query, $server, $user, $password, false, false); $main_list = array(); $ref_list = array(); foreach ($main_fields as $field) { if ($field != 'O2ASPID') { $main_list[] = o2_mssql_o.$field.o2_mssql_c; } else { $main_list[] = $field; } } foreach ($ref_fields as $field) { if ($field != 'O2ASPID') { $ref_list[] = o2_mssql_o.$field.o2_mssql_c; } else { $ref_list[] = $field; } } $main_list = implode(',', $main_list); $ref_list = implode(',', $ref_list); $query = 'ALTER TABLE '.o2_mssql_o.$main_db.o2_mssql_c.'.'. o2_mssql_o.$main_owner.o2_mssql_c.'.'. o2_mssql_o.$main_table.o2_mssql_c. ' WITH NOCHECK ADD CONSTRAINT '.o2_mssql_o.$key_name.o2_mssql_c. ' FOREIGN KEY ('.$main_list. ') REFERENCES '.o2_mssql_o.$ref_db.o2_mssql_c.'.'. o2_mssql_o.$ref_owner.o2_mssql_c.'.'. o2_mssql_o.$ref_table.o2_mssql_c. ' ('.$ref_list.')'; try { o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; return false; } return true; } function o2_mssql_fkeyremove($server, $user, $password, $database, $owner, $table, $key_name) { try { $query = 'USE '.o2_mssql_o.$database.o2_mssql_c; o2_mssql_execute($query, $server, $user, $password, false, false); $query = 'ALTER TABLE '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c. ' DROP CONSTRAINT '.o2_mssql_o.$key_name.o2_mssql_c; o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; return false; } return true; } function o2_mssql_fkeyvalidate($server, $user, $password, $database, $owner, $table, $key_name) { try { $query = 'USE '.o2_mssql_o.$database.o2_mssql_c; o2_mssql_execute($query, $server, $user, $password, false, false); $query = 'ALTER TABLE '.o2_mssql_o.$database.o2_mssql_c.'.'. o2_mssql_o.$owner.o2_mssql_c.'.'. o2_mssql_o.$table.o2_mssql_c. ' WITH CHECK CHECK CONSTRAINT '.o2_mssql_o.$key_name.o2_mssql_c; o2_mssql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; return false; } return true; } function o2_mssql_fkeystablist($server, $user, $password, $database, $owner, $table) { try { $query = 'USE '.o2_mssql_o.$database.o2_mssql_c; o2_mssql_execute($query, $server, $user, $password, false, false); $query = 'SELECT CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS '. "WHERE TABLE_CATALOG='".$database. "' AND TABLE_SCHEMA='".$owner. "' AND TABLE_NAME='".$table. "' AND CONSTRAINT_TYPE='FOREIGN KEY'"; $res = o2_mssql_execute($query, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEINFO); throw $o2e; $res = array(); } $list = array(); foreach ($res as $c_name) { $list[] = $c_name['CONSTRAINT_NAME']; } return $list; } function o2_mssql_fkeysinfo($server, $user, $password, $database, $owner) { $query = 'USE '.$database.'; '. 'SELECT c.CONSTRAINT_NAME AS '.o2_mssql_o.'CN'.o2_mssql_c.', '. 'c.TABLE_NAME AS '.o2_mssql_o.'ON'.o2_mssql_c.', '. 'COL_NAME(fc.parent_object_id, fc.parent_column_id) AS '. o2_mssql_o.'SK'.o2_mssql_c.', '. 'OBJECT_NAME (f.referenced_object_id) AS '.o2_mssql_o.'TO'.o2_mssql_c.', '. 'COL_NAME(fc.referenced_object_id, fc.referenced_column_id) AS '. o2_mssql_o.'TK'.o2_mssql_c.' '. 'FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS c '. 'INNER JOIN sys.foreign_keys AS f '. 'ON c.CONSTRAINT_NAME = f.name '. 'INNER JOIN sys.foreign_key_columns AS fc '. 'ON f.OBJECT_ID = fc.constraint_object_id '. "WHERE c.CONSTRAINT_CATALOG='".$database."' AND ". "c.CONSTRAINT_SCHEMA='".$owner."'"; try { $res = o2_mssql_execute($query, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEINFO); throw $o2e; } $list = array(); foreach ($res as $c) { if (!isset($list[$c['CN']])) { $list[$c['CN']] = array('ON' => $c['ON'], 'TO' => $c['TO'], 'SK' => array(), 'TK' => array()); } $list[$c['CN']]['SK'][] = $c['SK']; $list[$c['CN']]['TK'][] = $c['TK']; } return $list; } function o2_mssql_commit($server, $user, $password, $end = false) { $app = $_SESSION['o2_app']; if ($app->isolated_trans) { $key = $server.$user.'jxext'; } else { $key = $server.$user; } if (isset($GLOBALS['o2_mssql_trans'][$key])) { if (isset($GLOBALS['o2_mssql_error'][$key])) { $GLOBALS['o2_mssql_conn'][$key]->rollBack(); unset($GLOBALS['o2_mssql_error'][$key]); } else { if (is_array($GLOBALS['o2_mssql_stms'])) { foreach ($GLOBALS['o2_mssql_stms'] as $id => $stm) { if ($GLOBALS['o2_mssql_stms'][$id]) { $GLOBALS['o2_mssql_stms'][$id]->closeCursor(); } $GLOBALS['o2_mssql_stms'][$id] = null; $stm = null; } } $GLOBALS['o2_mssql_stms'] = array(); try { $GLOBALS['o2_mssql_conn'][$key]->commit(); } catch (Exception $o2e) { throw new o2_exception('<b>MSSQL</b> server: <i>'.$server. '</i><hr>'.$o2e->getMessage(), o2error_DBCOMMIT); } } unset($GLOBALS['o2_mssql_trans'][$key]); } if ($end && isset($GLOBALS['o2_mssql_conn'][$key])) { unset($GLOBALS['o2_mssql_conn'][$key]); } } ?>
