<?php

/**
 * Janox Runtime
 * PHP5
 *
 * This file is part of Janox.
 *
 * THIS FILE HAS BEEN COMPRESSED TO SPEED UP EXECUTION.
 * See file src/jxdb_as400.inc for a readable version of this script.
 */

 define("o2_as400_sep", ","); define("o2_as400_o", '"'); define("o2_as400_c", '"'); $GLOBALS['o2_as400_conn'] = array(); function o2_as400_normalize($string, $untrim = false) { return strtr(($untrim ? $string : trim($string)), array("\\" => "\\\\")); } function o2_as400_concat($strings) { return '('.implode(' CONCAT ', $strings).')'; } function o2_as400_qualify($database, $owner, $name = "") { return o2_as400_o.$database.o2_as400_c. ($name ? ".".o2_as400_o.$name.o2_as400_c : ""); } function o2_as400_connect($server, $user, $password) { if (!isset($GLOBALS['o2_as400_conn'][$server])) { if (!($conn_local = @odbc_pconnect($server, $user, $password))) { throw new o2_exception("<b>AS400</b> server: <i>".$server. "</i><br>user: <i>".$user. "</i><hr>".odbc_errormsg($conn_local), o2error_DBCONNECT); } $GLOBALS['o2_as400_conn'][$server] = $conn_local; } return $GLOBALS['o2_as400_conn'][$server]; } function o2_as400_execute($query, $server, $user, $password) { $connection = o2_as400_connect($server, $user, $password); if (!($res_local = @odbc_exec($connection, $query ))) { throw new o2_exception("<b>AS400</b> server: <i>".$server."</i><br>user: <i>". $user."</i><br>query: <code>".$query."</code><hr>". odbc_errormsg($connection), o2error_DBEXECUTE); } elseif (is_resource($res_local)) { $arr_return = array(); while($row = @odbc_fetch_array($res_local)) { $arr_local = array(); foreach ($row as $field => $value) { $arr_local[$field] = rtrim($value); } $arr_return[] = $arr_local; } if (isset($arr_return[0]['COMPUTED'])) { return intval($arr_return[0]['COMPUTED']); } return $arr_return; } else { return true; } } function o2_as400_tables($server, $user, $password, $database, $owner) { $connection = o2_as400_connect($server, $user, $password) ; if (!($res_local = @odbc_tables($connection, "%", $database, '%', "TABLE,VIEW"))) { throw new o2_exception("<b>AS400</b> server: <i>".$server."</i><br>user: <i>". $user."</i><hr>".odbc_errormsg($connection), o2error_DBTABLES); } else { $arr_local = array(); while (odbc_fetch_row($res_local)) { $arr_local[] = odbc_result($res_local, 3); } } return $arr_local; } function o2_as400_tablefields($server, $user, $password, $database, $owner, $table) { $connection = o2_as400_connect($server, $user, $password); if (!($res_local = odbc_columns($connection, '%', o2_as400_o.$database.o2_as400_c, o2_as400_o.$table.o2_as400_c, '%'))) { throw new o2_exception("<b>AS400</b> server: <i>".$server."</i><br>user: <i>". $user."</i><hr>".odbc_errormsg($connection), o2error_DBTABLEINFO); } else { $arr_local = array(); while (odbc_fetch_row($res_local)) { $arr_local[] = array('field' => odbc_result($res_local, 4), 'type' => odbc_result($res_local, 6)."(". odbc_result($res_local, 7).")", 'default' => odbc_result($res_local, 9)); } } return $arr_local; } function o2_as400_tableindexes($server, $user, $password, $database, $owner, $table) { $query_local = "SELECT * FROM QSYS2.SYSKEYS, QSYS2.SYSINDEXES ". "WHERE QSYS2.SYSKEYS.INDEX_NAME = QSYS2.SYSINDEXES.INDEX_NAME AND ". "QSYS2.SYSINDEXES.TABLE_NAME = '".strtoupper($table)."'"; try { $res_local = o2_as400_execute($query_local, $server, $user, $password); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEINFO); throw $o2e; } foreach ($res_local as $single_segment) { $key_name = str_replace($table."_", "", $single_segment['INDEX_NAME']); if (!isset($ret_val[$key_name])) { $ret_val[$key_name] = array(); } $ret_val[$key_name]+= array(($single_segment['ORDINAL_POSITION'] - 1) => array('column' => $single_segment['COLUMN_NAME'], 'dir' => strtoupper($single_segment['ORDERING']))); ksort($ret_val[$key_name]); } return $ret_val; } function o2_as400_insertfrom($server, $user, $password, $database_from, $owner_from, $table_from, $database_to, $owner_to, $table_to, $values, $where = "") { $list_from = ""; $list_to = ""; foreach ($values as $field_from => $field_to) { $sep = ($list_from ? o2_as400_sep : ""); if ($field_from == "@o2CloneArea") { $list_from.= $sep.$field_to; $list_to .= $sep."O2ASPID"; } else { $list_from.= $sep.o2_as400_o.$table_from.o2_as400_c.".". o2_as400_o.$field_from.o2_as400_c; $list_to .= $sep.o2_as400_o.$field_to.o2_as400_c; } } $query_local = "INSERT INTO ".o2_as400_o.$database_to.o2_as400_c.".". o2_as400_o.$table_to.o2_as400_c. " (".$list_to.") SELECT ".$list_from. " FROM ".o2_as400_o.$database_from.o2_as400_c.".". o2_as400_o.$table_from.o2_as400_c." AS ". o2_as400_o.$table_from.o2_as400_c."\n"; if ($where) { $query_local.= " WHERE ".$where; } try { $aff_rows = o2_as400_execute($query_local, $server, $user, $password); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLECOPY); throw $o2e; return false; } return $aff_rows; } function o2_as400_droptable($server, $user, $password, $database, $owner, $table) { $query_local = "DROP TABLE ".o2_as400_o.$database.o2_as400_c.".". o2_as400_o.$table.o2_as400_c."\n"; try { o2_as400_execute($query_local, $server, $user, $password); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEDROP); throw $o2e; } o2_as400_commit($server, $user, $password, $database); return true; } function o2_as400_renametable($server, $user, $password, $database, $owner, $table, $new_name) { $query_local = "RENAME TABLE ".o2_as400_o.$database.o2_as400_c.".". o2_as400_o.$table.o2_as400_c. " TO ".o2_as400_o.$new_name.o2_as400_c."\n"; try { o2_as400_execute($query_local, $server, $user, $password); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEREBUILD); throw $o2e; } o2_as400_commit($server, $user, $password, $database); return true; } function o2_as400_createtable($server, $user, $password, $database, $owner, $table, $structure, $execute = true) { $query_local = "CREATE TABLE ".o2_as400_o.$database.o2_as400_c.".". o2_as400_o.$table.o2_as400_c." (\n"; $type = ""; $default = ""; foreach ($structure["fields"] as $field_name => $field_prop) { switch ($field_prop["type"]) { case "A": if ($field_prop["size"] <= 255) { $type = "character(".$field_prop["size"].")"; } elseif ($field_prop["size"] <= 32735) { $type = "varchar(".$field_prop["size"].")"; } else { $type = "long varchar"; } $default = "''"; break; case "N": if ($field_prop["dec"]) { $type = "double"; } else { if ($field_prop["size"] < 5) { $type = "smallint"; } elseif ($field_prop["size"] < 10) { $type = "integer"; } else { $type = "bigint"; } } $default = "0"; break; case "L": $type = "character(1)"; $default = "'0'"; break; case "D": $type = "character(8)"; $default = "'00000000'"; break; case "T": $type = "character(6)"; $default = "'000000'"; break; case "S": $type = "long varchar"; $default = "''"; break; } $query_local.= $field_name." ".$type. " NOT NULL WITH DEFAULT ".$default.o2_as400_sep."\n"; } $query_local = substr($query_local, 0, -2).")\n"; if ($execute) { try { o2_as400_execute($query_local, $server, $user, $password); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLECREATE); throw $o2e; } $query_local = ""; } $arr_local = array(); foreach ($structure["primary"] as $pk_name => $pk_segments) { foreach ($pk_segments as $field_name => $direction) { $arr_local[] = $field_name; } break; } $query_local.= "ALTER TABLE ".o2_as400_o.$database.o2_as400_c.".". o2_as400_o.$table.o2_as400_c. " ADD PRIMARY KEY (".implode(o2_as400_sep, $arr_local).")\n"; if ($execute) { try { o2_as400_execute($query_local, $server, $user, $password); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLECREATE); throw $o2e; } $query_local = ""; } foreach ($structure["keys"] as $index_name => $index_segs) { $arr_local = array(); foreach ($index_segs as $field_name => $direction) { $arr_local[] = $field_name.($direction == "D" ? " DESC" : " ASC"); } $query_local.= "CREATE UNIQUE INDEX ".o2_as400_o.$database.o2_as400_c.".". o2_as400_o.$table."_".$index_name.o2_as400_c. " ON ".o2_as400_o.$database.o2_as400_c.".". o2_as400_o.$table.o2_as400_c. " (".implode(o2_as400_sep, $arr_local).")\n"; if ($execute) { try { o2_as400_execute($query_local, $server, $user, $password); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLECREATE); throw $o2e; } $query_local = ""; } } if ($execute) { return true; } else { return $query_local; } } function o2_as400_aggregate($server, $user, $password, $database, $owner, $table, $table_alias, $where, $functions) { $functions_list = ""; foreach ($functions as $func_name => $single_func) { $functions_list.= ($functions_list ? o2_as400_sep : ""). $single_func["func"]."(".$single_func["field"].") AS ". o2_as400_o.$func_name.o2_as400_c; } if (substr($table, 0, 1) != "(") { $table = o2_as400_o.$database.o2_as400_c.".".o2_as400_o.$table.o2_as400_c; } $query_local = "SELECT ".$functions_list. " FROM ".$table." AS ".o2_as400_o.$table_alias.o2_as400_c; if ($where) { $query_local.= " WHERE ".$where; } try { $res_local = o2_as400_execute($query_local, $server, $user, $password); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBAGGREGATE); throw $o2e; } return $res_local[0]; } function o2_as400_verifyrec($server, $user, $password, $database, $owner, $table, $table_alias, $select_str, $where, $order_by) { $query_local = "SELECT ".$select_str. " FROM ".o2_as400_o.$database.o2_as400_c.".". o2_as400_o.$table.o2_as400_c. " AS ".o2_as400_o.$table_alias.o2_as400_c; if ($where) { $query_local.= " WHERE ".$where; } if ($order_by) { $query_local.= " ORDER BY ".$order_by; } $query_local.=" FETCH FIRST 1 ROWS ONLY"; try { $res_local = o2_as400_execute($query_local, $server, $user, $password); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECQUERY); throw $o2e; } if (!$res_local || $res_local === array()) { return false; } else { return $res_local[0]; } } function o2_as400_modifyrec($server, $user, $password, $database, $owner, $table, $table_alias, $sets, $where) { $upd_str = ''; foreach ($sets as $field => $value) { $upd_str.= ($upd_str != "" ? o2_as400_sep : ""). o2_as400_o.$table_alias.o2_as400_c.".".$field." = ".$value; } $query_local = "UPDATE ".o2_as400_o.$database.o2_as400_c.".". o2_as400_o.$table.o2_as400_c. " AS ".o2_as400_o.$table_alias.o2_as400_c. " SET ".$upd_str. " WHERE ".$where; try { o2_as400_execute($query_local, $server, $user, $password); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECUPDATE); throw $o2e; } return true; } function o2_as400_insertrec($server, $user, $password, $database, $owner, $table, $table_alias, $fields, $values) { $query_local = "INSERT INTO ".o2_as400_o.$database.o2_as400_c.".". o2_as400_o.$table.o2_as400_c. " (".implode(o2_as400_sep, $fields). ") VALUES (".implode(o2_as400_sep, $values).")"; try { o2_as400_execute($query_local, $server, $user, $password); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECINSERT); throw $o2e; } return true; } function o2_as400_deleterec($server, $user, $password, $database, $owner, $table, $table_alias, $where) { $query_local = "DELETE FROM ".o2_as400_o.$database.o2_as400_c.".". o2_as400_o.$table.o2_as400_c. " AS ".o2_as400_o.$table_alias.o2_as400_c; if ($where) { $query_local.= " WHERE ".$where; } if (isset($GLOBALS['jxviewsql'])) { $GLOBALS['jxviewsql'] = $query_local; return true; } try { o2_as400_execute($query_local, $server, $user, $password); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECDELETE); throw $o2e; } return true; } function o2_as400_count($server, $user, $password, $database, $owner, $table, $table_alias, $where) { if (substr($table, 0, 1) != "(") { $table = o2_as400_o.$database.o2_as400_c.".".o2_as400_o.$table.o2_as400_c; } $query_local = "SELECT COUNT(*) AS COMPUTED FROM ".$table; if ($where) { $query_local.= " AS ".o2_as400_o.$table_alias.o2_as400_c." WHERE ".$where; } if ($_SESSION['o2_app']->sqltrace) { o2log($query_local); } try { $res_val = o2_as400_execute($query_local, $server, $user, $password); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBAGGREGATE); throw $o2e; } return $res_val; } function o2_as400_recordset($server, $user, $password, $database, $owner, $table, $table_alias, $select_str, $where, $order_by, $recs) { if (substr($table, 0, 1) != "(") { $table = o2_as400_o.$database.o2_as400_c.".".o2_as400_o.$table.o2_as400_c; } $query_local = "SELECT ".$select_str. " FROM ".$table." AS ".o2_as400_o.$table_alias.o2_as400_c; if ($where) { $query_local.= " WHERE ".$where; } if ($order_by) { $query_local.= " ORDER BY ".$order_by."\n"; } $query_local.= " FETCH FIRST ".abs($recs)." ROWS ONLY"; try { $res_local = o2_as400_execute($query_local, $server, $user, $password); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBDATAQUERY); throw $o2e; } return $res_local; } function o2_as400_fkeyadd($server, $user, $password, $main_db, $main_owner, $main_table, $main_fields, $ref_db, $ref_owner, $ref_table, $ref_fields, $key_name) { return false; } function o2_as400_fkeyremove($server, $user, $password, $database, $owner, $table, $key_name) { return false; } function o2_as400_fkeyvalidate($server, $user, $password, $database, $owner, $table, $key_name) { return false; } function o2_as400_fkeystablist($server, $user, $password, $database, $owner, $table) { return array(); } function o2_as400_commit($server, $user, $password) { if (isset($GLOBALS['o2_as400_conn'][$server])) { unset($GLOBALS['o2_as400_conn'][$server]); } } ?>
