/**
 * Janox JavaScript Environment
 * JavaScript 5
 *
 * This file is part of Janox.
 *
 * THIS FILE HAS BEEN COMPRESSED TO SPEED UP EXECUTION.
 * See file src/env_20250929.js for a readable version of this script.
 */

String.prototype.trim = function() { return this.replace(/^\s+|\s+$/g, ""); }; String.prototype.ltrim = function() { return this.replace(/^\s+/, ""); }; String.prototype.rtrim = function() { return this.replace(/\s+$/, ""); }; String.prototype.explode = function(separator, limit) { var arr = this.split(separator); if (limit) { arr.push(arr.splice(limit - 1).join(separator)); } return arr; }; String.prototype.decode = function() { if (o2jse.decoderObj == null) { o2jse.decoderObj = document.createElement("textarea"); } o2jse.decoderObj.innerHTML = this; var returnText = o2jse.decoderObj.value; o2jse.decoderObj.innerHTML = ""; return returnText; }; var o2jse = { rntAlias : "/janox/", appAlias : "/", charSet : "UTF-8", sessName : "PHPSESSID", instId : '', user : "default", superUser : false, dev : false, decimalsPoint : ',', thousandsPoint : ' ', keepAlive : 0, keepAliveHdl : null, refreshTime : 0, maxMultiReq : 5, menuStyle : 'T', doc : false, profiling : false, cliMode : true, netErr : false, fastMsgTime : 5, contMenuApp : false, contMenuNewSess : false, contMenuHelp : false, started : false, submitting : false, submitCtrl : false, safeChanges : [], infoForm : null, elBody : null, glassObj : null, waitObj : null, clockObj : null, decoderObj : null, runnerObj : null, reqData : {}, exeTree : [], keyList : [], reposWins : [], waitingScripts : 0, maximizedWin : false, winResizing : false, closeLogout : true, closeWait : false }; o2jse.cli = { agent : navigator.userAgent, width : 0, height : 0 }; o2jse.init = function() { var metas = document.getElementsByTagName("meta"); for (var i = 0; i < metas.length; i++) { if (metas[i].httpEquiv == "Content-Type") { var c = metas[i].content; o2jse.charSet = c.substring(c.lastIndexOf("=") + 1); break; } } o2jse.appAlias = location.protocol + "//" + location.host + location.pathname.substr(0, location.pathname.lastIndexOf("/")) + "/"; o2jse.elBody = (document.body || document.getElementsByTagName("body")[0]); o2jse.infoForm = document.forms.o2form; o2jse.cli.width = (window.innerWidth != null ? window.innerWidth : (document.documentElement && document.documentElement.clientWidth ? document.documentElement.clientWidth : o2jse.elBody.clientWidth)); o2jse.cli.height = (window.innerHeight != null ? window.innerHeight : (document.documentElement && document.documentElement.clientHeight ? document.documentElement.clientHeight : o2jse.elBody.clientHeight)); o2jse.infoForm['o2_action'].value = ''; o2jse.infoForm['o2lastform'].value = ''; o2jse.infoForm['o2lastctrl'].value = ''; o2jse.submitting = false; o2jse.started = true; if (jxjs.respTimeOut) { clearTimeout(jxjs.respTimeOut); jxjs.respTimeOut = null; } o2jse.requester.init(); if (o2jse.devName && !o2jse.lab.contWin) { o2jse.lab.init(); } o2jse.cMenu.partnersB = []; o2jse.cMenu.partnersA = []; o2jse.cMenu.regPartner(o2jse.cale.initContMenu, true); if (o2jse.tab.gridPlus) { o2jse.cMenu.regPartner(o2jse.tab.initContMenu, true); } o2jse.cMenu.regPartner(o2jse.tv.initContMenu, true); if (o2jse.devName) { o2jse.cMenu.regPartner(o2jse.dev.addDevMenu); } if (o2jse.contMenuHelp) { o2jse.cMenu.regPartner(o2jse.docInitContMenu); } document.oncontextmenu = o2jse.cMenu.setOn; if (o2jse.keepAlive && !o2jse.keepAliveHdl) { o2jse.keepAliveExe = function() { jxjs.beacon('keepalive', { 'instid' : o2jse.instId }); clearTimeout(o2jse.keepAliveHdl); o2jse.keepAliveHdl = setTimeout(o2jse.keepAliveExe, o2jse.keepAlive); }; o2jse.keepAliveExe(); } if (o2jse.notify.timeOut) { clearTimeout(o2jse.notify.timeOut); o2jse.notify.timeOut = null; } if (o2jse.refreshTime) { o2jse.notify.timeOut = setTimeout(o2jse.notify.exeReq, o2jse.refreshTime); } if (o2jse.progress.active && !o2jse.progress.timeOut) { o2jse.progress.timeOut = setTimeout(function() { delete o2jse.progress.timeOut; o2jse.requester.exe('progress', 'JXSESSNAME=' + o2jse.sessName, o2jse.progress, o2jse.progress.getCode, true); }, 3000); } o2jse.reposAllWins(); window.onresize = function() { clearTimeout(o2jse.winResizing); if (o2jse.cli.agent.toLowerCase().indexOf('android') > -1) { o2jse.winResizing = setTimeout(jxjs.request, 200); } else { o2jse.winResizing = setTimeout(o2jse.resizeBrowserWindow, 200); } }; o2jse.waitDocReady(); window.onunload = function() { jxjs.beacon('logout'); }; window.onmouseover = function () { if (!o2jse.closeWait) { window.onunload = null; }}; window.onmouseout = function () { if (!o2jse.submitting) { window.onunload = function() { jxjs.beacon('logout'); }; } }; window.onclick = function () { window.onunload = null; o2jse.closeWait = false; }; document.onkeydown = function (e) { if (e.key == 'Control' || e.key == 'Alt') { if (!o2jse.submitting) { window.onunload = function() { jxjs.beacon('logout'); }; o2jse.closeWait = true; } } else { window.onunload = null; o2jse.closeWait = false; } }; if (o2jse.ctrl.focusCtrl) { o2jse.cmd.focus(o2jse.ctrl.focusCtrl, o2jse.ctrl.focusMode); } }; o2jse.waitDocReady = function() { if (o2jse.waitingScripts > 0) { setTimeout(o2jse.waitDocReady, 10); } else { if (o2jse.docReady) { o2jse.docReady(); o2jse.docReady = null; } } }; o2jse.resizeBrowserWindow = function() { rA = o2jse.createInput(o2jse.infoForm, "hidden", "", "1", "jxresizeall"); jxjs.request(); if (rA) { o2jse.removeEl(rA); } }; o2jse.exeCode = function(codeToExe) { o2jse.codeToExe = codeToExe; o2jse.runnerObj = document.createElement("script"); o2jse.runnerObj.text = "try { eval(o2jse.codeToExe); o2jse.codeToExe = null; } " + "catch(ex) { jxjs.cError(ex, o2jse.codeToExe); } "; document.getElementsByTagName("head")[0].appendChild(o2jse.runnerObj); }; o2jse.textDecode = function(decodeText) { if (o2jse.decoderObj == null) { o2jse.decoderObj = document.createElement("textarea"); } o2jse.decoderObj.innerHTML = decodeText; var returnText = o2jse.decoderObj.value; o2jse.decoderObj.innerHTML = ""; return returnText; }; o2jse.setExeId = function(exeId, prgName) { document.forms.o2form['o2_prgexeid'].value = exeId; if (prgName) { document.forms.o2form['o2_prgname'].value = prgName; } else { document.forms.o2form['o2_prgname'].value = ''; } }; o2jse.loadScript = function(fileToLoad) { var hTag = document.getElementsByTagName("head")[0]; var sTags = hTag.getElementsByTagName("script"); var addS = true; for (i = 0; i < sTags.length; i++) { if (sTags[i].src == fileToLoad) { addS = false; break; } } if (addS) { o2jse.waitingScripts++; var se = o2jse.createEl(hTag, "script"); se.onload = function () { o2jse.waitingScripts--; }; se.src = fileToLoad; } }; o2jse.loadCSS = function(fileToLoad, media) { var hTag = document.getElementsByTagName("head")[0]; var lTags = hTag.getElementsByTagName("link"); var addL = true; for (i = 0; i < lTags.length; i++) { if (lTags[i].href == fileToLoad) { addL = false; break; } } if (addL) { var le = o2jse.createEl(hTag, "link"); le.rel = "stylesheet"; le.href = fileToLoad; if (media) { le.media = media; } } }; o2jse.stopExe = function(eventObj) { if (eventObj) { o2jse.event.std(eventObj).stop(); } setTimeout(function() { o2jse.cmd.focus(o2jse.submitCtrl); }, 200); o2jse.lu.listOff(); o2jse.fastMsg.show("<center>ACTION BLOCKED</center>" + "Press TAB or ENTER to validate changed data"); return false; }; o2jse.statusMsg = function(txt_code) { document.getElementById("o2statustext").innerHTML = txt_code; }; o2jse.createEl = function(inObj, elType, elClass, elHtml) { var lEl = document.createElement(elType); if (elClass) { lEl.className = elClass; } if (elHtml) { lEl.innerHTML = elHtml; } if (inObj) { inObj.appendChild(lEl); } return lEl; }; o2jse.createInput = function(inObj, elType, elClass, elValue, fieldName) { var lEl = document.createElement("INPUT"); lEl.type = (elType ? elType : "hidden"); if (fieldName) { lEl.name = fieldName; } if (elValue) { lEl.value = elValue; } if (elClass) { lEl.className = elClass; } inObj.appendChild(lEl); return lEl; }; o2jse.removeEl = function(objToRemove) { if (objToRemove) { if (typeof objToRemove == "string") { if (elementObj = document.getElementById(objToRemove)) { o2jse.removeEl(elementObj); } } else if (objToRemove.parentNode) { objToRemove.parentNode.removeChild(objToRemove); } } }; o2jse.getPos = function(targetObj) { var pos = { x : targetObj.offsetLeft, y : targetObj.offsetTop }; var level = targetObj; while (level = level.offsetParent) { pos.x += level.offsetLeft; pos.y += level.offsetTop; } level = targetObj; while (level = level.parentNode) { if (level.tagName.toLowerCase() == "body") { break; } else { pos.x -= level.scrollLeft; pos.y -= level.scrollTop; } } return pos; }; o2jse.showByScroll = function(targetObj) { if (targetObj.offsetTop < targetObj.parentNode.scrollTop + 20) { targetObj.parentNode.scrollTop = targetObj.offsetTop; } else if (targetObj.offsetTop > (targetObj.parentNode.scrollTop + targetObj.parentNode.offsetHeight - 20)) { targetObj.parentNode.scrollTop = targetObj.offsetTop + targetObj.parentNode.offsetHeight; } }; o2jse.getTabIndex = function(targetObj) { if (targetObj.tabIndex) { return targetObj.tabIndex; } else { for (var i = (o2jse.infoForm.elements.length - 1); i > -1; i--) { if (o2jse.infoForm.elements[i] == targetObj) { return i; } } return -1; } }; o2jse.setTabIndex = function(targetObj, newIndex) { if (newIndex < 0) { newIndex = 0; } if (newIndex > (o2jse.infoForm.elements.length - 1)) { newIndex = (o2jse.infoForm.elements.length - 1); } var upIndex = 0; for (var i = (o2jse.infoForm.elements.length - 2); i > -1; i--) { upIndex = (i >= newIndex ? 1 : 0); if (o2jse.infoForm.elements[i] != targetObj) { o2jse.infoForm.elements[i].tabIndex = i + upIndex; } } targetObj.tabIndex = newIndex; }; o2jse.firstRealChild = function(parentObj) { var fieldLocal = parentObj.childNodes[0]; while (fieldLocal.nodeType != 1) { if (!(fieldLocal = fieldLocal.nextSibling)) { break; } } return fieldLocal; }; o2jse.getParentTag = function(obj, tag) { var obj_parent = obj.parentNode; if (!obj_parent) { return false; } else if (obj_parent.tagName.toLowerCase() == tag.toLowerCase()) { return obj_parent; } else { return o2jse.getParentTag(obj_parent, tag); } }; o2jse.reposAllWins = function() { for (var winIndex in o2jse.reposWins) { o2jse.win.repos(o2jse.reposWins[winIndex]); } }; o2jse.conf = {}; o2jse.conf.rntAlias = function(aliasStr) { o2jse.rntAlias = aliasStr; }; o2jse.conf.sessName = function(phpSessName) { o2jse.sessName = phpSessName; }; o2jse.conf.keepAlive = function(tSecs, instId) { o2jse.keepAlive = tSecs * 1000; o2jse.instId = instId; }; o2jse.conf.setRefresh = function(tSecs) { o2jse.refreshTime = tSecs * 1000; }; o2jse.conf.setMaxReq = function(reqs) { o2jse.maxMultiReq = reqs; }; o2jse.conf.setFastMsgTime = function(timeOut) { o2jse.fastMsgTime = timeOut; }; o2jse.conf.doc = function() { o2jse.doc = true; }; o2jse.conf.menuStyle = function(mStyle) { o2jse.menuStyle = mStyle; }; o2jse.conf.contextMenu = function(confList) { o2jse.contMenuApp = confList.app; o2jse.contMenuNewSess = confList.newsess; o2jse.contMenuHelp = confList.help; }; o2jse.conf.user = function(userId) { o2jse.user = userId; if (userId.toLowerCase() == "root") { o2jse.superUser = true; } }; o2jse.conf.superUser = function() { o2jse.superUser = true; }; o2jse.conf.devel = function(devName) { o2jse.devName = devName; o2jse.superUser = true; }; o2jse.conf.decimalsPoint = function(pointStr) { o2jse.decimalsPoint = pointStr; }; o2jse.conf.thousandsPoint = function(pointStr) { o2jse.thousandsPoint = pointStr; }; o2jse.conf.setProfiling = function(profLevel) { o2jse.profiling = profLevel; }; o2jse.conf.addKey = function(keyCode, shiftBtn, ctrlBtn, altBtn, actCode) { o2jse.keyList.push({code : keyCode, shift : shiftBtn, ctrl : ctrlBtn, alt : altBtn, exe : actCode}); }; o2jse.conf.gridPlus = function(autoSave, multiDel) { o2jse.tab.gridPlus = true; o2jse.tab.autoSaveSettings = autoSave; o2jse.tab.gridMultiDel = multiDel; }; o2jse.conf.gridDblClick = function(act) { o2jse.tab.dblClickAct = act; }; o2jse.conf.gridWheel = function(wheel) { o2jse.tab.wheelPaging = (wheel ? true : false); }; o2jse.conf.luReqTime = function(reqTime) { o2jse.lu.reqDelay = (reqTime >= 300 ? reqTime : 300); }; o2jse.requester = { reqList : [] }; o2jse.requester.init = function() { this.mon.init(); }; o2jse.requester.startReq = function(reqId) { var newReq = { id : reqId, engine : new XMLHttpRequest(), sourceObj : null }; newReq.engine.open("POST", o2jse.rntAlias + "jxr.php", true); newReq.engine.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + o2jse.charSet); this.reqList.push(newReq); this.mon.refresh(); if (this.reqList.length >= o2jse.maxMultiReq) { o2jse.cmd.showClock(); } return newReq; }; o2jse.requester.endReq = function(reqId) { for (var i = this.reqList.length - 1; i >= 0; i--) { if (this.reqList[i].id == reqId) { this.reqList.splice(i, 1); break; } } if (this.reqList.length < 1) { o2jse.cmd.hideClock(); } this.mon.refresh(); }; o2jse.requester.exe = function(action, addToBody, fromObj, callBack, noFields = false) { var reqId = "_" + new Date().getTime(); var postBody = ""; if (!noFields) { for (var fieldId = o2jse.infoForm.elements.length; fieldId > 0; fieldId--) { var singleField = o2jse.infoForm.elements[fieldId - 1]; if (singleField.name && !singleField.disabled && singleField.name != "o2pagemark") { postBody += (singleField.name + "=" + encodeURIComponent(singleField.value) + "&"); } } } var reqObj = this.startReq(reqId); reqObj.engine.onreadystatechange = function() { if (reqObj.engine.readyState == 4) { if (reqObj.engine.status == 0) { st = reqObj.engine.status; o2jse.requester.endReq(reqId); if (fromObj !== o2jse.notify) { alert("Network error: please try again."); } else { if (o2jse.notify.timeOut) { clearTimeout(o2jse.notify.timeOut); o2jse.notify.timeOut = null; } o2jse.notify.timeOut = setTimeout(o2jse.notify.exeReq, o2jse.refreshTime); o2jse.notify.inRequest = false; } } else { var resText = reqObj.engine.responseText; o2jse.requester.endReq(reqId); if (callBack) { callBack(fromObj, resText, reqId); } } } }; reqObj.engine.send(postBody + "jxact=" + (action || "pagepost") + (addToBody ? "&" + addToBody : "")); return reqId; }; o2jse.requester.mon = { outBox : null, leds_n : 5, leds : [] }; o2jse.requester.mon.init = function() { if (!(document.getElementById('jxReqMon'))) { this.outBox = o2jse.createEl(o2jse.elBody, 'DIV', 'reqMon'); this.outBox.id = 'jxReqMon'; this.leds_n = o2jse.maxMultiReq; this.leds[0] = o2jse.createEl(this.outBox, 'DIV', 'reqMonFree'); for (var i = 1; i < this.leds_n; i++) { this.leds[i] = o2jse.createEl(this.outBox, 'DIV', 'reqMonOff'); } } }; o2jse.requester.mon.refresh = function() { var ledsOnCount = o2jse.requester.reqList.length; if (ledsOnCount < 1) { this.leds[0].className = 'reqMonFree'; for (var i = 1; i < this.leds_n; i++) { this.leds[i].className = 'reqMonOff'; } } else { if (ledsOnCount < (this.leds_n + 1)) { for (var i = 0; i < this.leds_n; i++) { this.leds[i].className = (i < ledsOnCount ? 'reqMonOn' : 'reqMonOff'); } } } }; o2jse.event = {}; o2jse.event.std = function(eventObj) { if (window.event) { o2jse.ctrl.init(window.event.srcElement); return { target : window.event.srcElement, x : window.event.clientX, y : window.event.clientY, offsetX : window.event.offsetX, offsetY : window.event.offsetY, button : window.event.button, keyCode : window.event.keyCode, charCode : window.event.charCode, ctrlKey : window.event.ctrlKey, shiftKey : window.event.shiftKey, altKey : window.event.altKey, delta : -(window.event.wheelDelta / 120), stop : function() { window.event.returnValue = false; window.event.cancelBubble = true; } }; } else if (eventObj) { o2jse.ctrl.init(eventObj.target); return { target : eventObj.target, x : eventObj.clientX, y : eventObj.clientY, offsetX : eventObj.layerX - eventObj.target.offsetLeft, offsetY : eventObj.layerY - eventObj.target.offsetTop, button : eventObj.button, keyCode : eventObj.keyCode, charCode : eventObj.charCode, ctrlKey : eventObj.ctrlKey, shiftKey : eventObj.shiftKey, altKey : eventObj.altKey, delta : eventObj.detail / 3, stop : function() { eventObj.preventDefault(); eventObj.stopPropagation(); } }; } else { return { target : null, x : 0, y : 0, offsetX : 0, offsetY : 0, button : 0, keyCode : 0, charCode : 0, ctrlKey : false, shiftKey : false, altKey : false, stop : function() {} }; } }; o2jse.ctrl = { focusCtrl : null, focusMode : null, caleObj : null, editAreaList : [], upLoad : false, lastKeyCode : 0, focusFallBack : false }; o2jse.ctrl.init = function(obj2Init) { if (typeof obj2Init.o2 != "object") { var hinO2 = hineritAttr(obj2Init); if (typeof hinO2 == "object") { obj2Init.o2 = hinO2; } else { if (typeof hinO2 == "string") { eval("obj2Init.o2={" + hinO2 + "};"); } else { obj2Init.o2 = {}; } } } function hineritAttr(hinObj) { if (typeof hinObj.o2 == "object") { return hinObj.o2; } else { if (hinObj.hasAttribute && hinObj.hasAttribute("o2")) { return hinObj.getAttribute("o2"); } else { if (hinObj.parentNode && typeof hinObj.parentNode == "object" && hinObj.parentNode.tagName && hinObj.parentNode.tagName.toLowerCase() != "body") { return hineritAttr(hinObj.parentNode); } else { return ""; } } } } return true; }; o2jse.ctrl.k = function(eventObj) { var stdEvent = o2jse.event.std(eventObj); var keyCode = stdEvent.keyCode; var singleKey = null; o2jse.ctrl.lastKeyCode = keyCode; o2jse.ctrl.init(stdEvent.target); switch (stdEvent.target.o2.cT) { case "button": if (keyCode == 32 || keyCode == 13) { stdEvent.target.click(); return false; } else if (keyCode == 37) { var btns = o2jse.ctrl.getByJxType("button"); var currBtn = stdEvent.target.o2.c; var prevBtn = currBtn; for (var i = 0; i < btns.length; i++) { if (btns[i] == currBtn) { if (i == 0) { prevBtn = btns[btns.length - 1]; } break; } else { prevBtn = btns[i]; } } document.getElementById(prevBtn + stdEvent.target.o2.e).focus(); stdEvent.stop(); } else if (keyCode == 39) { var btns = o2jse.ctrl.getByJxType("button"); var currBtn = stdEvent.target.o2.c; var nextBtn = currBtn; for (var i = btns.length - 1; i >= 0; i--) { if (btns[i] == currBtn) { if (btns[i] == nextBtn) { nextBtn = btns[0]; } break; } else { nextBtn = btns[i]; } } document.getElementById(nextBtn + stdEvent.target.o2.e).focus(); stdEvent.stop(); } break; case "edit": stdEvent.target.inEdit = true; break; case "text": stdEvent.target.inEdit = true; if (keyCode == 13 || (keyCode >= 35 && keyCode <= 40)) { return false; } break; } for (var o2keyIndex = o2jse.keyList.length - 1; o2keyIndex >= 0 ; o2keyIndex--) { singleKey = o2jse.keyList[o2keyIndex]; if (singleKey.code > 0 && singleKey.code == keyCode && singleKey.shift == stdEvent.shiftKey && singleKey.ctrl == stdEvent.ctrlKey && singleKey.alt == stdEvent.altKey) { var navName = ""; if (stdEvent.target.o2.nav) { navName = stdEvent.target.o2.nav + String(stdEvent.target.o2.e); } switch (singleKey.exe) { case 1: if (navName) { stdEvent.stop(); var navLocal = o2jse.infoForm[navName]; o2jse.ctrl.init(navLocal); if (navLocal.o2.navNav) { if (stdEvent.target.focus) { o2jse.infoForm['o2lastform'].value = stdEvent.target.o2.f; o2jse.infoForm['o2lastctrl'].value = stdEvent.target.o2.c; } stdEvent.target.blur(); o2jse.nav.btnExe(document.getElementById(navName + "_fbtn")); if (stdEvent.target.focus) { stdEvent.target.focus(); } return false; } } break; case 2: if (navName) { stdEvent.stop(); var navLocal = o2jse.infoForm[navName]; o2jse.ctrl.init(navLocal); if (navLocal.o2.navNav) { if (stdEvent.target.focus) { o2jse.infoForm['o2lastform'].value = stdEvent.target.o2.f; o2jse.infoForm['o2lastctrl'].value = stdEvent.target.o2.c; } stdEvent.target.blur(); o2jse.nav.btnExe(document.getElementById(navName + "_ppbtn")); if (stdEvent.target.focus) { stdEvent.target.focus(); } return false; } } break; case 3: if (o2jse.cliMode && (stdEvent.target.o2.cT == "tab" || stdEvent.target.o2.pT == "tab")) { if (stdEvent.target.focus) { o2jse.infoForm['o2lastform'].value = stdEvent.target.o2.f; o2jse.infoForm['o2lastctrl'].value = stdEvent.target.o2.c; } o2jse.tab.changeRow(stdEvent.target, "P", navName); stdEvent.stop(); return false; } if (navName) { stdEvent.stop(); var navLocal = o2jse.infoForm[navName]; o2jse.ctrl.init(navLocal); if (navLocal.o2.navNav) { if (stdEvent.target.focus) { o2jse.infoForm['o2lastform'].value = stdEvent.target.o2.f; o2jse.infoForm['o2lastctrl'].value = stdEvent.target.o2.c; } stdEvent.target.blur(); if (stdEvent.target.o2.pointer) { o2jse.tab.selectRow(true, stdEvent.target); } else { o2jse.nav.btnExe(document.getElementById(navName + "_pbtn")); } if (stdEvent.target.focus) { stdEvent.target.focus(); } return false; } } break; case 4: if (o2jse.cliMode && (stdEvent.target.o2.cT == "tab" || stdEvent.target.o2.pT == "tab")) { if (stdEvent.target.focus) { o2jse.infoForm['o2lastform'].value = stdEvent.target.o2.f; o2jse.infoForm['o2lastctrl'].value = stdEvent.target.o2.c; } o2jse.tab.changeRow(stdEvent.target, "N", navName); stdEvent.stop(); return false; } if (navName) { stdEvent.stop(); var navLocal = o2jse.infoForm[navName]; o2jse.ctrl.init(navLocal); if (navLocal.o2.navNav) { if (stdEvent.target.focus) { o2jse.infoForm['o2lastform'].value = stdEvent.target.o2.f; o2jse.infoForm['o2lastctrl'].value = stdEvent.target.o2.c; } stdEvent.target.blur(); if (stdEvent.target.o2.pointer) { o2jse.tab.selectRow(false, stdEvent.target); } else { o2jse.nav.btnExe(document.getElementById(navName + "_nbtn")); } if (stdEvent.target.focus) { stdEvent.target.focus(); } return false; } } break; case 5: if (navName) { stdEvent.stop(); var navLocal = o2jse.infoForm[navName]; o2jse.ctrl.init(navLocal); if (navLocal.o2.navNav) { if (stdEvent.target.focus) { o2jse.infoForm['o2lastform'].value = stdEvent.target.o2.f; o2jse.infoForm['o2lastctrl'].value = stdEvent.target.o2.c; } stdEvent.target.blur(); o2jse.nav.btnExe(document.getElementById(navName + "_npbtn")); if (stdEvent.target.focus) { stdEvent.target.focus(); } return false; } } break; case 6: if (navName) { stdEvent.stop(); var navLocal = o2jse.infoForm[navName]; o2jse.ctrl.init(navLocal); if (navLocal.o2.navNav) { if (stdEvent.target.focus) { o2jse.infoForm['o2lastform'].value = stdEvent.target.o2.f; o2jse.infoForm['o2lastctrl'].value = stdEvent.target.o2.c; } stdEvent.target.blur(); o2jse.nav.btnExe(document.getElementById(navName + "_lbtn")); if (stdEvent.target.focus) { stdEvent.target.focus(); } return false; } } break; case 11: if (navName) { stdEvent.stop(); var navLocal = o2jse.infoForm[navName]; o2jse.ctrl.init(navLocal); if (navLocal.o2.navNew) { stdEvent.target.blur(); o2jse.nav.btnExe(document.getElementById(navName +"_newbtn")); return false; } } break; case 12: if (navName) { stdEvent.stop(); var navLocal = o2jse.infoForm[navName]; o2jse.ctrl.init(navLocal); if (navLocal.o2.navDel) { stdEvent.target.blur(); o2jse.nav.btnExe(document.getElementById(navName +"_delbtn")); return false; } } break; case 13: if (navName) { stdEvent.stop(); var navLocal = o2jse.infoForm[navName]; o2jse.ctrl.init(navLocal); if (navLocal.o2.navSave) { stdEvent.target.blur(); o2jse.nav.btnExe(document.getElementById(navName + "_savebtn")); if (stdEvent.target.focus) { stdEvent.target.focus(); if (stdEvent.target.select) { stdEvent.target.select(); } } return false; } } break; case 14: if (navName) { stdEvent.stop(); var navLocal = o2jse.infoForm[navName]; o2jse.ctrl.init(navLocal); if (navLocal.o2.navUndo) { stdEvent.target.blur(); o2jse.nav.btnExe(document.getElementById(navName + "_undobtn")); return false; } } break; case 15: if (navName) { var navLocal = o2jse.infoForm[navName]; o2jse.ctrl.init(navLocal); if (navLocal.o2.navSele) { stdEvent.stop(); stdEvent.target.blur(); o2jse.submitting = false; o2jse.nav.btnExe(document.getElementById(navName + "_selebtn")); return false; } } break; case 16: if (navName) { stdEvent.stop(); var navLocal = o2jse.infoForm[navName]; o2jse.ctrl.init(navLocal); if (navLocal.o2.navDet) { stdEvent.target.blur(); o2jse.nav.btnExe(document.getElementById(navName +"_detbtn")); return false; } } break; case 17: stdEvent.stop(); stdEvent.target.blur(); o2jse.cmd.submit(stdEvent.target.o2.e); return false; break; case 18: stdEvent.stop(); o2jse.cmd.doc(stdEvent.target); return false; break; case 19: stdEvent.stop(); stdEvent.target.blur(); o2jse.win.exit(stdEvent.target); return false; break; case 20: if (stdEvent.target.o2.z) { stdEvent.stop(); return o2jse.ctrl.zoom(eventObj); } break; default: if (parseInt(singleKey.exe) != singleKey.exe) { stdEvent.stop(); stdEvent.target.blur(); if (typeof stdEvent.target == "object" && stdEvent.target.value != stdEvent.target.defaultValue) { o2jse.cmd.ctrlUpd(stdEvent.target); } var relatedBtn = document.getElementById(singleKey.exe + stdEvent.target.o2.e); o2jse.ctrl.btnExe(relatedBtn); return false; } } } } return false; }; o2jse.ctrl.f = function(targetObj) { o2jse.ctrl.init(targetObj); var objInfo = targetObj.o2; o2jse.infoForm['o2lastform'].value = objInfo.f; o2jse.infoForm['o2lastctrl'].value = objInfo.c; o2jse.ctrl.focusCtrl = targetObj.name; if (objInfo.cT != "text" && objInfo.cT != "checkcheckbox" && targetObj.select) { targetObj.select(); targetObj.onmouseup = function(e) { e = o2jse.event.std(e); e.stop(); this.onmouseup = null; }; } }; o2jse.ctrl.b = function(targetObj) { targetObj.inEdit = false; }; o2jse.ctrl.c = function(targetObj) { o2jse.ctrl.init(targetObj); switch (targetObj.o2.dT) { case "A": if (targetObj.o2.cT == 'edit') { targetObj.value = targetObj.value.replace(/\s/g, " "); } targetObj.value = o2jse.data.fa(targetObj.value, targetObj.o2.m); break; case "N": targetObj.value = o2jse.data.fn(targetObj.value, targetObj.o2.m); break; case "D": targetObj.value = o2jse.data.fd(targetObj.value, targetObj.o2.m); break; case "O": targetObj.value = o2jse.data.ft(targetObj.value, targetObj.o2.m); break; case "L": targetObj.value = (targetObj.value ? "1" : ""); break; default: s = new String(targetObj.value); targetObj.value = s.toString(); break; } targetObj.inEdit = false; if (targetObj.o2.fret) { o2jse.ctrl.make_waiting(targetObj); if (o2jse.cliMode) { var nF; nF = o2jse.createInput(o2jse.infoForm, "hidden", "", "1", "jxnofocus"); o2jse.submitCtrl = targetObj.o2.c + targetObj.o2.e; jxjs.request(targetObj, targetObj.value); if (nF) { o2jse.removeEl(nF); } } else { o2jse.cmd.ctrlUpd(targetObj); } } else { o2jse.cmd.ctrlUpd(targetObj); } }; o2jse.ctrl.l = function(eventObj) { var stdEvent = o2jse.event.std(eventObj); var ctrlObj = stdEvent.target; o2jse.ctrl.init(ctrlObj); var maxSize = parseInt(ctrlObj.o2.s); if ((ctrlObj.value.length < maxSize) || (stdEvent.charCode == 0)) { return true; } else { return false; } }; o2jse.ctrl.make_waiting = function(waitCtrl) { if (o2jse.waitObj) { o2jse.removeEl(o2jse.waitObj); delete o2jse.waitObj; } if (jxjs.waitingCtrl) { jxjs.waitingCtrl.style.display = "block"; } switch (waitCtrl.tagName.toUpperCase()) { case 'TD': jxjs.waitingCtrl = waitCtrl; var pNode = waitCtrl.parentNode; var cWidth = waitCtrl.offsetWidth; var cHeight = waitCtrl.offsetHeight; var cClass = waitCtrl.className; waitCtrl.style.display = 'none'; o2jse.waitObj = pNode.insertCell(waitCtrl.cellIndex); o2jse.waitObj.className = cClass; o2jse.waitObj.style.width = cWidth + 'px'; o2jse.waitObj.style.height = cHeight + 'px'; var wObj = o2jse.createEl(o2jse.waitObj, 'DIV', 'jx_inctrl_wait', '&nbsp;'); wObj.style.position = 'relative'; wObj.style.left = parseInt((cWidth - wObj.offsetWidth) / 2) + 'px'; wObj.style.top = '0'; break; case 'TH': jxjs.waitingCtrl = waitCtrl; var pNode = waitCtrl.parentNode; var cWidth = waitCtrl.offsetWidth; var cHeight = waitCtrl.offsetHeight; var cClass = waitCtrl.className; waitCtrl.style.display = 'none'; o2jse.waitObj = o2jse.createEl(false, 'TH', cClass); pNode.insertBefore(o2jse.waitObj, waitCtrl); o2jse.waitObj.style.width = cWidth + 'px'; o2jse.waitObj.style.height = cHeight + 'px'; var wObj = o2jse.createEl(o2jse.waitObj, 'DIV', 'jx_inctrl_wait', '&nbsp;'); wObj.style.position = 'relative'; wObj.style.left = parseInt((cWidth - wObj.offsetWidth) / 2) + 'px'; wObj.style.top = '0'; break; case 'INPUT': o2jse.ctrl.b(waitCtrl); jxjs.waitingCtrl = waitCtrl; var pNode = waitCtrl.parentNode; var cWidth = waitCtrl.offsetWidth; var cHeight = waitCtrl.offsetHeight; var cClass = waitCtrl.className; waitCtrl.style.display = "none"; o2jse.waitObj = o2jse.createEl(false, 'DIV', cClass); pNode.insertBefore(o2jse.waitObj, waitCtrl.nextSibling); o2jse.waitObj.style.width = cWidth + 'px'; o2jse.waitObj.style.height = cHeight + 'px'; var wObj = o2jse.createEl(o2jse.waitObj, 'DIV', 'jx_inctrl_wait', '&nbsp;'); wObj.style.position = 'absolute'; wObj.style.left = parseInt((cWidth - wObj.offsetWidth) / 2) + 'px'; wObj.style.top = parseInt((cHeight - wObj.offsetHeight) / 2) + 'px'; break; default: jxjs.waitingCtrl = waitCtrl; var pNode = waitCtrl.parentNode; var cWidth = waitCtrl.offsetWidth; var cHeight = waitCtrl.offsetHeight; var cClass = waitCtrl.className; waitCtrl.style.display = 'none'; o2jse.waitObj = o2jse.createEl(false, 'DIV', cClass); pNode.insertBefore(o2jse.waitObj, waitCtrl.nextSibling); var bgImg = (o2jse.waitObj.currentStyle || window.getComputedStyle(o2jse.waitObj, false)).backgroundImage; if (bgImg.slice(0, 3).toLowerCase() == 'url') { o2jse.waitObj.style.backgroundImage = 'none'; } o2jse.waitObj.style.width = cWidth + 'px'; o2jse.waitObj.style.height = cHeight + 'px'; var wObj = o2jse.createEl(o2jse.waitObj, 'DIV', 'jx_inctrl_wait', '&nbsp;'); wObj.style.position = 'relative'; wObj.style.left = parseInt((cWidth - wObj.offsetWidth) / 2) + 'px'; wObj.style.top = parseInt((cHeight - wObj.offsetHeight) / 2) + 'px'; break; } }; o2jse.ctrl.zoom = function(eventObj) { var stdEvent = o2jse.event.std(eventObj); var infObj = stdEvent.target.o2; if (o2jse.submitting) { jxjs.cachedObj = stdEvent.target; jxjs.cachedEvent = eventObj; jxjs.cachedCmd = "if(jxjs.cachedObj.style.display != 'none' && " + "jxjs.cachedObj.ondblclick){\n" + "o2jse.submitting=false;\n" + "o2jse.ctrl.zoom(jxjs.cachedEvent);}\n"; return false; } if (stdEvent.target.blur) { stdEvent.target.blur(); } if (infObj.z) { stdEvent.stop(); o2jse.infoForm['o2lastform'].value = infObj.f; o2jse.infoForm['o2lastctrl'].value = infObj.c; var zoomCtrl = o2jse.createInput(o2jse.infoForm, "hidden", "", infObj.c, "jxzoom"); zoomCtrl.o2 = infObj; zoomCtrl.o2.fret = true; o2jse.ctrl.make_waiting(stdEvent.target); if (o2jse.cliMode) { jxjs.request(); } else { o2jse.cmd.submit(infObj.e); } o2jse.removeEl(zoomCtrl); delete zoomCtrl; } return false; }; o2jse.ctrl.getByJxType = function(ctrlType, rootElement) { var retList = []; var retCtrl = null; var root = rootElement || o2jse.infoForm; var exeId = o2jse.infoForm['o2_prgexeid'].value; var found = false; var walker = document.createTreeWalker(document.body, NodeFilter.SHOW_ELEMENT, function(node) { if ((node.o2 || (node.hasAttribute && node.hasAttribute("o2") && o2jse.ctrl.init(node))) && node.o2.cT == ctrlType && node.o2.e == exeId) { return NodeFilter.FILTER_ACCEPT; } else { return NodeFilter.FILTER_SKIP; } }, false); while (walker.nextNode()) { if (walker.currentNode.style.display != "none") { retCtrl = walker.currentNode.o2.c; found = false; for (var i = retList.length - 1; i >= 0; i--) { if (retList[i] == retCtrl) { found = true; break; } } if (!found) { retList[retList.length] = retCtrl; } } } return retList; }; o2jse.ctrl.log = function(targetObj) { var infObj = targetObj.o2; if (infObj.log) { var logCtrl = o2jse.createInput(o2jse.infoForm, "hidden", "", infObj.c, "jxlogctrl"); logCtrl.o2 = infObj; logCtrl.o2.fret = true; o2jse.cmd.submit(infObj.e); } return false; }; o2jse.ctrl.btnExe = function(targetObj) { o2jse.ctrl.init(targetObj); o2Info = targetObj.o2; if (o2jse.submitting) { jxjs.cachedObj = targetObj; jxjs.cachedCmd = "if(jxjs.cachedObj.style.display != 'none' && " + "jxjs.cachedObj.onclick){\n" + "o2jse.submitting=false;\n" + "o2jse.ctrl.btnExe(jxjs.cachedObj);}\n"; return false; } if (o2jse.pu.timer) { clearTimeout(o2jse.pu.timer); } if (o2Info.msg == "" || o2jse.cmd.confirm(o2Info.msg)) { o2jse.infoForm['o2_prgexeid'].value = o2Info.e; o2jse.infoForm['o2_action'].value = o2Info.action; o2jse.infoForm['o2lastform'].value = o2Info.f; o2jse.infoForm['o2lastctrl'].value = o2Info.c; if (o2Info.fret) { o2jse.ctrl.make_waiting(targetObj); if (o2jse.cliMode) { jxjs.request(targetObj, targetObj.o2.action); } else { o2jse.cmd.submit(o2Info.e); } } else if (o2Info.cT == "button") { o2jse.ctrl.make_waiting(targetObj); } } }; o2jse.ctrl.viewSelection = function(sourceObj, newSelection) { o2jse.ctrl.init(sourceObj); var view_name = sourceObj.o2.v + "_vs" + sourceObj.o2.e; if (o2jse.infoForm[view_name]) { o2jse.infoForm[view_name].value = newSelection; } else { o2jse.createInput(o2jse.infoForm, "hidden", "", newSelection, view_name); } }; o2jse.ctrl.multiPage = function(targetObj, noRequest) { o2jse.ctrl.init(targetObj); var o2Info = targetObj.o2; var ctrlName = o2Info.c + String(o2Info.e); var mpField = o2jse.infoForm[ctrlName]; var oldValue = mpField.value; mpField.value = o2Info.page; o2jse.ctrl.init(mpField); var objDivClose = document.getElementById(ctrlName + "_p" + parseInt(oldValue)); var objBtnClose = document.getElementById(ctrlName + "_mpb" + parseInt(oldValue)); var objDivOpen = document.getElementById(ctrlName + "_p" + parseInt(o2Info.page)); var objBtnOpen = document.getElementById(ctrlName + "_mpb" + parseInt(o2Info.page)); objDivClose.style.display = 'none'; objBtnClose.className = mpField.o2.cssoff; objBtnClose.tabIndex = "0"; objBtnClose.onclick = function() { o2jse.ctrl.multiPage(this); }; objDivOpen.style.display = 'block'; objBtnOpen.className = mpField.o2.csson; objBtnOpen.tabIndex = "-1"; objBtnOpen.onclick = ""; o2jse.infoForm['o2lastform'].value = o2Info.f; o2jse.infoForm['o2lastctrl'].value = o2Info.c; if (objDivOpen.innerHTML.trim() == "") { objDivOpen.innerHTML = "<div class='jx_inctrl_wait'>&nbsp;</div>"; } if (!noRequest) { if (o2jse.cliMode) { jxjs.request(mpField, mpField.value); } else { o2jse.cmd.ctrlUpd(mpField); } } }; o2jse.tab = { gridPlus : false, autoSaveSettings : true, gridMultiDel : true, dblClickAct : "", wheelPaging : true, sortList : [] }; o2jse.tab.select = function(targetObj, eventObj) { if (o2jse.cliMode) { var tg = o2jse.event.std(eventObj).target; o2jse.ctrl.init(tg); var sourceRow = null; var ctrl = null; if (tg.tagName == "TD" && tg.firstChild) { tg = tg.firstChild; o2jse.ctrl.init(tg); } if (tg.o2.cT == "edit") { ctrl = o2jse.infoForm[tg.o2.c + tg.o2.e]; } else if (tg.o2.cT == "listcombo") { ctrl = o2jse.infoForm[tg.o2.c + tg.o2.e + "_desc"]; } if (ctrl) { var tdP = ctrl.parentNode; if (tdP) { var trP = tdP.parentNode; if (trP && trP.tagName == "TR") { sourceRow = (trP.parentNode.lastRow ? trP.parentNode.lastRow : trP); } } if (ctrl.disabled || ctrl.readOnly) { ctrl = null; } else { o2jse.infoForm['o2lastform'].value = tg.o2.f; o2jse.infoForm['o2lastctrl'].value = tg.o2.c; } } o2jse.tab.moveSel(sourceRow, targetObj); var pseudoC = document.getElementById(tg.o2.c + tg.o2.e + '_pseudoC_tab'); if (pseudoC) { var srcTab = document.getElementById(tg.o2.c + tg.o2.e + '_tab'); if (pseudoC.contains(tg)) { if (sourceRow) { var sRow = sourceRow.rowIndex + (srcTab.getElementsByTagName('TH') ? tg.o2.lines : 0); sourceRow = srcTab.rows[sRow]; } var tRow = targetObj.rowIndex + (srcTab.getElementsByTagName('TH') ? tg.o2.lines : 0); targetRow = srcTab.rows[tRow]; o2jse.tab.moveSel(sourceRow, targetRow, true); } else { if (sourceRow) { var sRow = sourceRow.rowIndex - (srcTab.getElementsByTagName('TH') ? tg.o2.lines : 0); sourceRow = pseudoC.rows[sRow]; } var tRow = targetObj.rowIndex - (srcTab.getElementsByTagName('TH') ? tg.o2.lines : 0); targetRow = pseudoC.rows[tRow]; o2jse.tab.moveSel(sourceRow, targetRow, true); } } if (ctrl && ctrl.focus) { ctrl.focus(); if (ctrl.select) { ctrl.select(); } } } else { o2jse.ctrl.init(targetObj); var objInfo = targetObj.o2; var rowNo = parseInt(targetObj.rowIndex / objInfo.lines); o2jse.infoForm[objInfo.c + objInfo.e].value = rowNo; o2jse.cmd.ctrlUpd(targetObj); } }; o2jse.tab.sort = function(targetObj) { o2jse.ctrl.init(targetObj); var sortField = o2jse.createInput(o2jse.infoForm, "hidden", "", targetObj.o2.inctrl, targetObj.o2.c + "_jxsort" + targetObj.o2.e); sortField.o2 = targetObj.o2; o2jse.cmd.ctrlUpd(sortField); }; o2jse.tab.rowOn = function(targetObj, eventObj, extraCss) { o2jse.ctrl.init(targetObj); var newClass = targetObj.o2.cssp + (extraCss ? ' ' + extraCss : ''); var pseudoC = document.getElementById(targetObj.o2.c + targetObj.o2.e + '_pseudoC_tab'); if (pseudoC) { if (pseudoC.contains(targetObj)) { var srcTab = document.getElementById(targetObj.o2.c + targetObj.o2.e + '_tab'); var row = targetObj.rowIndex + (srcTab.getElementsByTagName('TH') ? targetObj.o2.lines : 0); srcTab.rows[row].className = newClass; } else { var row = targetObj.rowIndex - (targetObj.parentNode.parentNode.getElementsByTagName('TH') ? targetObj.o2.lines : 0); pseudoC.rows[row].className = newClass; } } targetObj.className = newClass; }; o2jse.tab.rowOut = function(targetObj, eventObj, extraCss) { o2jse.ctrl.init(targetObj); var newClass = targetObj.o2.cssc + (extraCss ? " " + extraCss : ""); var pseudoC = document.getElementById(targetObj.o2.c + targetObj.o2.e + '_pseudoC_tab'); if (pseudoC) { if (pseudoC.contains(targetObj)) { var srcTab = document.getElementById(targetObj.o2.c + targetObj.o2.e + '_tab'); var row = targetObj.rowIndex + (srcTab.getElementsByTagName('TH') ? targetObj.o2.lines : 0); srcTab.rows[row].className = newClass; } else { var row = targetObj.rowIndex - (targetObj.parentNode.parentNode.getElementsByTagName('TH') ? targetObj.o2.lines : 0); pseudoC.rows[row].className = newClass; } } targetObj.className = newClass; }; o2jse.tab.activateMarker = function(markerObj) { o2jse.ctrl.init(markerObj); var objInfo = markerObj.o2; if (myTab = document.getElementById(objInfo.c + objInfo.e + "_tab")) { var myCont = myTab.parentNode; var scrollSave = 0; if (myCont.scrollLeft > 0) { scrollSave = myCont.scrollLeft; } o2jse.infoForm['o2lastform'].value = objInfo.f; o2jse.infoForm['o2lastctrl'].value = objInfo.c; if (markerObj.focus) { markerObj.focus(); } myCont.scrollLeft = scrollSave; } }; o2jse.tab.selectRow = function(bckwd, ctrlObj) { bckwd = bckwd != null && bckwd; var oldRow = ctrlObj.parentNode.parentNode; var oldRowId = oldRow.rowIndex; var newRowId = (bckwd ? (oldRowId - 1) : (oldRowId + 1)); var newRow = ctrlObj.parentNode.parentNode.parentNode.rows[newRowId - 1]; var o2Data = ctrlObj.o2; var seleField; if (newRowId > 0 && newRowId <= o2Data.rows) { var navName = o2Data.nav + o2Data.e + "_o2sel"; if (o2jse.infoForm[navName]) { o2jse.infoForm[navName].value = newRowId; } else { seleField = o2jse.createInput(o2jse.infoForm, "hidden", "", newRowId, navName); seleField.o2 = o2Data; } var emptyT = document.createElement("SPAN"); emptyT.innerHTML = "&nbsp;"; newRow.cells[0].replaceChild(oldRow.cells[0]. replaceChild(emptyT, oldRow.cells[0].childNodes[0]), newRow.cells[0].childNodes[0]); } o2jse.infoForm['o2lastform'].value = o2Data.f; o2jse.infoForm['o2lastctrl'].value = o2Data.c; ctrlObj.focus(); }; o2jse.tab.rowDblClick = function(eventObj) { if (o2jse.tab.dblClickAct.trim() == "") { return; } var stdEvent = o2jse.event.std(eventObj); var targetObj = stdEvent.target; var trObj = (targetObj.tagName.toLowerCase() == 'tr' ? targetObj : o2jse.getParentTag(targetObj, 'tr')); o2jse.ctrl.init(trObj); var infoObj = trObj.o2; var navName = ""; if (infoObj.nav) { navName = infoObj.nav + String(infoObj.e); } if (navName) { stdEvent.stop(); var navLocal = o2jse.infoForm[navName]; o2jse.ctrl.init(navLocal); if (navLocal.o2.navSele && (o2jse.tab.dblClickAct == "S" || o2jse.tab.dblClickAct == "B")) { o2jse.nav.btnExe(document.getElementById(navName + "_selebtn")); } else if (navLocal.o2.navDet && (o2jse.tab.dblClickAct == "D" || o2jse.tab.dblClickAct == "B")) { o2jse.nav.btnExe(document.getElementById(navName + "_detbtn")); } } }; o2jse.tab.startColMovingTO = function(eventObj) { o2jse.tab.colMovTimeOut = setTimeout(function() { o2jse.tab.startColMoving(eventObj); }, 700); document.onmouseup = function() { if (o2jse.tab.colMovTimeOut) { clearTimeout(o2jse.tab.colMovTimeOut); }; document.onmouseup = null; }; }; o2jse.tab.startColMoving = function(eventObj) { var stdEvent = o2jse.event.std(eventObj); var targetObj = eventObj.target; o2jse.ctrl.init(targetObj); if (stdEvent.button != 2) { stdEvent.stop(); var colObj = targetObj; var tabObj = document.getElementById(colObj.o2.c + colObj.o2.e +"_tab"); var divObj = tabObj.parentNode; var ths = tabObj.getElementsByTagName("thead")[0].getElementsByTagName("th"); var hObj = colObj; var totY = 0; do { totY += hObj.offsetTop; } while (hObj = hObj.offsetParent); var wObj = colObj; var totX = 0; do { totX += wObj.offsetLeft; } while (wObj = wObj.offsetParent); wObj = divObj; var tabX = 0; do { tabX += wObj.offsetLeft; } while (wObj = wObj.offsetParent); var sLine = o2jse.createEl(o2jse.elBody, "div", "o2_tab_resize_line"); sLine.style.position = "absolute"; sLine.style.height = divObj.parentNode.offsetHeight + "px"; sLine.style.top = totY + "px"; sLine.style.left = totX + "px"; o2jse.tab.movingCol = { t: tabObj, s: colObj.o2.inctrl, c: ths, o: colObj.o2.col, m: sLine, l: tabX, r: tabX + divObj.offsetWidth }; o2jse.cmd.opacity(tabObj, 50); o2jse.cmd.startGlass(o2jse.tab.moveColTo, o2jse.tab.stopColMoving, "move", false, true); } }; o2jse.tab.moveColTo = function(eventObj) { var movingCol = o2jse.tab.movingCol; var stdEvent = o2jse.event.std(eventObj); stdEvent.stop(); var x = stdEvent.x; var rect; var lBorder; if (x >= movingCol.l && x <= movingCol.r) { for (var i = 0; i < movingCol.c.length; i++) { rect = movingCol.c[i].getBoundingClientRect(); if (x >= rect.left && x <= rect.right) { lBorder = rect.left; } } movingCol.m.style.left = lBorder + 'px'; } if (document.selection) { document.selection.empty() } else { window.getSelection().removeAllRanges() } }; o2jse.tab.stopColMoving = function(eventObj, stopped) { var movingCol = o2jse.tab.movingCol; var stdEvent = o2jse.event.std(eventObj); stdEvent.stop(); o2jse.cmd.stopGlass(); o2jse.cmd.opacity(movingCol.t, 100); o2jse.removeEl(movingCol.m); if (stopped) { return; } var tab = movingCol.t; o2jse.ctrl.init(tab); var x = stdEvent.x; var rect; var colIdx; var rm = (movingCol.c[0].className === "o2_tab_marker" ? 0 : 1); if (x >= movingCol.l && x <= movingCol.r) { for (var i = 0; i < movingCol.c.length; i++) { rect = movingCol.c[i].getBoundingClientRect(); if (x >= rect.left && x <= rect.right) { o2jse.ctrl.init(movingCol.c[i]); colIdx = movingCol.c[i].o2.col + rm; break } } } if (!colIdx) { colIdx = 1; } else if (colIdx > movingCol.o) { colIdx--; } var sortField = o2jse.createInput(o2jse.infoForm, "hidden", "", "array('" + movingCol.s + "'=>" + colIdx + ")", tab.o2.c + "_jxocol" + tab.o2.e); sortField.o2 = tab.o2; if (o2jse.cliMode) { jxjs.request(sortField, sortField.value); } else { o2jse.cmd.ctrlUpd(sortField); } o2jse.removeEl(sortField); }; o2jse.tab.startSizing = function(eventObj) { var stdEvent = o2jse.event.std(eventObj); var targetObj = eventObj.target; o2jse.ctrl.init(targetObj); if (stdEvent.button != 2) { stdEvent.stop(); var tabObj = document.getElementById(targetObj.o2.c + targetObj.o2.e +"_tab"); var divObj = tabObj.parentNode; var ths = tabObj.getElementsByTagName("thead")[0].getElementsByTagName("th"); var colIdx = 0; var colObj; do { colIdx++; colObj = ths[targetObj.o2.col - colIdx]; } while (colObj.style.display == "none"); var sLine = o2jse.createEl(o2jse.elBody, "div", "o2_tab_resize_line"); var hObj = targetObj; var totY = 0; do { totY += hObj.offsetTop; } while (hObj = hObj.offsetParent); o2jse.ctrl.init(colObj); sLine.style.position = "absolute"; sLine.style.height = tabObj.getElementsByTagName("tbody")[0].offsetHeight + targetObj.parentNode.offsetHeight + "px"; sLine.style.top = totY + "px"; sLine.style.left = stdEvent.x + "px"; o2jse.tab.movingCol = { t: tabObj, c: colObj.o2.inctrl, m: sLine, s: stdEvent.x, l: stdEvent.x - colObj.offsetWidth, r: divObj.offsetWidth + stdEvent.x}; o2jse.cmd.opacity(tabObj, 50); o2jse.cmd.startGlass(o2jse.tab.sizeTo, o2jse.tab.stopSizing, "col-resize"); } }; o2jse.tab.sizeTo = function(eventObj) { var movingCol = o2jse.tab.movingCol; var stdEvent = o2jse.event.std(eventObj); stdEvent.stop(); if (stdEvent.x >= movingCol.l && stdEvent.x <= movingCol.r) { movingCol.m.style.left = stdEvent.x + 'px'; } }; o2jse.tab.stopSizing = function(eventObj) { var movingCol = o2jse.tab.movingCol; var stdEvent = o2jse.event.std(eventObj); stdEvent.stop(); o2jse.cmd.stopGlass(); o2jse.cmd.opacity(movingCol.t, 100); o2jse.removeEl(movingCol.m); var targetObj = movingCol.t; o2jse.ctrl.init(targetObj); var sizeField = o2jse.createInput(o2jse.infoForm, "hidden", "", movingCol.c + ":" + (stdEvent.x - movingCol.s), targetObj.o2.c + "_jxsize" + targetObj.o2.e); sizeField.o2 = targetObj.o2; if (o2jse.cliMode) { jxjs.request(sizeField, sizeField.value); } else { o2jse.cmd.ctrlUpd(sizeField); } o2jse.removeEl(sizeField); }; o2jse.tab.changeRow = function(targetObj, movDir, navName) { o2jse.ctrl.init(targetObj); if (targetObj.o2.cT == "button" && !targetObj.o2.fret) { return false; } targetObj.blur(); var sourceRow = (targetObj.o2.cT == 'listcombo' ? targetObj.parentNode.parentNode.parentNode : targetObj.parentNode.parentNode); var targetRow; if (movDir == "P") { if (sourceRow.rowIndex > 1) { targetRow = sourceRow.previousSibling; } else { if (navName) { var navLocal = o2jse.infoForm[navName]; o2jse.ctrl.init(navLocal); if (navLocal.o2.navNav && (navBtn = document.getElementById(navName + "_pbtn"))) { return o2jse.nav.btnExe(navBtn); } } } } else { if (sourceRow.rowIndex < sourceRow.parentNode.rows.length) { targetRow = sourceRow.nextSibling; } else { if (navName) { var navLocal = o2jse.infoForm[navName]; o2jse.ctrl.init(navLocal); if (navLocal.o2.navNav && (navBtn = document.getElementById(navName + "_nbtn"))) { return o2jse.nav.btnExe(navBtn); } } } } if (targetRow) { o2jse.ctrl.init(targetRow); o2jse.tab.moveSel(sourceRow, targetRow); } var targetInRow; if (targetObj.name) { var targetsInRow = document.getElementsByName(targetObj.name); if (targetsInRow.length > 1) { targetInRow = targetsInRow[targetRow.rowIndex - 1]; } else { targetInRow = targetObj; } } else { targetInRow = targetObj; } if (targetInRow.focus) { targetInRow.focus(); if (targetInRow.select) { targetInRow.select(); } } }; o2jse.tab.moveSel = function(sourceRow, targetRow, noRequest) { o2jse.ctrl.init(targetRow); var rowsCont = targetRow.parentNode; var viewField = o2jse.infoForm[targetRow.o2.v + "_vs" + targetRow.o2.e]; if (!sourceRow) { if (rowsCont.lastRow) { sourceRow = rowsCont.lastRow; } else { sourceRow = rowsCont.rows[viewField.value - 1]; o2jse.ctrl.init(sourceRow); } } rowsCont.lastRow = targetRow; if (sourceRow == targetRow) { return; } var newSele = parseInt(targetRow.rowIndex / targetRow.o2.lines); if (!noRequest) { jxjs.request(targetRow, newSele); } viewField.value = newSele; for (var cellId = (sourceRow.cells.length - 1); cellId >= 0; cellId--) { var sourceField = o2jse.firstRealChild(sourceRow.cells[cellId]); var targetField = o2jse.firstRealChild(targetRow.cells[cellId]); if (targetField != null) { o2jse.ctrl.init(sourceField); o2jse.ctrl.init(targetField); var sourceParent = sourceField.parentNode; var targetParent = targetField.parentNode; var bodyClass = sourceParent.getAttribute("cssc"); var pointClass = targetParent.getAttribute("cssp"); sourceParent.removeAttribute("cssc"); targetParent.removeAttribute("cssp"); targetParent.setAttribute("cssc", targetParent.className); sourceParent.setAttribute("cssp", sourceParent.className); targetParent.className = pointClass; sourceParent.className = bodyClass; if (sourceParent.onmouseover) { targetParent.onmouseover = sourceParent.onmouseover; targetParent.onmouseout = sourceParent.onmouseout; sourceParent.onmouseover = null; sourceParent.onmouseout = null; } var rowMarker = (sourceField.className.substr(0, 13) == "o2_tab_marker"); if (sourceField.tagName.toLowerCase() != "div" || sourceField.o2 || rowMarker) { switch (sourceField.o2.cT) { case "img": sourceField.o2.fret = false; targetField.o2.fret = true; break; case "button": sourceField.o2.fret = false; targetField.o2.fret = true; targetField.id = sourceField.id; sourceField.removeAttribute('id'); break; case "listcombo": var targetClone = targetField.cloneNode(true); if (sourceField.options) { var sourceSele = sourceField.options.selectedIndex; targetClone.innerHTML = sourceField.options[sourceSele].text; sourceField.value = ""; sourceField.value = targetField.innerHTML.trim(). substr(0, sourceField.o2.s); targetParent.replaceChild(sourceField, targetField); sourceParent.appendChild(targetClone); } else { code_field = document.getElementsByName(targetField.o2.c + targetField.o2.e); if (code_field[0]) { targetField.appendChild(code_field[0].cloneNode(true)); } if (sourceField.tagName.toLowerCase() == 'div' && !sourceField.firstElementChild) { targetClone.innerHTML = sourceField.innerHTML; sourceField.innerHTML = targetField.innerHTML; targetParent.replaceChild(sourceField, targetField); sourceParent.innerHTML = ""; sourceParent.appendChild(targetClone); delete sourceField.saveValue; sourceParent.insertBefore(targetClone, sourceParent.firstChild); } else { sourceFrame = sourceField; sourceField = o2jse.firstRealChild(sourceFrame); targetClone.innerHTML = sourceField.value; var newValue = targetField.firstChild .textContent.trim(); sourceField.value = newValue.decode(); delete sourceField.saveValue; targetParent.replaceChild(sourceFrame, targetField); sourceParent.insertBefore(targetClone, sourceParent.firstChild); } } break; case "checkbox": var targetClone = targetField.cloneNode(true); targetClone.checked = sourceField.checked; sourceField.checked = targetField.checked; if (targetClone.hasAttribute('name')) { targetClone.removeAttribute('name'); } sourceField.setAttribute('name', sourceField.o2.c + sourceField.o2.e); targetParent.replaceChild(sourceField, targetField); sourceParent.innerHTML = ""; sourceParent.appendChild(targetClone); break; default: if (rowMarker) { var targetClone = targetField.cloneNode(true); targetClone.innerHTML = sourceField.innerHTML; sourceField.innerHTML = targetField.innerHTML; targetParent.replaceChild(sourceField, targetField); sourceParent.innerHTML = ""; sourceParent.appendChild(targetClone); o2jse.tab.activateMarker(sourceField); } else if (typeof sourceField.value != "undefined") { var targetClone = targetField.cloneNode(true); targetClone.innerHTML = sourceField.value; var newValue = targetField.innerHTML; sourceField.value = (newValue.trim() == "&nbsp;" ? "" : newValue.decode()); targetParent.replaceChild(sourceField, targetField); sourceParent.innerHTML = ""; sourceParent.appendChild(targetClone); } else if(sourceField.o2.cT == 'edit' || sourceField.o2.cT == 'text') { var targetClone = targetField.cloneNode(true); targetClone.innerHTML = sourceField.innerHTML; sourceField.innerHTML = targetField.innerHTML; targetParent.replaceChild(sourceField, targetField); sourceParent.innerHTML = ""; sourceParent.appendChild(targetClone); } else if (sourceField.id) { targetField.id = sourceField.id; sourceField.removeAttribute('id'); } break; } } else if (sourceField.id) { targetField.id = sourceField.id; sourceField.removeAttribute('id'); } } } o2jse.ctrl.init(sourceRow); var infoForm = o2jse.infoForm; var focusCtrl = infoForm[infoForm['o2lastctrl'].value + infoForm['o2_prgexeid'].value]; var sourceSaveOver = sourceRow.onmouseover; var sourceSaveOut = sourceRow.onmouseout; var sourceSaveClick = sourceRow.onclick; sourceRow.className = sourceRow.o2.cssc; sourceRow.o2.tabRow = true; sourceRow.onmouseover = targetRow.onmouseover; sourceRow.onmouseout = targetRow.onmouseout; sourceRow.onclick = targetRow.onclick; targetRow.className = targetRow.o2.cssc + " o2tab_current"; targetRow.onmouseover = sourceSaveOver; targetRow.onmouseout = sourceSaveOut; targetRow.onclick = sourceSaveClick; targetRow.o2.tabRow = false; o2jse.ctrl.viewSelection(sourceRow, targetRow.rowIndex); if (focusCtrl && focusCtrl.focus) { focusCtrl.focus(); if (focusCtrl.select) { focusCtrl.select(); } } }; o2jse.tab.set = function(tabName, fillRows, scrollLeft, scrollTop, focusCtrl) { if (!(myTab = document.getElementById(tabName + "_tab"))) { return false; } var myCont = myTab.parentNode; var contAll = myCont.parentNode; var hScroll = myCont.scrollWidth > myCont.clientWidth; var vScroll = myCont.scrollHeight > myCont.clientHeight; var myHead = myTab.getElementsByTagName("thead")[0]; var myFoot = myTab.getElementsByTagName("tfoot")[0]; var hScrollName = tabName + "_hscroll"; var vScrollName = tabName + "_vscroll"; if (!myCont.offsetWidth || myTab.setDone) { return; } else { myTab.setDone = true; } o2jse.createInput(contAll, "hidden", null, scrollLeft, hScrollName); if (scrollLeft > 0) { myCont.scrollLeft = scrollLeft; } codeOnScroll = "document.forms.o2form['" + hScrollName + "'].value=this.scrollLeft;"; if (vScroll) { o2jse.createInput(contAll, "hidden", null, scrollTop, vScrollName); if (scrollTop > 0) { myCont.scrollTop = scrollTop; } codeOnScroll+= "document.forms.o2form['" + vScrollName + "'].value=this.scrollTop;"; } if (myHead) { for (var i = (myHead.rows[0].cells.length - 1); i >= 0; i--) { var myCell = myHead.rows[0].cells[i]; if (!myCell.style.width) { myCell.style.width = myCell.offsetWidth + "px"; } } myTab.style.tableLayout = "fixed"; if (vScroll) { var hTab = myTab.cloneNode(false); hTab.style.width = myTab.offsetWidth + "px"; hTab.appendChild(myHead.cloneNode(true)); var pseudoH = document.createElement("div"); pseudoH.id = tabName + "_pseudoH"; pseudoH.style.position = "absolute"; pseudoH.style.overflow = "hidden"; pseudoH.style.top = myCont.clientTop + "px"; pseudoH.style.left = myCont.clientLeft + "px"; pseudoH.style.width = myCont.clientWidth + "px"; pseudoH.style.height = myHead.offsetHeight + "px"; pseudoH.appendChild(hTab); contAll.appendChild(pseudoH); codeOnScroll+= "document.getElementById('" + pseudoH.id + "').scrollLeft=this.scrollLeft;"; } } if (myFoot && (vScroll || fillRows > 0)) { for (var i = (myFoot.rows[0].cells.length - 1); i >= 0; i--) { var myCell = myFoot.rows[0].cells[i]; myCell.style.width = myCell.offsetWidth + "px"; } myTab.style.tableLayout = "fixed"; var fTab = myTab.cloneNode(false); fTab.style.width = myTab.offsetWidth + "px"; fTab.appendChild(myFoot.cloneNode(true)); var pseudoF = document.createElement("div"); pseudoF.id = tabName + "_pseudoF"; pseudoF.style.position = "absolute"; pseudoF.style.overflow = "hidden"; pseudoF.style.bottom = (myCont.offsetHeight - myCont.clientHeight - myCont.clientTop) + "px"; pseudoF.style.left = myCont.clientLeft + "px"; pseudoF.style.width = myCont.clientWidth + "px"; pseudoF.style.height = myFoot.offsetHeight + "px"; myFoot.style.visibility = "hidden"; pseudoF.appendChild(fTab); contAll.appendChild(pseudoF); codeOnScroll+= "document.getElementById('" + pseudoF.id + "').scrollLeft=this.scrollLeft;"; } o2jse.ctrl.init(myTab); if (myTab.o2.pc) { var pinCols = myTab.o2.pc; if (hScroll) { if (myTab.getElementsByTagName('TR')[0] .firstElementChild.className.substr(0, 13) == 'o2_tab_marker') { pinCols++; } var startRow = (myHead ? 1 : 0); var startTop = myCont.clientTop + (myHead ? myHead.offsetHeight : 0); var fWidth = 0; myTab.style.tableLayout = "fixed"; var fTab = myTab.cloneNode(false); fTab.id = tabName + '_pseudoC_tab'; for (var i = startRow; i < myTab.rows.length; i++) { myTab.rows[i].style.height = myTab.rows[i].offsetHeight + 'px'; var fRow = fTab.appendChild(myTab.rows[i].cloneNode(false)); for (var n = 0; n < pinCols; n++) { var myCell = myTab.rows[i].cells[n]; if (!myCell.style.width) { myCell.style.width = myCell.offsetWidth + "px"; } if (i == startRow) { fWidth+= myCell.offsetWidth; } var newCell = myCell.cloneNode(true); newCell.style.width = myCell.offsetWidth + 'px'; fRow.appendChild(newCell); delete(myCell); } delete(fRow); } if (myHead) { var fH = document.createElement('table').appendChild(myHead.cloneNode(false)); var fR = fH.appendChild(myHead.rows[0].cloneNode(false)); for (var n = 0; n < pinCols; n++) { var myC = myHead.rows[0].cells[n]; myC.style.width = myC.offsetWidth + 'px'; fR.appendChild(myC.cloneNode(true)); } var pseudoCH = document.createElement('div'); pseudoCH.id = tabName + '_pseudoCH'; pseudoCH.style.position = 'absolute'; pseudoCH.style.top = myCont.clientTop + 'px'; pseudoCH.style.left = myCont.clientLeft + 'px'; pseudoCH.style.width = fWidth + 'px'; fR.style.height = myHead.offsetHeight + 'px'; pseudoCH.appendChild(fH); contAll.appendChild(pseudoCH); } var pseudoC = document.createElement('div'); pseudoC.id = tabName + '_pseudoC'; pseudoC.className = 'o2_tab_pinned'; pseudoC.style.position = 'absolute'; pseudoC.style.overflow = 'hidden'; pseudoC.style.top = startTop + 'px'; pseudoC.style.left = myCont.clientLeft + 'px'; pseudoC.style.width = fWidth + 'px'; pseudoC.style.height = (myCont.clientHeight - (myHead ? myHead.offsetHeight : 0)) + "px"; pseudoC.appendChild(fTab); contAll.appendChild(pseudoC); codeOnScroll+= "document.getElementById('" + pseudoC.id + "').scrollTop=this.scrollTop;"; } } myCont.onscroll = new Function("o2jse.lu.listOff();" + codeOnScroll); if (fillRows == 0) { myTab.style.height = myCont.clientHeight + "px"; } if (o2jse.tab.wheelPaging) { myCont.addEventListener('mousewheel', function(e) { o2jse.tab.mouseScroll(e, myCont); }); myCont.addEventListener('DOMMouseScroll', function(e) { o2jse.tab.mouseScroll(e, myCont); }); } if (focusCtrl) { o2jse.cmd.focus(focusCtrl); } }; o2jse.tab.mouseScroll = function(wEvent, viewPort) { var stdEvent = o2jse.event.std(wEvent); var now = (new Date).valueOf(); if (stdEvent.delta) { var navName = stdEvent.target.o2.nav + String(stdEvent.target.o2.e); var doIt = false; if (stdEvent.delta > 0) { if ((viewPort.scrollHeight - viewPort.scrollTop) <= viewPort.offsetHeight) { if (navBtn = document.getElementById(navName + "_npbtn")) { if ((now - viewPort.scrollUpReady) > 300 || viewPort.scrollHeight <= viewPort.offsetHeight) { doIt = true; viewPort.scrollUpReady = 0; } else { viewPort.scrollUpReady = now; } } } } else { if (viewPort.scrollTop < 1) { if (navBtn = document.getElementById(navName + "_ppbtn")) { if ((now - viewPort.scrollDownReady) > 300 || viewPort.scrollHeight <= viewPort.offsetHeight) { doIt = true; viewPort.scrollDownReady = 0; } else { viewPort.scrollDownReady = now; } } } } if (doIt) { stdEvent.stop(); stdEvent.target.blur(); o2jse.nav.btnExe(navBtn); } } }; o2jse.tab.initContMenu = function() { var jxInfo = o2jse.cMenu.target.o2; if (jxInfo.cT == "tab") { var mTb = document.getElementById(jxInfo.c + jxInfo.e); o2jse.ctrl.init(mTb); var mTbInfo = mTb.o2; o2jse.tab.customInfo = jxInfo; if (o2jse.menu.menuList["jxGridExtra"]) { o2jse.menu.menuList["jxGridExtra"].clear(); } if (!(mTbInfo.gp_vc && mTbInfo.gp_oc && mTbInfo.gp_fr && mTbInfo.gp_sr && mTbInfo.gp_rn && mTbInfo.gp_xp && mTbInfo.gp_dl)) { o2jse.cMenu.addItem("M", "jxGridExtra", "Table", "", o2jse.rntAlias + "img/grid/grid.png"); if (!mTbInfo.gp_vc) { o2jse.menu.menuList["jxGridExtra"].addItem("M", "jxCustumTabCols", "Visible columns", "", o2jse.rntAlias + "img/grid/cols.png"); o2jse.tab.visibleCols(jxInfo); } if (!mTbInfo.gp_oc) { o2jse.menu.menuList["jxGridExtra"].addItem("M", "jxGridOrder", "Order columns", "", o2jse.rntAlias + "img/grid/order.png"); o2jse.tab.orderCols(jxInfo); } if (!mTbInfo.gp_fr) { o2jse.menu.menuList["jxGridExtra"].addItem("J", "jxGridFilter", "Filter data", o2jse.tab.filter, o2jse.rntAlias + "img/grid/filter.png"); } if (!mTbInfo.gp_sr) { o2jse.menu.menuList["jxGridExtra"].addItem("M", "jxGridSort", "Sort data", "", o2jse.rntAlias + "img/grid/sort.png"); o2jse.tab.sortCols(jxInfo); } if (!mTbInfo.gp_rn) { o2jse.menu.menuList["jxGridExtra"].addItem("J", "jxGridRows", "Set rows number", o2jse.tab.setRowsN, o2jse.rntAlias + "img/grid/rows.png"); } if (!mTbInfo.gp_xp) { o2jse.menu.menuList["jxGridExtra"].addItem("J", "jxGridExport", "Export data", o2jse.tab.exportData, o2jse.rntAlias + "img/grid/export.png"); } if (o2jse.tab.gridMultiDel && !mTbInfo.gp_dl) { if (mTbInfo.nav && document.getElementById(mTbInfo.nav + mTbInfo.e + "_delbtn")) { o2jse.menu.menuList["jxGridExtra"].addItem("J", "jxGridDeleteAll", "Delete filtered data", function () { o2jse.tab.deleteData(mTbInfo.nav); }, o2jse.rntAlias + "img/grid/delete.png"); } } if (!(mTbInfo.gp_vc && mTbInfo.gp_oc && mTbInfo.gp_rn)) { o2jse.menu.menuList["jxGridExtra"].addItem("S"); o2jse.menu.menuList["jxGridExtra"].addItem("J", "jxGridReset", "Reset", o2jse.tab.resetCols, o2jse.rntAlias + "img/grid/reset.png"); if (o2jse.tab.autoSaveSettings == 2) { o2jse.menu.menuList["jxGridExtra"].addItem("J", "jxGridSave", "Save settings", o2jse.tab.saveSettings, o2jse.rntAlias + "img/grid/save.png"); } } return true; } else { return false; } } else { return false; } }; o2jse.tab.colExe = function(eventObj, prgID, actName, ctrlName) { var stdEvent = o2jse.event.std(eventObj); var targetObj = stdEvent.target; stdEvent.stop(); o2jse.ctrl.init(targetObj); var colExeField = o2jse.createInput(o2jse.infoForm, "hidden", "", actName, targetObj.o2.c + "_jxcexe" + targetObj.o2.e); var ctrlObj = o2jse.createInput(o2jse.infoForm, "hidden", "", ctrlName, "extp_1"); colExeField.o2 = targetObj.o2; if (o2jse.cliMode) { jxjs.request(colExeField, ""); } else { o2jse.cmd.ctrlUpd(colExeField); } o2jse.removeEl(colExeField); o2jse.removeEl(ctrlObj); delete colExeField; delete ctrlObj; o2jse.ctrl.make_waiting(targetObj); }; o2jse.tab.visibleCols = function(jxInfo) { var frameTable = document.createElement("TABLE"); frameTable.id = "jxcolvis_table"; var gridObj = document.getElementById(jxInfo.c + jxInfo.e + "_tab"); var cols = gridObj.getElementsByTagName("thead")[0].getElementsByTagName("th"); var colsLen = cols.length; var singleRow = frameTable.insertRow(-1); var fieldCell = singleRow.insertCell(-1); var valueCell = singleRow.insertCell(-1); fieldCell.innerHTML = "Select/unselect all: "; valueCell.innerHTML = "<input type='checkbox' checked='checked' title='Select all' " + "class='o2_ctrl_check'  onclick='o2jse.tab.visColsAll(!0);'>" + "<input type='checkbox' title='Unselect all' " + "class='o2_ctrl_check'  onclick='o2jse.tab.visColsAll(!1);'>"; singleRow = frameTable.insertRow(-1); fieldCell = singleRow.insertCell(-1); fieldCell.colSpan = 2; fieldCell.innerHTML = "<hr class='o2_ctrl_line'>"; for (var i = 0; i < colsLen - 1; i++) { o2jse.ctrl.init(cols[i]); if (cols[i].className.substr(0, 13) != "o2_tab_marker" && cols[i].o2.v) { singleRow = frameTable.insertRow(-1); fieldCell = singleRow.insertCell(-1); valueCell = singleRow.insertCell(-1); fieldCell.innerHTML = (cols[i].innerText || cols[i].textContent).trim(); var checkName = jxInfo.c + jxInfo.e + "_jxcolvis" + i; var checkObj = o2jse.createInput(valueCell, "checkbox", "o2_ctrl_check", null, checkName); checkObj.jxColId = cols[i].o2.inctrl; if (cols[i].style.display != "none") { checkObj.checked = "checked"; } } } singleRow = frameTable.insertRow(-1); fieldCell = singleRow.insertCell(-1); fieldCell.colSpan = 2; fieldCell.innerHTML = "<hr class='o2_ctrl_line'>"; singleRow = frameTable.insertRow(-1); fieldCell = singleRow.insertCell(-1); fieldCell.colSpan = 2; fieldCell.align = "center"; fieldCell.innerHTML = "<input type='button' value='Apply' class='o2_ctrl_button'" + "onclick='o2jse.tab.customizeCols();'>"; o2jse.menu.menuList["jxCustumTabCols"].context(frameTable); }; o2jse.tab.visColsAll = function(selectAll) { const cols = document.querySelectorAll('#jxcolvis_table input[type="checkbox"]'); for (var i = 0; i < cols.length; i++) { if (i == 0) { cols[i].checked = "checked"; } else if (i == 1) { cols[i].checked = false; } else { cols[i].checked = selectAll; } } }; o2jse.tab.sortCols = function(jxInfo) { var frameTable = document.createElement("TABLE"); var gridObj = document.getElementById(jxInfo.c + jxInfo.e + "_tab"); var cols = gridObj.getElementsByTagName("thead")[0].getElementsByTagName("th"); var colsLen = cols.length; var sortList = []; for (var i = 0; i < colsLen - 1; i++) { o2jse.ctrl.init(cols[i]); var singleRow = frameTable.insertRow(-1); var sortSpans = cols[i].getElementsByTagName("span"); if (sortSpans[0] && cols[i].o2.v) { var sortField = cols[i].o2.inctrl; var sortTag = " class='" + sortSpans[0].className + "' style='cursor:pointer'"; var sortTitle = (sortSpans[0].className == "o2_tab_sort" ? "Sort by this column ascending" : (sortSpans[0].className == "o2_tab_sorta" ? "Sort by this column descending" : "Do not sort by this column")); var fieldCell = singleRow.insertCell(-1); var sortCell = singleRow.insertCell(-1); sortCell.innerHTML = "<div onclick='o2jse.tab.sortCol(" + i + ",\"" + sortField + "\")' title='" + sortTitle + "'" + sortTag + ">&nbsp;</div>"; var sortText = cols[i].innerText || cols[i].textContent; var indexCell = singleRow.insertCell(-1); var indexText = ""; if (sortSpans[1]) { indexText = (sortSpans[1].innerText || sortSpans[1].textContent); sortText = sortText.trim(); sortText = sortText.substr(0, (sortText.length - 1)); if (parseInt(indexText) > 0) { sortList[i] = [parseInt(sortSpans[1].innerText || sortSpans[1].textContent), sortField]; } } indexCell.innerHTML = "<div class='o2_tab_sorti'>" + indexText + "</div>"; fieldCell.innerHTML = sortText.trim(); } } o2jse.tab.sortList = sortList; singleRow = frameTable.insertRow(-1); fieldCell = singleRow.insertCell(-1); fieldCell.colSpan = 2; fieldCell.align = "center"; fieldCell.innerHTML = "<input type='button' value='Apply' class='o2_ctrl_button'" + "onclick='o2jse.tab.customizeSort();'>"; o2jse.menu.menuList["jxGridSort"].context(frameTable); }; o2jse.tab.sortCol = function(colN, colField) { var frame = o2jse.menu.menuList["jxGridSort"].inBox.getElementsByTagName("table")[0]; var cols = frame.getElementsByTagName("tr"); var sDivs = cols[colN].getElementsByTagName("div"); var sDiv = sDivs[0]; var sIndex = sDivs[1]; var sClass = sDiv.className; var sList = o2jse.tab.sortList; var sCount = 0; for(k in sList) { if(sList[k] != undefined) { sCount++; } } if (sClass == "o2_tab_sort") { sList[colN] = [(sCount + 1), colField]; sDiv.className = "o2_tab_sorta"; sIndex.innerHTML = sList[colN][0]; } else if (sClass == "o2_tab_sorta") { sDiv.className = "o2_tab_sortd"; } else { sDiv.className = "o2_tab_sort"; var sPos = sList[colN][0]; for (n = cols.length; n >= 0; n--) { if (sList[n] && sList[n][0] > sPos) { sList[n][0]--; cols[n].getElementsByTagName("div")[1].innerHTML = sList[n][0]; } } sIndex.innerHTML = ""; delete sList[colN]; } }; o2jse.tab.orderCols = function(jxInfo) { var frameTable = document.createElement("TABLE"); var gridObj = document.getElementById(jxInfo.c + jxInfo.e + "_tab"); var cols = gridObj.getElementsByTagName("thead")[0].getElementsByTagName("th"); var colsLen = cols.length; var style = 'style="cursor:pointer;margin-left:5px"'; var start = false; var singleRow; var fieldCell; var btnUpCell; var btnUpObj; var btnDownCell; var btnDownObj; for (var i = 0; i < colsLen - 1; i++) { o2jse.ctrl.init(cols[i]); if (cols[i].className.substring(0, 13) != "o2_tab_marker" && cols[i].o2.v) { var ctrlName = cols[i].o2.inctrl; singleRow = frameTable.insertRow(-1); singleRow.dataset.col = cols[i].o2.col; fieldCell = singleRow.insertCell(-1); fieldCell.innerHTML = (cols[i].innerText || cols[i].textContent).trim(); btnUpCell = singleRow.insertCell(-1); btnUpObj = o2jse.createEl(btnUpCell, 'div', '', '<img src="' + o2jse.rntAlias + 'img/grid/up.png" title="Move column up" ' + 'onclick="o2jse.tab.orderCol(this,\'U\',\'' + ctrlName + '\');" ' + style + '>'); if (!start) { btnUpObj.firstChild.style.display = 'none'; } start = true; btnDownCell = singleRow.insertCell(-1); btnDownObj = o2jse.createEl(btnDownCell, 'div', '', '<img src="' + o2jse.rntAlias + 'img/grid/down.png" title="Move column down" ' + 'onclick="o2jse.tab.orderCol(this,\'D\',\'' + ctrlName + '\');" ' + style + '>'); } } btnDownObj.firstChild.style.display = 'none'; singleRow = frameTable.insertRow(-1); fieldCell = singleRow.insertCell(-1); fieldCell.colSpan = 3; fieldCell.align = "center"; fieldCell.innerHTML = "<input type='button' value='Apply' class='o2_ctrl_button'" + "onclick='o2jse.tab.customizeColsOrder();'>"; o2jse.tab.orderList = []; o2jse.menu.menuList["jxGridOrder"].context(frameTable); }; o2jse.tab.orderCol = function(imgTag, mode, colCtrl) { var tr = imgTag.parentNode.parentNode.parentNode; var idx = tr.rowIndex + 1; var colSave = tr.dataset.col; var rows = tr.parentNode.rows.length - 1; var tds; if (mode == 'U') { if (idx == 2) { imgTag.style.display = 'none'; tds = tr.previousSibling.getElementsByTagName('td'); tds[1].firstChild.firstChild.style.display = 'block'; o2jse.tab.orderList[colCtrl] = tr.previousSibling.dataset.col; tr.dataset.col = tr.previousSibling.dataset.col; } else if (idx == rows) { tds = tr.getElementsByTagName('td'); tds[2].firstChild.firstChild.style.display = 'block'; tds = tr.previousSibling.getElementsByTagName('td'); tds[2].firstChild.firstChild.style.display = 'none'; o2jse.tab.orderList[colCtrl] = tr.previousSibling.previousSibling.dataset.col; tr.dataset.col = tr.previousSibling.previousSibling.dataset.col; } tr.previousSibling.dataset.col = colSave; tr.parentNode.insertBefore(tr, tr.previousSibling); } else { if (idx == 1) { tds = tr.getElementsByTagName('td'); tds[1].firstChild.firstChild.style.display = 'block'; tds = tr.nextSibling.getElementsByTagName('td'); tds[1].firstChild.firstChild.style.display = 'none'; } else if (idx == rows - 1) { imgTag.style.display = 'none'; tds = tr.nextSibling.getElementsByTagName('td'); tds[2].firstChild.firstChild.style.display = 'block'; } tr.parentNode.insertBefore(tr.nextSibling, tr); o2jse.tab.orderList[colCtrl] = tr.nextSibling.dataset.col; tr.dataset.col = tr.nextSibling.dataset.col; tr.nextSibling.dataset.col = colSave; } }; o2jse.tab.customizeCols = function() { var jxInfo = o2jse.tab.customInfo; var cols = o2jse.menu.menuList["jxCustumTabCols"].inBox. getElementsByTagName("input"); var colsN = cols.length; var vCols = ""; for (var i = 0; i < colsN; i++) { if (cols[i].name && !cols[i].checked) { vCols+= cols[i].jxColId + ";"; } } o2jse.menu.closeAll(); var colVisField = o2jse.createInput(o2jse.infoForm, "hidden", "", vCols.substr(0, vCols.length - 1), jxInfo.c + "_jxvcol" + jxInfo.e); colVisField.o2 = jxInfo; if (o2jse.cliMode) { jxjs.request(colVisField, colVisField.value); } else { o2jse.cmd.ctrlUpd(colVisField); } o2jse.removeEl(colVisField); }; o2jse.tab.customizeSort = function() { o2jse.menu.closeAll(); var jxInfo = o2jse.tab.customInfo; var sList = o2jse.tab.sortList; var frame = o2jse.menu.menuList["jxGridSort"].inBox.getElementsByTagName("table")[0]; var cols = frame.getElementsByTagName("tr"); var resp = "array("; for(k in sList) { if(sList[k] != undefined) { var sDivs = cols[k].getElementsByTagName("div"); var sIndex = sDivs[1]; var sClass = sDivs[0].className; resp += sList[k][0] + "=>array('" + (sClass == "o2_tab_sorta" ? "A" : "D") + "','" + sList[k][1] + "'),"; } } resp = resp.substr(0, resp.length -1) + ")"; var colSortField = o2jse.createInput(o2jse.infoForm, "hidden", "", resp, jxInfo.c + "_jxscol" + jxInfo.e); colSortField.o2 = jxInfo; if (o2jse.cliMode) { jxjs.request(colSortField, resp); } else { o2jse.cmd.ctrlUpd(colSortField); } o2jse.removeEl(colSortField); }; o2jse.tab.customizeColsOrder = function() { o2jse.menu.closeAll(); var jxInfo = o2jse.tab.customInfo; var oList = o2jse.tab.orderList; var frames = o2jse.menu.menuList["jxGridOrder"].inBox.getElementsByTagName("table"); var cols = frames[0].getElementsByTagName("tr"); var resp = "array("; for(k in oList) { if(oList[k] != undefined) { resp+= "'" + k + "'=>" + oList[k] + ","; } } resp = resp.substring(0, resp.length - 1) + ')'; var colSortField = o2jse.createInput(o2jse.infoForm, "hidden", "", resp, jxInfo.c + "_jxocol" + jxInfo.e); colSortField.o2 = jxInfo; if (o2jse.cliMode) { jxjs.request(colSortField, resp); } else { o2jse.cmd.ctrlUpd(colSortField); } o2jse.removeEl(colSortField); }; o2jse.tab.resetCols = function() { o2jse.menu.closeAll(); var jxInfo = o2jse.tab.customInfo; var sizeField = o2jse.createInput(o2jse.infoForm, "hidden", "", "1", jxInfo.c + "_jxresc" + jxInfo.e); sizeField.o2 = jxInfo; if (o2jse.cliMode) { jxjs.request(sizeField, sizeField.value); } else { o2jse.cmd.ctrlUpd(sizeField); } o2jse.removeEl(sizeField); }; o2jse.tab.saveSettings = function() { o2jse.menu.closeAll(); var jxInfo = o2jse.tab.customInfo; var saveField = o2jse.createInput(o2jse.infoForm, "hidden", "", "1", jxInfo.c + "_jxsave" + jxInfo.e); saveField.o2 = jxInfo; if (o2jse.cliMode) { jxjs.request(saveField, saveField.value); } else { o2jse.cmd.ctrlUpd(saveField); } o2jse.removeEl(saveField); }; o2jse.tab.filter = function() { o2jse.menu.closeAll(); var jxInfo = o2jse.tab.customInfo; var filterField = o2jse.createInput(o2jse.infoForm, "hidden", "", "1", jxInfo.c + "_jxfltr" + jxInfo.e); filterField.o2 = jxInfo; if (o2jse.cliMode) { jxjs.request(filterField, filterField.value); } else { o2jse.cmd.ctrlUpd(filterField); } o2jse.removeEl(filterField); }; o2jse.tab.setRowsN = function() { o2jse.menu.closeAll(); var jxInfo = o2jse.tab.customInfo; var n = window.prompt("Set rows number to", jxInfo.rows); if (parseInt(n) > 0) { var rowsN = o2jse.createInput(o2jse.infoForm, "hidden", "", n, jxInfo.c + "_jxrown" + jxInfo.e); rowsN.o2 = jxInfo; if (o2jse.cliMode) { jxjs.request(rowsN, rowsN.value); } else { o2jse.cmd.ctrlUpd(rowsN); } o2jse.removeEl(rowsN); } }; o2jse.tab.exportData = function() { o2jse.menu.closeAll(); var jxInfo = o2jse.tab.customInfo; var expField = o2jse.createInput(o2jse.infoForm, "hidden", "", "1", jxInfo.c + "_jxdexp" + jxInfo.e); expField.o2 = jxInfo; if (o2jse.cliMode) { jxjs.request(expField, expField.value); } else { o2jse.cmd.ctrlUpd(expField); } o2jse.removeEl(expField); }; o2jse.tab.deleteData = function(navName) { o2jse.menu.closeAll(); msg = "ATTENTION! All filtered rows in grid will be deleted.\nProceed?"; if (o2jse.cmd.confirm(msg)) { var jxInfo = o2jse.tab.customInfo; var delField = o2jse.createInput(o2jse.infoForm, "hidden", "", navName, jxInfo.c + "_jxddel" + jxInfo.e); delField.o2 = jxInfo; if (o2jse.cliMode) { jxjs.request(delField, delField.value); } else { o2jse.cmd.ctrlUpd(delField); } o2jse.removeEl(delField); } }; o2jse.nav = { btnEffectObj : null, effectTimeout : null }; o2jse.nav.btnExe = function(targetObj) { if (targetObj !== null) { o2jse.ctrl.init(targetObj); if (o2jse.submitting && o2jse.submitCtrl) { jxjs.cachedObj = targetObj; jxjs.cachedCmd = "if(jxjs.cachedObj.style.display != 'none' && " + "jxjs.cachedObj.onclick){\n" + "o2jse.submitting=false;\n" + "o2jse.nav.btnExe(jxjs.cachedObj);}\n"; return false; } if(!targetObj.o2.msg || o2jse.cmd.confirm(targetObj.o2.msg)) { var ctrlName = targetObj.o2.c + targetObj.o2.e; o2jse.infoForm["o2_prgexeid"].value = targetObj.o2.e; o2jse.infoForm[ctrlName].value = targetObj.o2.action; targetObj.o2.msg = ""; o2jse.ctrl.make_waiting(targetObj); if (o2jse.cliMode) { jxjs.request(targetObj, targetObj.o2.action); } else { o2jse.cmd.ctrlUpd(targetObj); } } } }; o2jse.nav.onBtn = function(targetObj) { if (o2jse.nav.effectTimeout) { clearTimeout(o2jse.nav.effectTimeout); } if (o2jse.nav.btnEffectObj) { o2jse.removeEl(o2jse.nav.btnEffectObj); o2jse.nav.btnEffectObj = null; } var bigImg = document.createElement("div"); var pos = o2jse.getPos(targetObj); bigImg.style.position = "absolute"; bigImg.style.left = pos.x + "px"; bigImg.style.top = pos.y + "px"; bigImg.title = targetObj.title; bigImg.onclick = function() { bigImg.onmouseout(); targetObj.onclick(targetObj); }; bigImg.onmouseout = function() { o2jse.removeEl(bigImg); delete bigImg; }; bigImg.className = targetObj.className + " ctrl_nav_effect"; o2jse.nav.btnEffectObj = bigImg; o2jse.elBody.appendChild(o2jse.nav.btnEffectObj); }; o2jse.data = {}; o2jse.data.fa = function(s, mascheraStr) { if (s == "") { return ""; } var r = mascheraStr.match(/\s*[ULNAC]\s*\d+/gi); var l = new String(s); var t = ""; var q = ""; var p = ""; s = ""; ciclo: for (var i = 0; i < r.length; i++) { t = r[i].toUpperCase().substr(0,1); q = parseInt(r[i].substr(1)); p = l.substr(0, q); l = l.substr(q); switch(t) { case "U": s = s + p.toUpperCase(); break; case "L": s = s + p.toLowerCase(); break; case "N": c = p.match(/\D+/); if(c) { alert("Not matching picture [" + mascheraStr + "]"); s = ""; break ciclo; } else { s = s + p; } break; case "A": c = p.match(/\W+|\d+/); if(c) { alert("Not matching picture [" + mascheraStr + "]"); s = ""; break ciclo; } else { s = s + p; } break; case "C": s = s + p; break; } } return s; }; o2jse.data.fn = function(s, mascheraStr) { s = new String(s); r = mascheraStr.match(/(\D*\s*)(\d+)([\.,]?)(\d*)(\D*)/); p = r[1]; i = parseInt((r[2] || 0)); d = parseInt((r[4] || 0)); l = o2jse.decimalsPoint; t = (r[5].toLowerCase().indexOf("t") > -1 ? o2jse.thousandsPoint : ""); n = r[5].toLowerCase().indexOf("n") > -1; zOff = r[5].toLowerCase().indexOf("z") > -1; if (s == "") { s = "0"; } if (t != "") { eval("s = s.replace(/" + String.fromCharCode(92) + t + "/g, '');"); } r = s.match(/([\+\-]?)\s*(\d+)([.,]?)(\d*)/); if (r == null) { r = new Array(0); } sii = ""; if (r[1] == "-" && n) { sii = "-"; } iib = (r[2] || '0'); dd = (r[4] || '0'); ff = parseFloat(iib + "." + dd).toFixed(d); iib = String(parseInt(ff)).substr(0 - i); dd = String(ff).split(".")[1] || 0; iib = iib.substr(0 - i); ii = ""; for (var iiind = 0; iiind < iib.length; iiind++) { iichar = iib.charAt(iib.length - iiind - 1); ii = iichar + ii; if ((((iiind + 1) % 3) == 0) && (iiind < (iib.length - 1))) { ii = t + ii; } } s = p + sii + ii + (dd ? l + dd : ""); if (parseFloat(ii) == 0 && parseFloat(dd) == 0 && zOff) { s = ""; } return s; }; o2jse.data.fd = function(s, mascheraStr) { if (mascheraStr.indexOf('2') > -1) { mascheraStr = mascheraStr.replace(/2/g, ''); sy = true; } else { sy = false; } s = new String(s); var zOff = (mascheraStr.toLowerCase().indexOf('z') > -1); var l = (mascheraStr.charAt(0) || "/"); var e1 = (mascheraStr.charAt(1).toLowerCase() || ""); var e2 = (mascheraStr.charAt(2).toLowerCase() || ""); e2 = (e2 == "2" || e2 == "z" ? "" : e2); var e3 = (mascheraStr.charAt(3).toLowerCase() || ""); e3 = (e3 == "2" || e3 == "z" ? "" : e3); if ((e1 == "") && (e2 == "") && (e3 == "")) { e1 = "d"; e2 = "m"; e3 = "y"; } e = (e1 != "" ? e1 + (e2 != "" || e3 != "" ? l : "") : "") + (e2 != "" ? e2 + (e3 != "" ? l : "") : "") + e3; if (s.replace(/\D/g, "") == "") { s = (zOff ? "" : e.replace(/[dm]/g, "00").replace(/y/g, (sy ? "00" : "0000"))); } else { s = s.replace(/\D/g, ''); tc = 2; cd = -1; cm = -1; cy = -1; switch(e1) { case "d": cd = 0; break; case "m": cm = 0; break; case "y": cy = 0; tc = (sy ? 2 : 4); break; } switch(e2) { case "d": cd = tc; tc = tc + 2; break; case "m": cm = tc; tc = tc + 2; break; case "y": cy = tc; tc = tc + (sy ? 2 : 4); break; } switch(e3) { case "d": cd = tc; tc = tc + 2; break; case "m": cm = tc; tc = tc + 2; break; case "y": cy = tc; tc = tc + (sy ? 2 : 4); break; } x = new Date(); d = (s.charAt(cd) || "0") + (s.charAt(cd + 1) || "0"); if (parseInt(d, 10) == 0) { d = "01"; } m = (s.charAt(cm) || "0") + (s.charAt(cm + 1) || "0"); if (parseInt(m, 10) == 0) { m = "01"; } y = (s.charAt(cy) ? (sy || !s.charAt(cy + 3) ? '20' + (s.charAt(cy) || "0") + (s.charAt(cy + 1) || "0") : (s.charAt(cy) || "0") + (s.charAt(cy + 1) || "0") + (s.charAt(cy + 2) || "0") + (s.charAt(cy + 3) || "0")) : String(x.getFullYear())); o = new Date(y, (m - 1), d); if (o.getDate() != d || o.getMonth() != (m - 1) || o.getFullYear() != y) { msk = e.replace(/d/g, "DD"). replace(/m/g, "MM"). replace(/y/g, (sy ? "YY" : "YYYY")); alert('Not a valid date.\nMatch input mask "' + msk + '"'); s = (zOff ? "" : e.replace(/[dm]/g, "00").replace(/y/g, (sy ? "00" : "0000"))); } else { s = e.replace(/d/g, d). replace(/m/g, m). replace(/y/g, (sy ? y.charAt(2) + y.charAt(3) : y)); } } return s; }; o2jse.data.ft = function(s, mascheraStr) { s = new String(s); zOff = (mascheraStr.toLowerCase().indexOf('z') > -1); l = (mascheraStr.charAt(0)||':'); e1 = (mascheraStr.charAt(1).toLowerCase() || ""); e2 = (mascheraStr.charAt(2).toLowerCase() || ""); e2 = (e2 == "z" ? "" : e2); e3 = (mascheraStr.charAt(3).toLowerCase() || ""); e3 = (e3 == "z" ? "" : e3); if ((e1 == "") && (e2 == "") && (e3 == "")) { e1 = "h"; e2 = "m"; e3 = "s"; } e = (e1 != "" ? e1 + (e2 != "" || e3 != "" ? l : "") : "") + (e2 != "" ? e2 + (e3 != "" ? l : "") : "") + e3; if (s.replace(/\D/g, "") == "") { s = (zOff ? "" : e.replace(/[hms]/g, "00")); } else { s = s.replace(/\D/g, ""); tc = 2; ch = -1; cm = -1; cs = -1; ph = false; pm = false; ps = false; switch(e1) { case "h": ch = 0; ph = true; break; case "m": cm = 0; pm = true; break; case "s": cs = 0; ps = true; break; } switch(e2) { case "h": ch = tc; tc = tc + 2; ph = true; break; case "m": cm = tc; tc = tc + 2; pm = true; break; case "s": cs = tc; tc = tc + 2; ps = true; break; } switch(e3) { case "h": ch = tc; tc = tc + 2; ph = true; break; case "m": cm = tc; tc = tc + 2; pm = true; break; case "s": cs = tc; tc = tc + 2; ps = true; break; } h = (ph ? (s.charAt(ch) || "0") + (s.charAt(ch + 1) || "") : "00"); m = (pm ? (s.charAt(cm) || "0") + (s.charAt(cm + 1) || "") : "00"); s = (ps ? (s.charAt(cs) || "0") + (s.charAt(cs + 1) || "") : "00"); h = (h.length == 2 ? '' : "0") + h; m = (m.length == 2 ? '' : "0") + m; s = (s.length == 2 ? '' : "0") + s; o = new Date(0,0,0,h,m,s); if (o.getHours() != h || o.getMinutes() != m || o.getSeconds() != s) { m = e.replace(/h/g, "HH").replace(/m/g, "MM").replace(/s/g, "SS"); alert('Not a valid time.\nMatch input mask "' + m + '"'); s = (zOff ? "" : e.replace(/[hms]/g, "00")); } else { s = e.replace(/h/g, h).replace(/m/g, m).replace(/s/g, s); } } return s; }; o2jse.cmd = {}; o2jse.cmd.ctrlUpd = function(targetObj) { o2jse.ctrl.init(targetObj); infoObj = targetObj.o2; if (String(infoObj.msg) == "" || o2jse.cmd.confirm(infoObj.msg)) { modFields = o2jse.infoForm['o2_modfields']; if (modFields.value.indexOf(infoObj.c + ";") < 0) { modFields.value += infoObj.c + ";"; } if (infoObj.fret) { o2jse.cmd.submit(infoObj.e); } } }; o2jse.cmd.submit = function(exeId) { if (o2jse.submitting) { if (!o2jse.cliMode) { alert("Requested action not executed: data validation was needed before.\n" + "Please try again."); return true; } else { return o2jse.stopExe(); } } var lcsW = window.innerWidth; if (parseInt(lcsW) > 0) { o2jse.infoForm['jxcsw'].value = lcsW; } var lcsH = window.innerHeight; if (parseInt(lcsH) > 0) { o2jse.infoForm['jxcsh'].value = lcsH; } if (o2jse.menu.appMainMenu) { if (o2jse.menuStyle == 'T') { var lmbH = document.getElementById("jxMenuBar").offsetHeight; if (parseInt(lmbH) > 0) { o2jse.infoForm['jxmbh'].value = lmbH; } } else { var lmbW = document.getElementById("jxMenuBar").offsetWidth; if (parseInt(lmbW) > 0) { o2jse.infoForm['jxmbw'].value = lmbW; } } } if (statusBar = document.getElementById("o2status")) { o2jse.infoForm['jxsbh'].value = statusBar.offsetHeight; } o2jse.infoForm['o2_prgexeid'].value = exeId; o2jse.submitting = true; window.onunload = null; o2jse.infoForm.submit(); o2jse.infoForm['o2lastctrl'].value = ""; o2jse.infoForm['o2lastform'].value = ""; }; o2jse.cmd.post = function(targetURL, params, newWindow) { var form = document.createElement('form'); form.method = "POST"; form.enctype = o2jse.infoForm.enctype; if (targetURL) { form.action = targetURL; } else { form.action = o2jse.infoForm.action; } for (n in params) { f = document.createElement("input"); f.setAttribute("type", "hidden"); f.setAttribute("name", n); f.setAttribute("value", params[n]); form.appendChild(f); f = null; } if (newWindow) { win = 'V' + (+new Date).toString(36).slice(-5); form.target = win; window.open('', win); } document.body.appendChild(form); o2jse.submitting = true; form.submit(); document.body.removeChild(form); form = null; }; o2jse.cmd.run = function(prgName) { fields = []; fields['o2c'] = prgName; fields['JXSESSNAME'] = o2jse.sessName; if (o2jse.infoForm[o2jse.sessName]) { fields[o2jse.sessName] = o2jse.infoForm[o2jse.sessName].value; } if (arguments.length > 1) { for (var argID = 1; argID < arguments.length; argID++) { fields["extp_" + argID] = arguments[argID]; } } if (menuBar = document.getElementById("jxMenuBar")) { if (o2jse.menuStyle == 'T') { fields['jxmbh'] = menuBar.offsetHeight; } else { fields['jxmbw'] = menuBar.offsetWidth; if (o2jse.menuStyle == 'A') { radioEls = document.getElementById("jxMenuBar"). querySelectorAll('input:checked'); if (radioEls.length > 0) { for (let i = 0; i < radioEls.length; i++) { fields['jxAccMenu[' + radioEls[i].name + ']'] = radioEls[i].value; } } } } } if (statusBar = document.getElementById("o2status")) { fields['jxsbh'] = statusBar.offsetHeight; } fields['jxcsw'] = (window.innerWidth != null ? window.innerWidth : document.documentElement.clientWidth); fields['jxcsh'] = (window.innerHeight != null ? window.innerHeight : document.documentElement.clientHeight); var pathStr = ''; for (var i = 0; i < o2jse.menu.openMenus.length; i++) { if (typeof o2jse.menu.openMenus[i].label == 'undefined') { pathStr = "jxContext"; } else { pathStr+= (pathStr ? '|' : '') + o2jse.menu.openMenus[i].label; } } fields['o2p'] = pathStr; o2jse.cmd.post(false, fields); }; o2jse.cmd.exe = function(eventObj, prgID, actName) { var stdEvent = o2jse.event.std(eventObj); if (prgID > 0) { o2jse.infoForm['o2_prgexeid'].value = prgID; } o2jse.infoForm['o2_action'].value = actName; o2jse.infoForm['o2lastform'].value = (stdEvent.target && stdEvent.target.o2.f) || ""; o2jse.infoForm['o2lastctrl'].value = ""; for (var i = o2jse.infoForm.elements.length; i > 0; i--) { var field = o2jse.infoForm.elements[i - 1]; if (field.type == "hidden" && field.name.substr(0, 5) == "extp_") { o2jse.removeEl(o2jse.infoForm.elements[i - 1]); } } if (arguments.length > 3) { o2jse.extPars = []; for (var argID = 3; argID < arguments.length; argID++) { o2jse.extPars[argID - 3] = o2jse.createInput(o2jse.infoForm, "hidden", "", arguments[argID], "extp_" + (argID - 2)); } } if (!(stdEvent.target && stdEvent.target.o2.tabRow)) { stdEvent.stop(); if (o2jse.cliMode) { jxjs.request(); } else { o2jse.cmd.submit(prgID); } } if (stdEvent.target && stdEvent.target.tagName) { o2jse.ctrl.make_waiting(stdEvent.target); } }; o2jse.cmd.focus = function(ctrlName, seleMode) { if (o2jse.started) { o2jse.ctrl.focusCtrl = null; o2jse.ctrl.focusMode = null; o2jse.infoForm['o2lastctrl'].value = ""; o2jse.infoForm['o2lastform'].value = ""; var ctrlLocal = o2jse.infoForm[ctrlName] || document.getElementById(ctrlName); if (ctrlLocal && ctrlLocal.focus) { o2jse.ctrl.init(ctrlLocal); if (ctrlLocal.o2.cT == "tab") { var markName = ctrlLocal.o2.c + "_sele" + ctrlLocal.o2.e; if (o2jse.infoForm[markName]) { o2jse.infoForm[markName].focus(); } } else if (ctrlLocal.o2.cT == "listcombo") { if (o2jse.infoForm[ctrlName + "_desc"]) { ctrlLocal = o2jse.infoForm[ctrlName + "_desc"]; ctrlLocal.focus(); if (ctrlLocal.select) { ctrlLocal.select(); } } else if (ctrlLocal.o2.boxtype == "list") { document.getElementById(ctrlLocal.name).focus(); } } else if (ctrlLocal.o2.cT == "tree") { if (ctrlLocal = document.getElementById(ctrlLocal.o2.c + '_jxFocusNode')){ ctrlLocal.focus(); } } else { ctrlLocal.focus(); if (seleMode == null) { if (ctrlLocal.select) { ctrlLocal.select(); } } else if (seleMode == 0) { if (ctrlLocal.setSelectionRange) { ctrlLocal.setSelectionRange(0, 0); } ctrlLocal.scrollTop = 0; } else { if (ctrlLocal.setSelectionRange) { var len = ctrlLocal.value.length * 2; ctrlLocal.setSelectionRange(len, len); } else { ctrlLocal.value = ctrlLocal.value; } ctrlLocal.scrollTop = 999999; } } } } else { o2jse.ctrl.focusCtrl = ctrlName; o2jse.ctrl.focusMode = seleMode; } }; o2jse.cmd.getNextFocusCtrl = function(startCtrl) { var startCtrlId = startCtrl.id; var formElems = o2jse.infoForm.elements; for (i = (formElems.length - 1); i >= 0; i--) { if (formElems[i].id == startCtrlId) { var nextId = i + 1; while (!(formElems[nextId].id || formElems[nextId].name) || !formElems[nextId].focus || formElems[nextId].type == "hidden" || formElems[nextId].style.display == "none") { nextId++; } if (!formElems[nextId]) { nextId = 0; } break; } } return formElems[nextId]; }; o2jse.cmd.confirm = function(confMsg) { return confirm(confMsg); }; o2jse.cmd.startGlass = function(funcMouseMove, funcMouseUp, mouseStyle, darkOut, escable) { if (typeof mouseStyle != "string" || mouseStyle == "") { mouseStyle = "default"; } o2jse.glassObj = o2jse.createEl(o2jse.elBody, "DIV"); o2jse.glassObj.style.position = "absolute"; o2jse.glassObj.style.top = "0"; o2jse.glassObj.style.left = "0"; o2jse.glassObj.style.zIndex = 999999; o2jse.glassObj.style.cursor = mouseStyle; document.onmousemove = funcMouseMove; document.onmouseup = funcMouseUp; document.onselectstart = function() { return false; }; o2jse.glassObj.oncontextmenu = function(e) { o2jse.event.std(e).stop(); return false; }; o2jse.glassObj.style.width = "100%"; o2jse.glassObj.style.height = "100%"; if (darkOut) { o2jse.glassObj.style.backgroundColor = "#000000"; o2jse.cmd.opacity(o2jse.glassObj, 33); } else { o2jse.glassObj.style.backgroundColor = "transparent"; } if (escable) { document.onkeydown = function(e) { document.onkeydown = null; funcMouseUp(e, true); }; } }; o2jse.cmd.stopGlass = function() { if (o2jse.glassObj != null) { o2jse.removeEl(o2jse.glassObj); document.onmousemove = null; document.onmouseup = null; document.onselectstart = null; o2jse.glassObj = null; } }; o2jse.cmd.doc = function(targetObj) { o2jse.ctrl.init(targetObj); var infoObj = targetObj.o2; o2jse.createInput(o2jse.infoForm, "hidden", "", "help", "jxdocreq"); o2jse.createInput(o2jse.infoForm, "hidden", "", infoObj.e, "jxdocexeid"); o2jse.createInput(o2jse.infoForm, "hidden", "", infoObj.f, "o2_formname"); o2jse.createInput(o2jse.infoForm, "hidden", "", infoObj.c, "o2_ctrlname"); o2jse.cmd.submit(0); }; o2jse.cmd.showClock = function(darkOut) { if (!o2jse.clockObj) { o2jse.clockObj = o2jse.createEl(document.body, "DIV", "jxclock", "&nbsp;"); o2jse.cmd.startGlass(null, null, "wait", darkOut); } }; o2jse.cmd.hideClock = function() { if (o2jse.clockObj) { o2jse.removeEl(o2jse.clockObj); o2jse.clockObj = null; o2jse.cmd.stopGlass(); } }; o2jse.cmd.opacity = function(targetObj, opacity) { if (targetObj && targetObj.style) { targetObj.style.opacity = opacity / 100; } }; o2jse.cmd.playSound = function(soundFile, mimeType) { var sPlayer; sPlayer = document.createElement("audio"); if (sPlayer != null && sPlayer.canPlayType && sPlayer.canPlayType(mimeType)) { sPlayer.setAttribute("src", soundFile); sPlayer.play(); } else { if (o2jse.soundPlayer) { o2jse.removeEl(o2jse.soundPlayer); } o2jse.soundPlayer = document.createElement("embed"); if (o2jse.soundPlayer != null) { o2jse.soundPlayer.setAttribute("src", soundFile); o2jse.soundPlayer.setAttribute("type", mimeType); o2jse.soundPlayer.setAttribute("with", "0"); o2jse.soundPlayer.setAttribute("height", "0"); o2jse.soundPlayer.setAttribute("autostart", "true"); o2jse.soundPlayer.setAttribute("loop", "false"); (o2jse.elBody || document.body || document.getElementsByTagName("body")[0]). appendChild(o2jse.soundPlayer); } } }; o2jse.win = { movingWin : [], dPos : [], linkedWins : 0, winX : 0, winY : 0, showMenu : false }; o2jse.win.startMoving = function(targetObj, eventObj) { o2jse.ctrl.init(targetObj); var stdEvent = o2jse.event.std(eventObj); if (stdEvent.button != 2) { stdEvent.stop(); for(var index = targetObj.o2.subf; index >= 0; index--) { var suff = (index > 0 ? String(index) : ""); var winName = targetObj.o2.f + "_" + targetObj.o2.e + suff; if (o2jse.win.movingWin[index] = document.getElementById(winName)) { o2jse.win.dPos[index] = {x:(o2jse.win.movingWin[index].offsetLeft - stdEvent.x), y:(o2jse.win.movingWin[index].offsetTop - stdEvent.y)}; o2jse.cmd.opacity(o2jse.win.movingWin[index], 80); } else { delete o2jse.win.movingWin[index]; } } o2jse.cmd.startGlass(o2jse.win.moveTo, o2jse.win.stopMoving, "move"); } }; o2jse.win.moveTo = function(eventObj) { var menuBarH = 0; var stdEvent = o2jse.event.std(eventObj); stdEvent.stop(); if (o2jse.menu.appMainMenu && o2jse.menuStyle == 'T') { menuBarH = document.getElementById("jxMenuBar").offsetHeight; } for(var index in o2jse.win.movingWin) { var lX = (stdEvent.x + o2jse.win.dPos[index].x); var lY = Math.max(stdEvent.y + o2jse.win.dPos[index].y, menuBarH); if (o2jse.win.movingWin[index] != null) { o2jse.win.movingWin[index].style.left = lX + 'px'; o2jse.win.movingWin[index].style.top = lY + 'px'; } } }; o2jse.win.stopMoving = function(eventObj) { var stdEvent = o2jse.event.std(eventObj); stdEvent.stop(); o2jse.cmd.stopGlass(); for (var index in o2jse.win.movingWin) { o2jse.cmd.opacity(o2jse.win.movingWin[index], 100); o2jse.win.needNoRepos(o2jse.win.movingWin[index].id); } o2jse.win.savePos(o2jse.firstRealChild(o2jse.win.movingWin[0])); o2jse.win.movingWin = []; o2jse.win.dPos = []; }; o2jse.win.startSizing = function(targetObj, eventObj) { o2jse.ctrl.init(targetObj); var stdEvent = o2jse.event.std(eventObj); if (stdEvent.button != 2) { stdEvent.stop(); var winName = targetObj.o2.f + "_" + targetObj.o2.e; var winShadow = document.getElementById(winName); winShadow.className = ""; o2jse.win.movingWin[0] = o2jse.firstRealChild(winShadow); o2jse.win.movingWin[1] = document.getElementById(winName + "_in"); o2jse.win.dPos[0] = {x:(o2jse.win.movingWin[0].offsetWidth - stdEvent.x), y:(o2jse.win.movingWin[1].offsetHeight - stdEvent.y)}; o2jse.cmd.opacity(o2jse.win.movingWin[0], 80); o2jse.cmd.startGlass(o2jse.win.sizeTo, o2jse.win.stopSizing, "se-resize"); } }; o2jse.win.sizeTo = function(eventObj) { var stdEvent = o2jse.event.std(eventObj); var lX = (stdEvent.x + o2jse.win.dPos[0].x); var lY = (stdEvent.y + o2jse.win.dPos[0].y); stdEvent.stop(); o2jse.win.movingWin[0].style.width = lX + 'px'; o2jse.win.movingWin[1].style.height = lY + 'px'; }; o2jse.win.stopSizing = function(eventObj) { var stdEvent = o2jse.event.std(eventObj); stdEvent.stop(); o2jse.ctrl.init(o2jse.win.movingWin[0]); formInfo = o2jse.win.movingWin[0].o2; var refrAct = formInfo.r; o2jse.cmd.stopGlass(); o2jse.cmd.opacity(o2jse.win.movingWin[0], 100); o2jse.win.saveSize(o2jse.win.movingWin[0]); o2jse.win.movingWin[0].parentNode.className = "winshadow"; o2jse.win.movingWin = []; o2jse.win.dPos = []; var cmdField = o2jse.infoForm[formInfo.f + formInfo.e + "_jxcmd"]; cmdField.value = '3'; o2jse.infoForm['o2_modfields'].value+= cmdField.name + ";"; jxjs.refresh(formInfo, refrAct); }; o2jse.win.savePos = function(winObj) { var lmbH = 0; var lmbW = 0; if (o2jse.menu.appMainMenu && document.getElementById("jxMenuBar")) { if (o2jse.menuStyle != 'T') { var lmbW = parseInt(document.getElementById("jxMenuBar").offsetWidth); } else { var lmbH = parseInt(document.getElementById("jxMenuBar").offsetHeight); } } var objId = winObj.parentNode.id; var inWin = document.getElementById(objId + "_in"); var newStr = parseInt(winObj.parentNode.offsetLeft + winObj.offsetLeft - lmbW) + "," + parseInt(winObj.parentNode.offsetTop + winObj.offsetTop - lmbH) + ";"; var winList = o2jse.infoForm['win_list'].value.split(";"); var posList = o2jse.infoForm['win_pos'].value.split(";"); var sizeList = o2jse.infoForm['win_size'].value.split(";"); var posStr = ""; var sizeStr = ""; var toAdd = true; for (var winIndex in winList) { if (winList[winIndex] != "") { if (winList[winIndex] != objId) { posStr += posList[winIndex] + ";"; sizeStr+= sizeList[winIndex] + ";"; } else { posStr += newStr; sizeStr+= sizeList[winIndex] + ";"; toAdd = false; } } } if (toAdd) { o2jse.infoForm['win_list'].value+= objId + ";"; posStr += newStr; sizeStr += ",;"; } o2jse.infoForm['win_pos'].value = posStr; o2jse.infoForm['win_size'].value = sizeStr; }; o2jse.win.saveSize = function(winObj) { var objId = winObj.parentNode.id; var inWin = document.getElementById(objId + "_in"); var newStr = parseInt(winObj.style.width) + "," + (parseInt(inWin.offsetHeight) + 30) + ";"; var winList = o2jse.infoForm['win_list'].value.split(";"); var posList = o2jse.infoForm['win_pos'].value.split(";"); var sizeList = o2jse.infoForm['win_size'].value.split(";"); var posStr = ""; var sizeStr = ""; var toAdd = true; for (var winIndex in winList) { if (winList[winIndex] != "") { if (winList[winIndex] != objId) { posStr += posList[winIndex] + ";"; sizeStr+= sizeList[winIndex] + ";"; } else { posStr += posList[winIndex] + ";"; sizeStr+= newStr; toAdd = false; } } } if (toAdd) { o2jse.infoForm['win_list'].value+= objId + ";"; posStr += ",;"; sizeStr += newStr; } o2jse.infoForm['win_pos'].value = posStr; o2jse.infoForm['win_size'].value = sizeStr; }; o2jse.win.maxRest = function(targetObj) { o2jse.ctrl.init(targetObj); var objInfo = targetObj.o2; var winDiv = document.getElementById(objInfo.f + "_" + objInfo.e); var cmdField = o2jse.infoForm[objInfo.f + objInfo.e + "_jxcmd"]; o2jse.ctrl.init(winDiv); if (winDiv.o2.max) { o2jse.maximizedWin = false; } if (winDiv.o2.exit) { cmdField.value = "2"; o2jse.infoForm['o2_modfields'].value+= cmdField.name + ";"; o2jse.infoForm['o2lastform'].value = objInfo.f; o2jse.infoForm['o2lastctrl'].value = ""; var refrAct = winDiv.o2.r || ''; jxjs.refresh(winDiv.o2, refrAct); } }; o2jse.win.openClose = function(o2w_form, open_class, close_class) { var o2_form_in = document.getElementById(o2w_form + "_in"); var o2_form_btn = document.getElementById(o2w_form + "_btn"); if (o2_form_in.style.display == 'none') { o2_form_in.style.display = 'block'; o2_form_btn.className = close_class; } else { o2_form_in.style.display = 'none'; o2_form_btn.className = open_class; } return false; }; o2jse.win.menu = function(targetObj) { if (o2jse.win.showMenu) { o2jse.menu.closeAll(); o2jse.win.showMenu = false; return false; } o2jse.ctrl.init(targetObj); var posObj = {x: targetObj.offsetLeft, y: targetObj.offsetTop + targetObj.offsetHeight}; var cont = targetObj; while (cont = cont.parentNode) { posObj.x+= cont.offsetLeft; posObj.y+= cont.offsetTop; if (cont.hasAttribute("id")) { break; } } targetObj.onmouseout = o2jse.menu.closeByTime; o2jse.menu.addMenu("jxWinMenu", "Window"); o2jse.menu.menuList["jxWinMenu"].addItem("J", "jxWinRefresh", "Refresh", function() { o2jse.cmd.submit(targetObj.o2.e); }); o2jse.menu.menuList["jxWinMenu"].addItem("S"); o2jse.menu.menuList["jxWinMenu"].addItem("J", "jxWinMaxRes", (targetObj.o2.max ? "Restore" : "Maximize"), function() { o2jse.win.maxRest(targetObj); }); var form_in = document.getElementById(targetObj.o2.f + "_" + targetObj.o2.e + "_in"); var btn = document.getElementById(targetObj.o2.f + "_" + targetObj.o2.e + "_btn"); o2jse.menu.menuList["jxWinMenu"].addItem("J", "jxWinOpenClose", (form_in.style.display == 'none' ? "Show" : "Minimize"), btn.onclick); o2jse.menu.menuList["jxWinMenu"].addItem("S"); o2jse.menu.menuList["jxWinMenu"].addItem("J", "jxWinExit", "Exit", function() { o2jse.win.exit(targetObj); }); o2jse.menu.menuList["jxWinMenu"].show(posObj, null, targetObj); o2jse.win.showMenu = true; }; o2jse.win.exit = function(targetObj) { o2jse.ctrl.init(targetObj); var objInfo = targetObj.o2; var winDiv = document.getElementById(objInfo.f + "_" + objInfo.e); var cmdField = o2jse.infoForm[objInfo.f + objInfo.e + "_jxcmd"]; o2jse.ctrl.init(winDiv); if (winDiv.o2.exit) { o2jse.ctrl.make_waiting(targetObj); cmdField.value = "1"; o2jse.infoForm['o2_modfields'].value+= cmdField.name + ";"; o2jse.infoForm['o2lastform'].value = objInfo.f; o2jse.infoForm['o2lastctrl'].value = ""; if (o2jse.cliMode) { jxjs.request(); } else { o2jse.cmd.submit(objInfo.e); } } else if (targetObj.focus) { targetObj.focus(); } }; o2jse.win.needRepos = function(win_id) { o2jse.reposWins[o2jse.reposWins.length] = win_id; }; o2jse.win.needNoRepos = function(win_id) { for (var i = (o2jse.reposWins.length - 1); i >= 0; i--) { if (o2jse.reposWins[i] == win_id) { o2jse.reposWins.splice(i, 1); break; } } }; o2jse.win.repos = function(win_id) { var winDiv = null; if ((win_id == 'undefined') || !(winDiv = document.getElementById(win_id))) { return; } o2jse.ctrl.init(winDiv); var objInfo = winDiv.o2; var objPos = winDiv.style; var marginTop = 0; var marginLeft = 0; if (o2jse.menu.appMainMenu) { if (o2jse.menuStyle == 'T') { marginTop = (document.getElementById("jxMenuBar") ? document.getElementById("jxMenuBar").offsetHeight : 0); } else if (o2jse.menuStyle != 'H') { marginLeft = (document.getElementById("jxMenuBar") ? document.getElementById("jxMenuBar").offsetWidth : 0); } } switch (objInfo.alignH) { case "center": objPos.left = Math.max(0, parseInt((o2jse.cli.width / 2) - (objInfo.x || 0) + marginLeft / 2)) + "px"; break; case "right": objPos.right = (objInfo.x || 0) + "px"; break; default: objPos.left = Math.max(0, (objInfo.x || 0) + marginLeft) + "px"; break; } switch (objInfo.alignV) { case "middle": objPos.top = Math.max(0, parseInt((o2jse.cli.height / 2) - (objInfo.y || 0) + marginTop / 2)) + "px"; break; case "bottom": objPos.bottom = ((objInfo.y || 0) + document.getElementById("o2status").offsetHeight) + "px"; break; default: objPos.top = Math.max(0, parseInt(objInfo.y || 0) + marginTop) + "px"; break; } if (objInfo.subf) { for(var idx = objInfo.subf; idx > 0; idx--) { var subF = null; if (subF = document.getElementById(objInfo.f + "_" + objInfo.e + idx)) { o2jse.ctrl.init(subF); subF.style.left = (winDiv.offsetLeft + subF.o2.x) + "px"; subF.style.top = (winDiv.offsetTop + subF.o2.y) + "px"; } } } }; o2jse.lu = { listObj : null, reqDelay : 300, openTimer : null, closeTimer : null }; o2jse.lu.k = function(eventObj, targetObj) { var stdEvent = o2jse.event.std(eventObj); var KEY_ENTER = 13; var KEY_ESC = 27; var KEY_TAB = 9; var KEY_UP = 38; var KEY_DOWN = 40; var KEY_F1 = 112; var KEY_F12 = 123; var KEY_SHIFT = 16; var KEY_ALT = 18; var KEY_PGUP = 33; var KEY_PGDN = 34; var doMove = false; var seleItem; if (!stdEvent.ctrlKey && !stdEvent.altKey && stdEvent.keyCode != KEY_ENTER && stdEvent.keyCode != KEY_ESC && stdEvent.keyCode != KEY_TAB && (stdEvent.keyCode < KEY_PGUP || stdEvent.keyCode > KEY_DOWN) && (stdEvent.keyCode < KEY_F1 || stdEvent.keyCode > KEY_F12) && (stdEvent.keyCode < KEY_SHIFT || stdEvent.keyCode > KEY_ALT)) { o2jse.lu.list(targetObj, false, false, stdEvent); targetObj.inEdit = true; } else if (stdEvent.keyCode == KEY_UP) { if (targetObj.nodeName.toLowerCase() == "input") { if (targetObj.listObj) { stdEvent.stop(); return true; } } else { var itemsDivs = targetObj.getElementsByTagName("div"); var seleId = parseInt(targetObj.jxSeleId); var codeVal = ""; if (seleId > 0) { var cI = itemsDivs[seleId]; var nI = itemsDivs[seleId - 1]; if (cI.className.indexOf("jxlsr")) { cI.className = cI.className.substr(0, cI.className.indexOf("jxlsr")); } nI.className += " jxlsr"; codeVal = nI.id.substr(7); seleItem = nI; doMove = true; targetObj.jxSeleId = (seleId - 1); } } } else if (stdEvent.keyCode == KEY_DOWN) { if (targetObj.nodeName.toLowerCase() == "input") { if (stdEvent.altKey && !targetObj.listObj) { o2jse.lu.list(targetObj, true, true); } else if (targetObj.listObj) { targetObj.inEdit = false; var list = targetObj.listObj.childNodes[0]; list.jxSeleId = -1; var itemsDivs = list.getElementsByTagName("div"); var codeVal = ''; if (itemsDivs.length > 0) { var nI = itemsDivs[0]; nI.className += " jxlsr"; codeVal = nI.id.substr(7); seleItem = nI; doMove = true; list.jxSeleId = 0; targetObj = list; list.focus(); } stdEvent.stop(); } } else { var itemsDivs = targetObj.getElementsByTagName("div"); var seleId = parseInt(targetObj.jxSeleId); var codeVal = ""; if (seleId < (itemsDivs.length - 1)) { var cI = itemsDivs[seleId]; var nI = itemsDivs[seleId + 1]; if (seleId > -1 && cI.className.indexOf("jxlsr")) { cI.className = cI.className.substr(0, cI.className.indexOf("jxlsr")); } nI.className += " jxlsr"; codeVal = nI.id.substr(7); seleItem = nI; doMove = true; targetObj.jxSeleId = (seleId + 1); } } } else if (stdEvent.keyCode == KEY_PGUP) { if (targetObj.nodeName.toLowerCase() != "input") { var itemsDivs = targetObj.getElementsByTagName("div"); var seleId = parseInt(targetObj.jxSeleId); var codeVal = ""; var cI = itemsDivs[seleId]; var nI = itemsDivs[0]; if (seleId > -1 && cI.className.indexOf("jxlsr")) { cI.className = cI.className.substr(0, cI.className.indexOf("jxlsr")); } nI.className += " jxlsr"; codeVal = nI.id.substr(7); seleItem = nI; doMove = true; targetObj.jxSeleId = (itemsDivs.length - 1); } } else if (stdEvent.keyCode == KEY_PGDN) { if (targetObj.nodeName.toLowerCase() != "input") { var itemsDivs = targetObj.getElementsByTagName("div"); var seleId = parseInt(targetObj.jxSeleId); var codeVal = ""; var cI = itemsDivs[seleId]; var nI = itemsDivs[itemsDivs.length - 1]; if (cI.className.indexOf("jxlsr")) { cI.className = cI.className.substr(0, cI.className.indexOf("jxlsr")); } nI.className += " jxlsr"; codeVal = nI.id.substr(7); seleItem = nI; doMove = true; targetObj.jxSeleId = 0; } } else if (stdEvent.keyCode == KEY_ENTER) { if (targetObj.nodeName.toLowerCase() == "input") { if (targetObj.listObj) { var list = targetObj.listObj.childNodes[0].childNodes; if (list.length > 0) { o2jse.lu.m(eventObj, list[0]); } } targetObj.inEdit = false; } else { targetObj.descField.focus(); o2jse.lu.m(eventObj, targetObj.selectedItem, true); } } else if (stdEvent.keyCode == KEY_TAB) { if (targetObj.nodeName.toLowerCase() == "input") { if (targetObj.listObj) { var list = targetObj.listObj.childNodes[0].childNodes; if (o2jse.waitObj || targetObj.pastedValue) { targetObj.tabbedValue = targetObj.value.trim(); targetObj.listObj.style.display = 'none'; return false; } else if ((targetObj.value.trim() == '' && list[0] && list[0].innerText.trim() == '') || (list.length == 1)) { o2jse.lu.m(eventObj, list[0], true); } else if (targetObj.listObj) { o2jse.lu.e(targetObj, stdEvent); } } } else { var nF; nF = o2jse.createInput(o2jse.infoForm, "hidden", "", "1", "jxnofocus"); o2jse.submitCtrl = targetObj.o2.c + targetObj.o2.e; o2jse.lu.m(eventObj, targetObj.selectedItem); if (nF) { o2jse.removeEl(nF); } } } else if (stdEvent.keyCode == KEY_ESC) { if (targetObj.nodeName.toLowerCase() == "input") { if (targetObj.listObj) { o2jse.lu.e(targetObj, stdEvent); stdEvent.stop(); targetObj.inEdit = false; return true; } } else { o2jse.lu.e(targetObj.descField, stdEvent); stdEvent.stop(); targetObj.descField.inEdit = false; return true; } } if (doMove) { stdEvent.stop(); o2jse.ctrl.init(targetObj); targetObj.selectedItem = seleItem; var o2data = targetObj.o2; var codeField = o2jse.infoForm[o2data.c + o2data.e]; codeField.value = codeVal; codeField.o2 = o2data; o2jse.showByScroll(seleItem); return true; } return false; }; o2jse.lu.f = function(targetObj) { o2jse.ctrl.init(targetObj); var infoObj = targetObj.o2; o2jse.infoForm['o2lastform'].value = infoObj.f; o2jse.infoForm['o2lastctrl'].value = infoObj.c; if (o2jse.lu.closeTimer && (targetObj.nodeName.toLowerCase() != "input" || targetObj.listObj)) { clearTimeout(o2jse.lu.closeTimer); } if (targetObj.nodeName.toLowerCase() == "input") { if (typeof targetObj.saveValue == "undefined") { targetObj.saveValue = targetObj.value; } targetObj.tabbedValue = false; targetObj.pastedValue = false; o2jse.ctrl.focusCtrl = targetObj.name; } }; o2jse.lu.p = function(targetObj) { targetObj.inEdit = true; targetObj.pastedValue = true; setTimeout(function() { o2jse.lu.list(targetObj, false, true); }, 0); }; o2jse.lu.b = function(targetObj) { o2jse.ctrl.init(targetObj); var descField; if (targetObj.nodeName.toLowerCase() == "input") { descField = targetObj; } else { descField = targetObj.descField; } descField.pastedValue = false; if (descField.tabbedValue) { if (descField.o2.fret) { descField.inEdit = false; descField.stopForSelection = true; descField.saveValue = descField.value; descField.tabbedValue = false; codeField = o2jse.infoForm[descField.o2.c + descField.o2.e]; o2jse.lu.listOff(descField); nF = o2jse.createInput(o2jse.infoForm, 'hidden', '', '1', 'jxnofocus'); dF = o2jse.createInput(o2jse.infoForm, 'hidden', '', descField.value, descField.o2.c + descField.o2.e + '_force_decode'); if (o2jse.cliMode) { o2jse.ctrl.make_waiting(descField); jxjs.request(codeField, codeField.value); } else { o2jse.cmd.ctrlUpd(codeField); } if (nF) { o2jse.removeEl(nF); } if (dF) { o2jse.removeEl(dF); } } else { if (o2jse.lu.closeTimer) { clearTimeout(o2jse.lu.closeTimer); } o2jse.lu.listOff(descField); descField.tabbedValue = descField.value; o2jse.lu.list(descField, false, true); } } else { if (descField.listObj) { o2jse.lu.closeTimer = setTimeout(function () { o2jse.lu.listOff(descField); }, 100); } } descField.inEdit = false; }; o2jse.lu.m = function(eventObj, targetObj, notFocus) { var stdEvent = o2jse.event.std(eventObj); if (!targetObj) { targetObj = stdEvent.target; } var listObj = targetObj.parentNode; var o2data = listObj.o2; if (targetObj.value == "@luu") { if (!o2jse.waitObj) { o2jse.waitObj = o2jse.createEl(listObj, "DIV", "jx_inctrl_wait", "&nbsp;"); } o2jse.lu.exeReq(listObj.descField, 2); } else if (targetObj.value == "@lud") { if (!o2jse.waitObj) { o2jse.waitObj = o2jse.createEl(listObj, "DIV", "jx_inctrl_wait", "&nbsp;"); } o2jse.lu.exeReq(listObj.descField, 1); } else { var codeField = o2jse.infoForm[o2data.c + o2data.e]; var descField = listObj.descField; codeField.value = targetObj.value; descField.value = targetObj.innerHTML.decode().rtrim(); descField.saveValue = descField.value; descField.stopForSelection = true; descField.className = descField.className.replace(' jxerror', ''); if (typeof notFocus === 'undefined') { descField.focus(); } else { var nF; nF = o2jse.createInput(o2jse.infoForm, "hidden", "", "1", "jxnofocus"); } descField.scrollTop = 0; descField.scrollLeft = 0; o2jse.lu.listOff(descField); if (o2jse.cliMode && o2data.fret) { o2jse.ctrl.make_waiting(descField); jxjs.request(codeField, codeField.value); } else { o2jse.cmd.ctrlUpd(codeField); } if (nF) { o2jse.removeEl(nF); } } listObj.innerHTML = ""; descField.inEdit = false; }; o2jse.lu.e = function(targetObj, eventObj) { o2jse.ctrl.init(targetObj); var descElement; if (targetObj.nodeName.toLowerCase() == "input") { descElement = targetObj; o2jse.lu.listOff(descElement); descElement.value = (typeof descElement.saveValue !== "undefined" ? descElement.saveValue : ''); if (descElement.select) { descElement.select(); } } else { descElement = targetObj.descField; o2jse.lu.listOff(descElement); descElement.focus(); } descElement.name = ""; descElement.listObj = null; o2jse.lu.listObj = null; }; o2jse.lu.ck = function(targetObj, useHandler) { if (targetObj.listObj) { return o2jse.lu.listOff(targetObj); } else if (!useHandler) { if (targetObj.getAttribute("jx-dblclick") == null) { targetObj.setAttribute("jx-dblclick", 1); setTimeout(function () { if (targetObj.getAttribute("jx-dblclick") == 1) { o2jse.lu.list(targetObj, true, true); } targetObj.removeAttribute("jx-dblclick"); }, 250); } else { targetObj.removeAttribute("jx-dblclick"); } } if (targetObj.select) { targetObj.select(); } return false; }; o2jse.lu.ick = function(targetObj) { ctrlObj = o2jse.firstRealChild(targetObj.parentNode); if (ctrlObj.listObj) { return o2jse.lu.listOff(ctrlObj); } else { o2jse.lu.list(ctrlObj, true, true); } if (ctrlObj.select) { ctrlObj.select(); } return false; }; o2jse.lu.onI = function(targetObj) { var ratio = 1.2; if (o2jse.lu.effectTimeout) { clearTimeout(o2jse.lu.effectTimeout); } if (o2jse.lu.btnEffectObj) { o2jse.removeEl(o2jse.lu.btnEffectObj); o2jse.lu.btnEffectObj = null; } var bigImg = o2jse.createEl(targetObj.parentNode, 'DIV', targetObj.className); var pos = o2jse.getPos(targetObj); bigImg.style = 'transform:scale(' + ratio + ');'; bigImg.style.position = 'absolute'; bigImg.style.width = parseInt(targetObj.offsetWidth * ratio) + 'px'; bigImg.style.height = parseInt(targetObj.offsetHeight * ratio) + 'px'; bigImg.style.left = pos.x + 'px'; bigImg.style.top = pos.y + 'px'; bigImg.style.cursor = 'pointer'; bigImg.onclick = function() { bigImg.onmouseout(); targetObj.onmouseover = null; targetObj.onclick(targetObj); }; bigImg.onmouseout = function() { o2jse.removeEl(bigImg); delete bigImg; }; targetObj.onmouseout = function() { targetObj.onmouseover = function() { o2jse.lu.onI(this); }; }; o2jse.lu.btnEffectObj = bigImg; o2jse.elBody.appendChild(o2jse.lu.btnEffectObj); }; o2jse.lu.list = function(targetObj, complete, immediate, stdEvent) { o2jse.ctrl.init(targetObj); var o2data = targetObj.o2; var posLocal = o2jse.getPos(targetObj); var listElement; o2jse.infoForm['o2_prgexeid'].value = o2data.e; o2jse.infoForm['o2lastform'].value = o2data.f; o2jse.infoForm['o2lastctrl'].value = o2data.c; if (complete) { targetObj.name = ""; } else { targetObj.name = o2data.c + o2data.e + "_desc"; } if (targetObj.listObj) { targetObj.listObj.style.display = 'block'; o2jse.elBody.appendChild(targetObj.listObj); listElement = targetObj.listObj.childNodes[0]; listElement.innerHTML = ""; } else { listElement = document.createElement("DIV"); listElement.tabIndex = 0; listElement.onkeydown = function(eO) { o2jse.lu.k(eO, this); }; listElement.onfocus = function() { o2jse.lu.f(this); }; listElement.onblur = function() { o2jse.lu.b(this); }; listElement.scrollTop = 0; targetObj.listObj = o2jse.createEl(o2jse.elBody, "DIV"); targetObj.listObj.style.position = "absolute"; targetObj.listObj.appendChild(listElement); } listElement.descField = targetObj; listElement.o2 = o2data; listElement.className = o2data.cssl; listElement.style.minWidth = targetObj.offsetWidth + "px"; listElement.style.minHeight = "50px"; if (o2data.dyn) { if (!o2jse.waitObj) { o2jse.waitObj = o2jse.createEl(targetObj.listObj, "DIV", "jx_inctrl_wait", "&nbsp;"); } if (o2jse.lu.openTimer) { clearTimeout(o2jse.lu.openTimer); } if (immediate) { o2jse.lu.exeReq(targetObj); } else { o2jse.lu.openTimer = setTimeout(function() { o2jse.lu.exeReq(targetObj); }, o2jse.lu.reqDelay); } } else { if (stdEvent) { if (targetObj.selectionEnd > targetObj.selectionStart) { targetObj.value = targetObj.value.substr(0, targetObj.selectionStart) + targetObj.value.substr(targetObj.selectionEnd); } var filterValue = targetObj.value.toLowerCase(); if (stdEvent.keyCode == 8) { filterValue = filterValue.substr(0, filterValue.length - 1); } else if ((stdEvent.keyCode == 173) || (stdEvent.keyCode == 189)) { filterValue = filterValue + '_'; } else { filterValue = (filterValue + String.fromCharCode(stdEvent.keyCode) ).toLowerCase().trim(); } } var itemCode; var itemDesc; var optLocal; listElement.innerHTML = ""; for (var elementId in o2data.items) { itemCode = o2data.items[elementId][0]; itemDesc = o2data.items[elementId][1].trim(); itemDesc = (itemDesc ? itemDesc : "&nbsp;"); if (complete || !filterValue || itemDesc.toLowerCase().indexOf(filterValue) > -1) { optLocal = o2jse.createEl(listElement, "DIV", "", itemDesc); optLocal.value = itemCode; optLocal.onclick = function(e) { o2jse.lu.m(e); }; } } } targetObj.listObj.style.left = posLocal.x + "px"; if ((posLocal.y < (o2jse.cli.height - targetObj.offsetHeight - targetObj.listObj.offsetHeight)) || (posLocal.y < targetObj.listObj.offsetHeight)) { targetObj.listObj.style.top = (posLocal.y + targetObj.offsetHeight) + "px"; } else { targetObj.listObj.style.top = (posLocal.y - targetObj.listObj.offsetHeight) +"px"; } o2jse.lu.listObj = targetObj.listObj; targetObj.stopForSelection = false; }; o2jse.lu.listOff = function(descField) { if (o2jse.lu.closeTimer) { clearTimeout(o2jse.lu.closeTimer); } var targetObj; if (descField) { targetObj = descField; } else if (o2jse.lu.listObj) { targetObj = o2jse.lu.listObj.childNodes[0].descField; o2jse.lu.listObj = null; } else { return false; } if (targetObj.tabbedValue === false) { if (targetObj.listObj) { o2jse.removeEl(targetObj.listObj); } targetObj.listObj = null; o2jse.lu.listObj = null; if (descField) { descField.value = (typeof descField.saveValue !== "undefined" ? descField.saveValue : ''); } } }; o2jse.lu.exeReq = function(descField, act) { var luAct = (act == 1 ? "lunextpg" : (act == 2 ? "luprevpg" : "lulist")); if (descField.listObj) { var firedCtrl = (act == 1 || act == 2 ? descField.listObj.childNodes[0] : descField); reqBody = 'jxluact=' + luAct + '&JXSESSNAME=' + o2jse.sessName + '&o2_prgexeid=' + descField.o2.e + '&o2lastform=' + descField.o2.f + '&o2lastctrl=' + descField.o2.c + '&' + descField.name + '=' + encodeURIComponent(descField.value); firedCtrl.reqId = o2jse.requester.exe('lookup', reqBody, firedCtrl, o2jse.lu.getList, true); } }; o2jse.lu.getList = function(ctrlObj, listText, reqId) { if (o2jse.waitObj) { o2jse.removeEl(o2jse.waitObj); delete o2jse.waitObj; } if (jxjs.waitingCtrl) { jxjs.waitingCtrl.style.display = "block"; delete jxjs.waitingCtrl; } if (ctrlObj.reqId != reqId || ctrlObj.stopForSelection) { return false; } var itemsList; if (ctrlObj.listObj) { itemsList = ctrlObj.listObj.childNodes[0]; } else if (ctrlObj.descField) { itemsList = ctrlObj; } else { return false; } itemsList.style.height = null; itemsList.innerHTML = ""; itemsList.jxSeleId = -1; if (listText) { var listObjLocal = {}; var optLocal = {}; var itemTxt; eval("listObjLocal = " + listText + ";"); if (!listObjLocal.f) { optLocal = o2jse.createEl(itemsList, "DIV", "", "\u00ab"); optLocal.value = "@luu"; optLocal.onclick = function(e) { o2jse.lu.m(e); }; optLocal.className = "o2lu_sysppg"; } for (var singleItem in listObjLocal.v) { itemTxt = listObjLocal.d[singleItem].trim(); itemTxt = (itemTxt ? itemTxt : "&nbsp;"); optLocal = o2jse.createEl(itemsList, "DIV", "", itemTxt); optLocal.value = listObjLocal.v[singleItem]; optLocal.onclick = function(e) { o2jse.lu.m(e); }; } if (!listObjLocal.l) { optLocal = o2jse.createEl(itemsList, "DIV", "", "\u00bb"); optLocal.value = "@lud"; optLocal.onclick = function(e) { o2jse.lu.m(e); }; optLocal.className = "o2lu_sysnpg"; } } if (itemsList == ctrlObj) { ctrlObj.jxSeleId = -1; var itemsDivs = ctrlObj.getElementsByTagName("div"); var codeVal = ""; if (itemsDivs.length > 0) { var nI = itemsDivs[0]; nI.className += " jxlsr"; codeVal = nI.id.substr(7); seleItem = nI; ctrlObj.jxSeleId = 0; ctrlObj.focus(); } ctrlObj.selectedItem = seleItem; var o2data = ctrlObj.o2; var codeField = o2jse.infoForm[o2data.c + o2data.e]; codeField.value = codeVal; codeField.o2 = o2data; o2jse.showByScroll(seleItem); } else if (ctrlObj.tabbedValue !== false) { if ((ctrlObj.tabbedValue == '' && itemsList.childNodes.length > 0 && itemsList.childNodes[0].innerText.trim() == '') || (itemsList.childNodes.length == 1)) { ctrlObj.tabbedValue = false; o2jse.lu.m(null, itemsList.childNodes[0], true); } else { ctrlObj.tabbedValue = false; o2jse.lu.listOff(ctrlObj); } } }; o2jse.lb = {}; o2jse.lb.m = function(eventObj) { var stdEvent = o2jse.event.std(eventObj); var targetObj = stdEvent.target; if (typeof targetObj.dataset.code !== 'undefined') { var tarParent = targetObj.parentNode; var itemsDivs = tarParent.getElementsByTagName("div"); for (var i = itemsDivs.length - 1; i >= 0; i--) { itemsDivs[i].className = ""; if (itemsDivs[i].dataset.code === targetObj.dataset.code) { tarParent.jxSeleId = i; } } targetObj.className = "jxlsr"; o2jse.ctrl.init(tarParent); var o2data = targetObj.parentNode.o2; var codeField = o2jse.infoForm[o2data.c + o2data.e]; codeField.value = targetObj.dataset.code; codeField.o2 = o2data; if (o2jse.cliMode && o2data.fret) { jxjs.request(codeField, codeField.value); } else { o2jse.cmd.ctrlUpd(codeField); } } }; o2jse.lb.k = function(eventObj) { var stdEvent = o2jse.event.std(eventObj); var targetObj = stdEvent.target; var doMove = false; var seleItem; var seleId = parseInt(targetObj.jxSeleId || 0); var codeVal = ""; var itemsDivs = targetObj.getElementsByTagName("div"); if (stdEvent.keyCode == 33) { if (seleId > 0) { var cI = itemsDivs[seleId]; var pN = parseInt(targetObj.offsetHeight / cI.offsetHeight) - 1; var nI = itemsDivs[Math.max(seleId - pN, 0)]; if (cI.className.indexOf("jxlsr") !== false) { cI.className = cI.className.substr(0, cI.className.indexOf("jxlsr")); } doMove = true; targetObj.jxSeleId = Math.max(seleId - pN, 0); } } if (stdEvent.keyCode == 38) { if (seleId > 0) { var cI = itemsDivs[seleId]; var nI = itemsDivs[seleId - 1]; if (cI.className.indexOf("jxlsr") !== false) { cI.className = cI.className.substr(0, cI.className.indexOf("jxlsr")); } doMove = true; targetObj.jxSeleId = (seleId - 1); } } if (stdEvent.keyCode == 40) { if (seleId < (itemsDivs.length - 1)) { var cI = itemsDivs[seleId]; var nI = itemsDivs[seleId + 1]; if (seleId > -1 && cI.className.indexOf("jxlsr") !== false) { cI.className = cI.className.substr(0, cI.className.indexOf("jxlsr")); } doMove = true; targetObj.jxSeleId = (seleId + 1); } } if (stdEvent.keyCode == 34) { if (seleId < (itemsDivs.length - 1)) { var cI = itemsDivs[seleId]; var pN = parseInt(targetObj.offsetHeight / cI.offsetHeight) - 1; var nI = itemsDivs[Math.min(seleId + pN, itemsDivs.length - 1)]; if (seleId > -1 && cI.className.indexOf("jxlsr") !== false) { cI.className = cI.className.substr(0, cI.className.indexOf("jxlsr")); } doMove = true; targetObj.jxSeleId = Math.min(seleId + pN, itemsDivs.length - 1); } } if (doMove) { stdEvent.stop(); nI.className += " jxlsr"; codeVal = nI.dataset.code; seleItem = nI; o2jse.ctrl.init(targetObj); var o2data = targetObj.o2; var codeField = o2jse.infoForm[o2data.c + o2data.e]; codeField.value = codeVal; codeField.o2 = o2data; o2jse.lb.showByScroll(seleItem); if (o2jse.cliMode && o2data.fret) { jxjs.request(codeField, codeField.value); } else { o2jse.cmd.ctrlUpd(codeField); } } }; o2jse.lb.set = function(listCtrlId, value) { var listCtrl; if (!(listCtrl = document.getElementById(listCtrlId))) { return false; } var itemsDivs = listCtrl.getElementsByTagName("div"); for (var i = itemsDivs.length - 1; i >= 0; i--) { if (itemsDivs[i].dataset.code == value) { listCtrl.jxSeleId = i; o2jse.lb.showByScroll(itemsDivs[i]); break; } } }; o2jse.lb.showByScroll = function(item) { if (item.offsetTop < item.parentNode.scrollTop) { item.parentNode.scrollTop = item.offsetTop; } else if (item.offsetTop > (item.parentNode.scrollTop + item.parentNode.offsetHeight - item.offsetHeight)) { item.parentNode.scrollTop = item.offsetTop; } }; o2jse.fu = {}; o2jse.fu.clear = function(ctrlName) { var ctrlObj = o2jse.infoForm[ctrlName]; ctrlObj.outerHTML = ctrlObj.outerHTML; document.getElementById(ctrlName + "_int").innerHTML = ""; }; o2jse.fu.c = function(uploadCtrl) { o2jse.ctrl.init(uploadCtrl); if (uploadCtrl.o2.fret) { o2jse.cliMode = false; o2jse.ctrl.btnExe(uploadCtrl); } else { txt = ''; if (uploadCtrl.files.length > 1) { for (var n = 0; n < uploadCtrl.files.length; n++) { txt += ', ' + uploadCtrl.files[n].name; } txt = txt.substr(2); } else if (uploadCtrl.files.length == 1) { txt = uploadCtrl.files[0].name; } uploadCtrl.parentNode.parentNode.firstElementChild.innerHTML = txt; o2jse.ctrl.upLoad = true; } }; o2jse.fu.k = function(eventObj, ctrlObj) { var stdEvent = o2jse.event.std(eventObj); if (stdEvent.keyCode == 46 || stdEvent.keyCode == 8) { ctrlName = ctrlObj.name; o2jse.fu.clear(ctrlName); o2jse.infoForm[ctrlName].focus(); } }; o2jse.rte = {}; o2jse.rte.btnExe = function(editAreaID, cmdStr) { document.execCommand(cmdStr, false, null); o2jse.rte.save(editAreaID); }; o2jse.rte.b = function(targetObj) { targetObj.contenteditable = false; var objInfo = targetObj.o2; o2jse.rte.save(objInfo.c + objInfo.e); }; o2jse.rte.save = function(editAreaID) { var divObj = document.getElementById(editAreaID + "_edit"); var divText = divObj.innerHTML; var targetObj = o2jse.infoForm[editAreaID]; if (targetObj.value !== divText) { targetObj.value = divText; var objInfo = divObj.o2; if (String(objInfo.msg) == "" || o2jse.cmd.confirm(objInfo.msg)) { var modFields = o2jse.infoForm['o2_modfields']; if (modFields.value.indexOf(objInfo.c + ";") < 0) { modFields.value = objInfo.c + ";" + modFields.value; } if (objInfo.fret) { o2jse.cmd.submit(objInfo.e); } } } }; o2jse.cb = {}; o2jse.cb.c = function(targetObj, fRet) { o2jse.ctrl.init(targetObj); var o2Info = targetObj.o2; if (!targetObj.hasAttribute("name")) { var namedObj = null; if (namedObj = document.getElementsByName(o2Info.c + o2Info.e)[0]) { namedObj.removeAttribute("name"); } targetObj.name = o2Info.c + o2Info.e; } targetObj.value = (targetObj.checked ? "1" : ""); if (fRet && o2jse.cliMode) { jxjs.request(targetObj, targetObj.value); } else { targetObj.o2.fret = fRet; o2jse.cmd.ctrlUpd(targetObj); } }; o2jse.pu = { ctrlObj : null, pos : [0, 0], timer : null, outBox : null, steps : [] }; o2jse.pu.i = function(eventObj) { var stdEvent = o2jse.event.std(eventObj); o2jse.ctrl.init(stdEvent.target); if (o2jse.pu.timer) { clearTimeout(o2jse.pu.timer); } if (o2jse.submitting) { stdEvent.stop(); return; } if (stdEvent.target.o2.e != document.forms.o2form['o2_prgexeid'].value) { stdEvent.stop(); return; } if (!o2jse.pu.outBox || o2jse.pu.ctrlObj != stdEvent.target) { o2jse.pu.hide(); o2jse.pu.ctrlObj = stdEvent.target; o2jse.pu.pos = [stdEvent.x, stdEvent.y]; o2jse.pu.timer = setTimeout(o2jse.pu.show, 1000); } else { o2jse.pu.unhide(); } }; o2jse.pu.o = function() { if (o2jse.pu.timer) { clearTimeout(o2jse.pu.timer); } o2jse.pu.fadeOut(); }; o2jse.pu.show = function() { o2jse.pu.hide(); var pos = o2jse.getPos(o2jse.pu.ctrlObj); var ctrl = o2jse.pu.ctrlObj; var sele = ""; var act = ""; o2jse.ctrl.init(ctrl); o2jse.pu.outBox = o2jse.createEl(o2jse.elBody, "div", "jxpopup"); o2jse.pu.outBox.style.position = "absolute"; o2jse.pu.outBox.onmouseover = o2jse.pu.unhide; o2jse.pu.outBox.onmouseout = o2jse.pu.fadeOut; o2jse.pu.outBox.style.left = o2jse.pu.pos[0] + "px"; o2jse.pu.outBox.style.top = o2jse.pu.pos[1] + "px"; if (!o2jse.waitObj) { o2jse.waitObj = o2jse.createEl(o2jse.pu.outBox, "DIV", "jx_inctrl_wait"); o2jse.waitObj.style.top = "5px"; o2jse.waitObj.style.left = "5px"; } if (ctrl.o2.pT == "tab") { var tr = o2jse.getParentTag(ctrl, "tr"); o2jse.ctrl.init(tr); sele = "&" + tr.o2.v + "_vs" + tr.o2.e + "=" +parseInt(tr.rowIndex / tr.o2.lines); } if (ctrl.o2.puact) { act = "&o2_action" + "=" + ctrl.o2.puact; } o2jse.requester.exe("popup", "jxpuexp=" + ctrl.o2.puexp + act + sele, o2jse.pu.outBox, o2jse.pu.getCode); }; o2jse.pu.hide = function() { for (var i = o2jse.pu.steps.length - 1; i >= 0; i--) { clearTimeout(o2jse.pu.steps[i]); } o2jse.pu.steps = []; if (o2jse.pu.outBox) { o2jse.removeEl(o2jse.pu.outBox); o2jse.pu.outBox = null; o2jse.pu.pos = []; if (o2jse.waitObj) { o2jse.removeEl(o2jse.waitObj); delete o2jse.waitObj; } } }; o2jse.pu.unhide = function() { for (var i = o2jse.pu.steps.length - 1; i >= 0; i--) { clearTimeout(o2jse.pu.steps[i]); } o2jse.pu.steps = []; o2jse.pu.setOpacity(100); }; o2jse.pu.setOpacity = function(opLevel) { if (o2jse.pu.outBox) { o2jse.cmd.opacity(o2jse.pu.outBox, opLevel); } }; o2jse.pu.fadeOut = function() { var timer = 0; for (var i = 100; i >= 1; i--) { o2jse.pu.steps[i] = setTimeout("o2jse.pu.setOpacity("+i+")", timer * 7); timer++; } o2jse.pu.steps[o2jse.pu.steps.length] = setTimeout(o2jse.pu.hide, timer * 7); }; o2jse.pu.getCode = function(ctrlObj, contCode) { if (o2jse.waitObj) { o2jse.removeEl(o2jse.waitObj); delete o2jse.waitObj; } if (contCode) { ctrlObj.innerHTML = contCode; } else { o2jse.removeEl(ctrlObj); delete ctrlObj; } }; o2jse.tv = {}; o2jse.tv.c = function(target, ctrl, node) { o2jse.ctrl.init(target); var o2Info = target.o2; o2jse.infoForm['o2lastform'].value = o2Info.f; o2jse.infoForm['o2lastctrl'].value = o2Info.c; o2jse.ctrl.make_waiting(target); var treeCtrl = o2jse.createInput(o2jse.infoForm, "hidden", "", ctrl, "jxtree"); var nodeCtrl = o2jse.createInput(o2jse.infoForm, "hidden", "", node, "jxtreefold"); if (o2jse.cliMode) { jxjs.request(); } else { o2jse.cmd.submit(); } o2jse.removeEl(treeCtrl); o2jse.removeEl(nodeCtrl); }; o2jse.tv.a = function(TreeObj, node) { o2jse.ctrl.init(TreeObj); var o2Info = TreeObj.o2; if (o2Info.std) { o2jse.infoForm['o2lastform'].value = o2Info.f; o2jse.infoForm['o2lastctrl'].value = o2Info.c; var stdCtrl = o2jse.createInput(o2jse.infoForm, false, false, node, o2Info.c + o2Info.e); stdCtrl.o2 = o2Info; if (o2jse.cliMode) { jxjs.request(stdCtrl, node); o2jse.removeEl(stdCtrl); } } else { var tvFocus = o2jse.createInput(o2jse.infoForm, false, false, o2Info.c, "jxtvlastctrl"); var treeCtrl = o2jse.createInput(o2jse.infoForm, false, false, o2Info.c, "jxtree"); var nodeCtrl = o2jse.createInput(o2jse.infoForm, false, false, node, "jxtreenode"); if (o2jse.cliMode) { jxjs.request(); o2jse.removeEl(tvFocus); o2jse.removeEl(treeCtrl); o2jse.removeEl(nodeCtrl); } } if (!o2jse.cliMode) { o2jse.cmd.submit(); } }; o2jse.tv.k = function(eventObj, fromContainer) { var stdEvent = o2jse.event.std(eventObj); var KEY_ENTER = 13; var KEY_ESC = 27; var KEY_TAB = 9; var KEY_UP = 38; var KEY_DOWN = 40; var KEY_LEFT = 37; var KEY_RIGHT = 39; var KEY_F1 = 112; var KEY_F12 = 123; var KEY_SHIFT = 16; var KEY_ALT = 18; var KEY_PGUP = 33; var KEY_PGDN = 34; var targetObj = stdEvent.target; o2jse.ctrl.init(targetObj); var tvName = targetObj.o2.c; var tvRet = targetObj.o2.fret; if (fromContainer) { if (stdEvent.keyCode == KEY_DOWN || stdEvent.keyCode == KEY_RIGHT) { o2jse.tv.f(targetObj, targetObj.getElementsByTagName("div")[0]); } } else if (stdEvent.keyCode == KEY_UP) { o2jse.tv.f(targetObj.parentNode, targetObj.parentNode.previousSibling); } else if (stdEvent.keyCode == KEY_DOWN) { o2jse.tv.f(targetObj.parentNode, targetObj.parentNode.nextSibling); } else if (stdEvent.keyCode == KEY_LEFT) { cL = targetObj.parentNode.getElementsByTagName("span").length; openBtn = targetObj.previousSibling.previousSibling; if (openBtn.className == "jx_treenode_open") { var tvFocus = o2jse.createInput(o2jse.infoForm, false, false, targetObj.o2.c, "jxtvlastctrl"); openBtn.click(); o2jse.removeEl(tvFocus); } else { var upEl = targetObj.parentNode; var pL = cL; while (pL && pL >= cL) { upEl = upEl.previousSibling; pL = upEl.getElementsByTagName("span").length; } o2jse.tv.f(targetObj.parentNode, upEl); } } else if (stdEvent.keyCode == KEY_RIGHT) { cL = targetObj.parentNode.getElementsByTagName("span").length; nL = (targetObj.parentNode.nextSibling ? targetObj.parentNode.nextSibling.getElementsByTagName("span").length : 0); openBtn = targetObj.previousSibling.previousSibling; if (openBtn.className == "jx_treenode_close") { var tvFocus = o2jse.createInput(o2jse.infoForm, false, false, targetObj.o2.c, "jxtvlastctrl"); openBtn.click(); o2jse.removeEl(tvFocus); } else if ((cL == nL) || ((cL < nL) && (openBtn.className == "jx_treenode_open"))) { o2jse.tv.f(targetObj.parentNode, targetObj.parentNode.nextSibling); } } else if (stdEvent.keyCode == KEY_PGUP) { var curEl = targetObj.parentNode; var upEl = curEl; var cL = curEl.getElementsByTagName("span").length; var pL = cL; while (pL && pL == cL) { curEl = upEl; upEl = upEl.previousSibling; pL = upEl.getElementsByTagName("span").length; } o2jse.tv.f(targetObj.parentNode, curEl); } else if (stdEvent.keyCode == KEY_PGDN) { var curEl = targetObj.parentNode; var nextEl = curEl; var cL = curEl.getElementsByTagName("span").length; var nL = cL; while (nL && nL == cL) { curEl = nextEl; nextEl = nextEl.nextSibling; nL = nextEl.getElementsByTagName("span").length; } o2jse.tv.f(targetObj.parentNode, curEl); } else if (stdEvent.keyCode == KEY_ENTER) { openBtn = targetObj.previousSibling.previousSibling.className; if (targetObj.o2.aL == 1 || (targetObj.o2.aL == 2 && openBtn == "jx_treenode_leaf") || (targetObj.o2.aL == 3 && openBtn != "jx_treenode_leaf")) { targetObj.click(); } } return false; }; o2jse.tv.f = function(elementFrom, elementTo) { if (!elementTo) { return false; } if (elementFrom.className == "jx_treenode_focus") { elementFrom.className = ""; } if (elementTo.className != "jx_treenode_sele") { elementTo.className = "jx_treenode_focus"; } if (elementFrom) { divFrom = elementFrom.lastElementChild; divFrom.removeAttribute("tabindex"); delete divFrom.onkeydown; } divTo = elementTo.lastElementChild; divTo.tabIndex = 0; divTo.onkeydown = o2jse.tv.k; divTo.focus(); return false; }; o2jse.tv.initContMenu = function() { var jxInfo = o2jse.cMenu.target.o2; if (jxInfo.cT == "tree") { o2jse.tv.customInfo = jxInfo; if (o2jse.menu.menuList["jxTreeExtra"]) { o2jse.menu.menuList["jxTreeExtra"].clear(); } o2jse.cMenu.addItem("M", "jxTreeExtra", "Treeview", "", o2jse.rntAlias + "img/tree/tree.png"); o2jse.menu.menuList["jxTreeExtra"].addItem("J", "jxTreeFold", "Fold all", o2jse.tv.foldAll, o2jse.rntAlias + "img/tree/fold.png"); o2jse.menu.menuList["jxTreeExtra"].addItem("J", "jxTreeUnfold", "Unfold all", o2jse.tv.unfoldAll, o2jse.rntAlias +"img/tree/unfold.png"); o2jse.menu.menuList["jxTreeExtra"].addItem("S"); o2jse.menu.menuList["jxTreeExtra"].addItem("J", "jxTreeExport", "Export structure", o2jse.tv.exportStructure, o2jse.rntAlias +"img/tree/export.png"); return true; } else { return false; } }; o2jse.tv.foldAll = function() { o2jse.menu.closeAll(); var jxInfo = o2jse.tv.customInfo; var treeCtrl = o2jse.createInput(o2jse.infoForm, "hidden", "", jxInfo.c, "jxtree"); var foldAll = o2jse.createInput(o2jse.infoForm, "hidden", "", "1", "jxtreefoldall"); if (o2jse.cliMode) { jxjs.request(); } else { o2jse.cmd.submit(); } o2jse.removeEl(treeCtrl); o2jse.removeEl(foldAll); }; o2jse.tv.unfoldAll = function() { o2jse.menu.closeAll(); var jxInfo = o2jse.tv.customInfo; var treeCtrl = o2jse.createInput(o2jse.infoForm, "hidden", "", jxInfo.c, "jxtree"); var unfoldAll = o2jse.createInput(o2jse.infoForm, "hidden", "", "1", "jxtreeunfoldall"); if (o2jse.cliMode) { jxjs.request(); } else { o2jse.cmd.submit(); } o2jse.removeEl(treeCtrl); o2jse.removeEl(unfoldAll); }; o2jse.tv.exportStructure = function() { o2jse.menu.closeAll(); var jxInfo = o2jse.tv.customInfo; var treeCtrl = o2jse.createInput(o2jse.infoForm, "hidden", "", jxInfo.c, "jxtree"); var exportCtrl = o2jse.createInput(o2jse.infoForm, "hidden", "", "1", "jxtreeexport"); if (o2jse.cliMode) { jxjs.request(); } else { o2jse.cmd.submit(); } o2jse.removeEl(treeCtrl); o2jse.removeEl(exportCtrl); }; o2jse.tv.sortSwitch = function() { o2jse.menu.closeAll(); var jxInfo = o2jse.tv.customInfo; var treeCtrl = o2jse.createInput(o2jse.infoForm, "hidden", "", jxInfo.c, "jxtree"); var sortCtrl = o2jse.createInput(o2jse.infoForm, "hidden", "", "1", "jxtreesort"); if (o2jse.cliMode) { jxjs.request(); } else { o2jse.cmd.submit(); } o2jse.removeEl(treeCtrl); o2jse.removeEl(sortCtrl); }; o2jse.tv.set = function(tvName, vertScroll) { if (tvCtrl = document.getElementById(tvName)) { o2jse.ctrl.init(tvCtrl); if (!tvCtrl.o2.std) { tvCtrl.parentNode.onscroll = function() { o2jse.lu.listOff(); document.forms. o2form[tvName + '_vscroll'].value = this.scrollTop; }; tvCtrl.parentNode.scrollTop = vertScroll; } else { tvCtrl.scrollTop = vertScroll; } } }; o2jse.il = {}; o2jse.il.c = function(imglistObj, item) { o2jse.ctrl.init(imglistObj); var o2Info = imglistObj.o2; if (o2Info.std) { o2jse.infoForm['o2lastform'].value = o2Info.f; o2jse.infoForm['o2lastctrl'].value = o2Info.c; var stdCtrl = o2jse.createInput(o2jse.infoForm, false, false, item, o2Info.c + o2Info.e); stdCtrl.o2 = o2Info; if (o2jse.cliMode) { jxjs.request(stdCtrl, item); o2jse.removeEl(stdCtrl); } } else { var listerCtrl = o2jse.createInput(o2jse.infoForm, "hidden", "", o2Info.c, "jximglist"); var itemCtrl = o2jse.createInput(o2jse.infoForm, "hidden", "", item, "jximglistitem"); if (o2jse.cliMode) { jxjs.request(); o2jse.removeEl(listerCtrl); o2jse.removeEl(itemCtrl); } } if (!o2jse.cliMode) { o2jse.cmd.submit(); } }; o2jse.il.d = function(imglistObj, item) { o2jse.ctrl.init(imglistObj); var o2Info = imglistObj.o2; if (o2Info.std) { o2jse.infoForm['o2lastform'].value = o2Info.f; o2jse.infoForm['o2lastctrl'].value = o2Info.c; var stdCtrl = o2jse.createInput(o2jse.infoForm, false, false, item, o2Info.c + o2Info.e); var delCtrl = o2jse.createInput(o2jse.infoForm, false, false, '1', o2Info.c + o2Info.e + '_delete'); stdCtrl.o2 = o2Info; if (o2jse.cliMode) { jxjs.request(stdCtrl, item); o2jse.removeEl(stdCtrl); o2jse.removeEl(delCtrl); } } else { var listerCtrl = o2jse.createInput(o2jse.infoForm, "hidden", "", ctrl, "jximglist"); var itemCtrl = o2jse.createInput(o2jse.infoForm, "hidden", "", item, "jximglistdelete"); if (o2jse.cliMode) { jxjs.request(); o2jse.removeEl(listerCtrl); o2jse.removeEl(itemCtrl); } } if (!o2jse.cliMode) { o2jse.cmd.submit(); } }; o2jse.il.set = function(ilName, vertScroll) { document.getElementById(ilName).scrollTop = vertScroll; }; o2jse.fastMsg = { frameObj : null, msgWin : [], closeBtn : [] }; o2jse.fastMsg.frame = function() { if (!o2jse.fastMsg.frameObj) { o2jse.fastMsg.frameObj = o2jse.createEl(document.body, "div", "jxfastmsgframe"); o2jse.fastMsg.frameObj.style.position = "absolute"; } return o2jse.fastMsg.frameObj; }; o2jse.fastMsg.show = function(msgCode) { var winId = 0; do { winId = (new Date).getMilliseconds(); } while (winId in o2jse.fastMsg.msgWin); var msgDiv = o2jse.createEl(o2jse.fastMsg.frame(), 'div', 'jxfastmsg'); msgDiv.innerHTML = msgCode; var closeBtn = o2jse.createEl(msgDiv, 'div', 'jxfastmsg_close', '<img src="' + o2jse.rntAlias + 'img/close.png">'); msgDiv.style.position = "relative"; msgDiv.onmouseover = function() { closeBtn.style.display = 'block'; o2jse.fastMsg.unhide(winId); }; msgDiv.onmouseout = function() { closeBtn.style.display = 'none'; msgDiv.steps = []; msgDiv.steps[0] = setTimeout("o2jse.fastMsg.fadeOut(" + winId + ")", o2jse.fastMsgTime * 1000); }; msgDiv.steps = []; msgDiv.steps[0] = setTimeout("o2jse.fastMsg.fadeOut(" + winId + ")", o2jse.fastMsgTime * 1000); closeBtn.style.display = 'none'; closeBtn.onclick = function() { o2jse.fastMsg.hide(winId); }; o2jse.fastMsg.msgWin[winId] = msgDiv; o2jse.fastMsg.closeBtn[winId] = closeBtn; }; o2jse.fastMsg.hide = function(winId) { for (var i = o2jse.fastMsg.msgWin[winId].steps.length - 1; i >= 0; i--) { clearTimeout(o2jse.fastMsg.msgWin[winId].steps[i]); } o2jse.fastMsg.msgWin[winId].steps = []; if (o2jse.fastMsg.msgWin[winId]) { o2jse.removeEl(o2jse.fastMsg.msgWin[winId]); delete o2jse.fastMsg.msgWin[winId]; o2jse.removeEl(o2jse.fastMsg.closeBtn[winId]); delete o2jse.fastMsg.closeBtn[winId]; } }; o2jse.fastMsg.unhide = function(winId) { for (var i = o2jse.fastMsg.msgWin[winId].steps.length - 1; i >= 0; i--) { clearTimeout(o2jse.fastMsg.msgWin[winId].steps[i]); } o2jse.fastMsg.msgWin[winId].steps = []; o2jse.fastMsg.setOpacity(winId, 100); }; o2jse.fastMsg.setOpacity = function(winId, opLevel) { if (o2jse.fastMsg.msgWin[winId]) { o2jse.cmd.opacity(o2jse.fastMsg.msgWin[winId], opLevel); } }; o2jse.fastMsg.fadeOut = function(winId) { var timer = 0; for (var i = 100; i >= 1; i--) { o2jse.fastMsg.msgWin[winId].steps[i] = setTimeout("o2jse.fastMsg.setOpacity(" + winId + ", " + i + ")", timer * 7); timer++; } o2jse.fastMsg.msgWin[winId].steps[o2jse.fastMsg.msgWin[winId].steps.length] = setTimeout("o2jse.fastMsg.hide(" + winId + ")", timer * 7); }; o2jse.reportMsg = {}; o2jse.reportMsg.show = function(msgCode) { if (oldWin = document.getElementById('jxReportOkWin')) { o2jse.cmd.stopGlass(); o2jse.removeEl(oldWin); } o2jse.cmd.startGlass(null, null, 'not-allowed', true); reportObj = o2jse.createEl(o2jse.elBody, 'DIV', 'jxreportmsg_frame'); reportObj.id = 'jxReportOkWin'; reportObj.style.zIndex = 9999999; reportTitle = o2jse.createEl(reportObj, 'DIV', 'o2_form_titlebar', '<div class="sys_alert_doc">&nbsp;</div>'); reportView = o2jse.createEl(reportObj, 'DIV', 'jxreportview'); reportText = o2jse.createEl(reportView, 'DIV', 'jxreportmsg', msgCode); reportCmd = o2jse.createEl(reportObj, 'DIV', 'jxreportmsg_cmd'); reportOk = o2jse.createEl(reportCmd, 'DIV', 'o2_ctrl_button', 'Ok'); reportOk.id = 'jxReportOkBtn'; reportOk.onkeydown = function (e) { e = o2jse.event.std(e); if(e.keyCode == 32 || e.keyCode == 13) { reportOk.click() }; }; reportOk.onclick = function() { o2jse.cmd.stopGlass(); o2jse.removeEl(reportObj); }; reportOk.tabIndex = '0'; o2jse.cmd.focus(reportOk.id); }; o2jse.notify = { notifyWin : null, winOpen : false, itemsList : [], timeOut : null }; o2jse.notify.clickOnIcon = function() { if (o2jse.notify.winOpen) { o2jse.notify.hideWin(); } else { o2jse.notify.exeReq(); o2jse.ctrl.make_waiting(document.getElementById("jxnotify")); o2jse.notify.createWin(); } }; o2jse.notify.createWin = function() { var iList = document.createElement("TABLE"); iList.className = "o2notify_list"; var empty = true; for (var l in o2jse.notify.itemsList) { item = o2jse.notify.itemsList[l]; iRow = o2jse.createEl(iList, "TR", "o2notify_row" + (item[3] ? "_on" : "_off")); body = o2jse.textDecode(item[1]); iRow.title = (body.length > 100 ? body.substr(0, 94) + "[...]" : body); iRow.jxMsgID = l; iRow.jxMsgAct = (item[3] ? true : false); iRow.onclick = function() { o2jse.notify.clickOnDispatch(this); }; iImgTd = o2jse.createEl(iRow, "TD", "o2notify_img"); iImg = o2jse.createEl(iImgTd, "IMG"); if (item[2]) { iImg.src = item[2]; } else { iImg.src = o2jse.rntAlias + "img/notify/msg.png"; } iTxt = o2jse.createEl(iRow, "TD", "", item[0]); empty = false } if (empty) { iList = document.createElement("DIV"); iList.innerHTML = "<div style='margin:10px;font-style:italic;'>No messages</div>"; } o2jse.notify.notifyWin = o2jse.createEl(document.body, "div", "o2notify_win"); o2jse.notify.notifyWin.appendChild(iList); o2jse.notify.winOpen = true; }; o2jse.notify.hideWin = function() { if (o2jse.notify.winOpen) { if (o2jse.notify.notifyWin) { o2jse.removeEl(o2jse.notify.notifyWin); delete o2jse.notify.notifyWin; } o2jse.notify.winOpen = false; } }; o2jse.notify.exeReq = function() { o2jse.requester.exe('notify', 'JXSESSNAME=' + o2jse.sessName, o2jse.notify, o2jse.notify.getList, true); }; o2jse.notify.getList = function(nullObj, listText) { listText+= "if (o2jse.notify.winOpen) { " + "o2jse.notify.hideWin();" + "o2jse.notify.createWin(); }"; o2jse.exeCode(listText); var unread = 0; for (var l in o2jse.notify.itemsList) { if (!o2jse.notify.itemsList[l][4]) { unread++; } } var notifyArea = document.getElementById("jxnotify"); if (o2jse.waitObj) { o2jse.removeEl(o2jse.waitObj); delete o2jse.waitObj; } notifyArea.style.display = "block"; notifyArea.title = (unread ? "You have " + unread + " unread messages" : "No messages"); notifyArea.getElementsByTagName("IMG")[0].src = o2jse.rntAlias + "img/notify/" + (unread ? "msg.png" : "empty.png"); notifyArea.getElementsByTagName("DIV")[0].innerHTML = (unread ? unread : ""); if (o2jse.notify.timeOut) { clearTimeout(o2jse.notify.timeOut); o2jse.notify.timeOut = null; } o2jse.notify.timeOut = setTimeout(o2jse.notify.exeReq, o2jse.refreshTime); o2jse.notify.inRequest = false; }; o2jse.notify.clickOnDispatch = function(trObj) { if (trObj.jxMsgAct) { var fields = []; fields['JXSESSNAME'] = o2jse.sessName; if (o2jse.infoForm[o2jse.sessName]) { fields[o2jse.sessName] = o2jse.infoForm[o2jse.sessName].value; } fields['jxact'] = 'dispatch'; fields['jxmsgid'] = trObj.jxMsgID; o2jse.cmd.post(false, fields); } else { o2jse.removeEl(trObj); o2jse.requester.exe("remdispatch", "jxmsgid=" + trObj.jxMsgID, o2jse.notify, null); var notifyArea = document.getElementById("jxnotify"); var notifyText = notifyArea.getElementsByTagName("DIV")[0]; var unread = parseInt(notifyText.innerHTML) - 1; notifyArea.title = (unread ? "You have " + unread + " unread messages" : "No messages"); notifyArea.getElementsByTagName("IMG")[0].src = o2jse.rntAlias + "img/notify/" + (unread ? "msg.png" : "empty.png"); notifyText.innerHTML = (unread ? unread : ""); } }; o2jse.progress = { active : false, timeOut : null }; o2jse.progress.set = function(barID, barProgress) { var barEl = document.getElementById(barID); var barElEls; if (barEl) { barElEls = barEl.getElementsByTagName("DIV"); barElEls[0].style.width = barProgress + "%"; barElEls[1].innerHTML = barProgress + "%"; } }; o2jse.progress.start = function() { o2jse.progress.active = true; }; o2jse.progress.stop = function() { o2jse.progress.active = false; }; o2jse.progress.getCode = function(reqObj, reqJs) { o2jse.exeCode(reqJs); if (o2jse.progress.active && !o2jse.progress.timeOut) { o2jse.progress.timeOut = setTimeout(function() { delete o2jse.progress.timeOut; o2jse.requester.exe('progress', 'JXSESSNAME=' + o2jse.sessName, o2jse.progress, o2jse.progress.getCode, true); }, 3000); } }; var jxjs = { reqId : 0, resId : 0, scriptsList : [], waitingCtrl : null, dbg_ctrl : null, respTimeOut : null, cachedCmd : '', cachedObj : null, cachedEvent : null, extPars : [] }; jxjs.request = function(reqObj, reqValue, refrAct) { if (reqObj) { o2jse.ctrl.init(reqObj); var o2Info = reqObj.o2; o2jse.infoForm['o2_prgexeid'].value = o2Info.e; if (o2Info.cT != "button") { if (o2jse.infoForm['o2_modfields'].value.indexOf(o2Info.c + ";") < 0) { o2jse.infoForm['o2_modfields'].value += o2Info.c + ";"; } o2jse.infoForm[o2Info.c + o2Info.e].value = reqValue; } } var lcsW = window.innerWidth; var lcsH = window.innerHeight; if (o2jse.menu.appMainMenu) { if (o2jse.menuStyle == 'T') { var lmbH = document.getElementById('jxMenuBar').offsetHeight; if (parseInt(lmbH) > 0) { o2jse.infoForm['jxmbh'].value = lmbH; } } else { var lmbW = document.getElementById('jxMenuBar').offsetWidth; if (parseInt(lmbW) > 0) { o2jse.infoForm['jxmbw'].value = lmbW; } } } if (statusBar = document.getElementById("o2status")) { o2jse.infoForm['jxsbh'].value = statusBar.offsetHeight; } if (parseInt(lcsW) > 0) { o2jse.infoForm['jxcsw'].value = lcsW; } if (parseInt(lcsH) > 0) { o2jse.infoForm['jxcsh'].value = lcsH; } if (o2jse.ctrl.upLoad) { return o2jse.cmd.submit(reqObj ? o2Info.e : 0); } this.reqId = new Date().getTime(); if (!jxjs.respTimeOut) { jxjs.respTimeOut = setTimeout(jxjs.onLateResp, (o2jse.maxMultiReq * 500)); } o2jse.submitting = true; if (refrAct) { o2jse.infoForm['o2_action'].value = (refrAct == true ? "" : refrAct); o2jse.requester.exe('refresh', 'jxjsid=' + this.reqId, jxjs, jxjs.jsEval); } else { o2jse.requester.exe('pagepost', 'jxjsid=' + this.reqId, jxjs, jxjs.jsEval); } o2jse.infoForm['o2_modfields'].value = ""; o2jse.infoForm['o2_action'].value = ""; o2jse.infoForm['o2lastctrl'].value = ""; o2jse.infoForm['o2lastform'].value = ""; o2jse.infoForm['win_list'].value = ""; o2jse.infoForm['win_pos'].value = ""; o2jse.infoForm['win_size'].value = ""; if (o2jse.extPars) { for (var i = o2jse.extPars.length - 1; i >= 0; i--) { o2jse.removeEl(o2jse.extPars[i]); } o2jse.extPars = []; } }; jxjs.refresh = function(formInfo, refrAct) { if (formInfo) { if (o2jse.infoForm['o2lastform'].value != formInfo.f) { o2jse.infoForm['o2lastctrl'].value = ''; } o2jse.infoForm['o2lastform'].value = formInfo.f; } if (!refrAct) { refrAct = true; } jxjs.request(null, null, refrAct); }; jxjs.onLateResp = function() { o2jse.cmd.showClock(true); }; jxjs.jsEval = function(reqObj, reqJs) { if (o2jse.waitObj) { o2jse.removeEl(o2jse.waitObj); delete o2jse.waitObj; } if (jxjs.waitingCtrl) { jxjs.waitingCtrl.style.display = "block"; delete jxjs.waitingCtrl; } o2jse.started = false; o2jse.exeCode(reqJs + jxjs.cachedCmd); jxjs.cachedCmd = ''; jxjs.cachedObj = null; jxjs.cachedEvent = null; if (jxjs.scriptsList.length) { var scriptList = ""; for (scriptID in jxjs.scriptsList) { if (jxjs.scriptsList[scriptID].trim() != "") { scriptList+= jxjs.scriptsList[scriptID] + "\n"; } } jxjs.scriptsList = []; jxjs.dbg_ctrl = "Embedded script"; o2jse.exeCode(scriptList); } o2jse.init(); }; jxjs.beacon = function(jxact, params) { var fd = new FormData(); fd.append('JXSESSNAME', o2jse.sessName); fd.append('jxact', jxact); if (params && Object.keys(params).length) { Object.keys(params).forEach(function(k) { fd.append(k, params[k]); }); } navigator.sendBeacon(o2jse.rntAlias + 'jxr.php', fd); delete(fd); }; jxjs.runScripts = function(container) { var codes = container.getElementsByTagName("SCRIPT"); if (codes.length) { for (var codeID = codes.length - 1; codeID >= 0; codeID--) { jxjs.scriptsList[jxjs.scriptsList.length] = codes[codeID].innerHTML; } } }; jxjs.cError = function(ex, reqJs){ if (jxjs.respTimeOut) { clearTimeout(jxjs.respTimeOut); jxjs.respTimeOut = null; } if (o2jse.devName) { jsErr = "<div id='jxjsErr' style='position:relative;z-index:9998;'>\n" + "<table class='o2_error_report'>\n" + "<tr><td COLSPAN='2'><table>\n" + "<tr>\n<td class='o2_error_title'><center>" + "<b>AJAX REQUEST FAILURE</b></center></td>\n" + "<td class='o2_error_close' onclick='jxjsErr.style.display=\"none\";'" + " title='Close error message'>X</td></tr></table>\n</tr>\n" + "<tr><td COLSPAN='2' class='o2_error_text'>" + ex.name + "</td></tr>\n<tr><td class='o2_error_info'><i>Description:</i></td>" + "<td class='o2_error_info'>" + ex.message + "</td></tr>\n<tr><td class='o2_error_info'><i>Line:</i></td>" + "<td class='o2_error_info'>" + (ex.lineNumber + 1) + "</td></tr>\n<tr><td class='o2_error_info'><i>Request state:</i>" + "</td><td class='o2_error_info'>" + jxjs.dbg_ctrl + "</td></tr>\n<tr>\n<td COLSPAN='2' class='o2_error_info'><pre>" + reqJs + "</pre></td>\n</tr>\n</table></div>\n"; document.body.innerHTML = jsErr + document.body.innerHTML; } document.getElementById("o2statustext").innerHTML = "<b>Error in response</b>"; o2jse.submitting = false; o2jse.cliMode = false; }; jxi = function(resId) { var yorn = (resId > jxjs.resId); if (yorn) { if (jxjs.respTimeOut) { clearTimeout(jxjs.respTimeOut); jxjs.respTimeOut = null; } jxjs.resId = resId; } else { o2jse.infoForm['o2_modfields'].value = ''; o2jse.infoForm['o2_action'].value = ''; o2jse.infoForm['o2lastform'].value = ''; o2jse.infoForm['o2lastctrl'].value = ''; o2jse.reposWins = []; jxjs.scriptsList = []; o2jse.cmd.submit(); } return yorn; }; jxc = function(defObj) { var ctrlObj; var modFields = o2jse.infoForm["o2_modfields"]; jxjs.dbg_ctrl = "Processing " + defObj.i + " (" + defObj.t + ")"; if (defObj.t == "win") { if (defObj.v) { if (defObj.code) { if (ctrlObj = document.getElementById(defObj.i)) { ctrlObj.outerHTML = defObj.code; jxjs.runScripts(ctrlObj); } else { contDiv = o2jse.createEl(document.getElementById("jxjsinsert"), "div"); contDiv.innerHTML = defObj.code; contDiv.jxDynamic = true; jxjs.runScripts(contDiv); } } if (defObj.title && (ctrlObj = document.getElementById(defObj.i + "_title"))){ if (ctrlObj.innerHTML != defObj.title) { ctrlObj.innerHTML = defObj.title; } } ctrlObj = document.getElementById(defObj.i); if ((typeof(defObj.x) != 'undefined') && parseInt(ctrlObj.offsetLeft) != defObj.x) { ctrlObj.style.left = defObj.x + "px"; } if ((typeof(defObj.y) != 'undefined') && parseInt(ctrlObj.offsetTop) != defObj.y) { ctrlObj.style.top = defObj.y + "px"; } ctrlObj = document.getElementById(defObj.i).getElementsByTagName("div")[0]; if (parseInt(ctrlObj.offsetWidth) != defObj.w) { ctrlObj.style.width = defObj.w + "px"; } ctrlObj = document.getElementById(defObj.i + "_in"); if (parseInt(ctrlObj.offsetHeight) != defObj.h) { ctrlObj.style.height = defObj.h + "px"; } } else { var winDiv = document.getElementById(defObj.i); if (winDiv) { if (winDiv.parentNode.jxDynamic) { o2jse.removeEl(winDiv.parentNode); } else { o2jse.removeEl(winDiv); } o2jse.win.needNoRepos(defObj.i); } } jxjs.dbg_ctrl = "Processed " + defObj.i + " (win)"; } else if (defObj.t == "multipage") { if (ctrlObj = document.getElementById(defObj.i + "_out")) { if (defObj.v) { ctrlObj.style.display = ""; ctrlObj.style.width = defObj.w + 'px'; ctrlObj.style.height = defObj.h + 'px'; ctrlObj.parentNode.style.left = defObj.x + 'px'; ctrlObj.parentNode.style.top = defObj.y + 'px'; if (defObj.select) { o2jse.infoForm[defObj.i].value = defObj.d; var mpPages = ctrlObj.childNodes; for (var pageNum = mpPages.length - 1; pageNum >= 0; pageNum--) { var mpBtn; if (mpBtn = document. getElementById(defObj.i + "_mpb" + pageNum)) { o2jse.ctrl.init(mpBtn); if (pageNum == defObj.d) { mpBtn.className = defObj.cssOn; mpBtn.tabIndex = "-1"; mpBtn.onclick = null; } else { mpBtn.className = defObj.cssOff; mpBtn.tabIndex = "0"; mpBtn.onclick = function() { o2jse.ctrl.multiPage(this); }; } } var mpPage = mpPages[pageNum]; if (mpPage.tagName && mpPage.tagName.toLowerCase() == "div") { if (mpPage.id == defObj.i + "_p" + defObj.d) { mpPage.style.display = ""; if (defObj.code) { mpPage.innerHTML = defObj.code; jxjs.runScripts(mpPage); } } else if (mpPage.id.substr(0, defObj.i.length + 2) == defObj.i + "_p") { mpPage.style.display = "none"; } } } } else if (defObj.code) { var objDivOpen = document.getElementById(defObj.i + "_p" + defObj.d); objDivOpen.innerHTML = defObj.code; jxjs.runScripts(objDivOpen); } } else { ctrlObj.style.display = "none"; } jxjs.dbg_ctrl = "Processed " + defObj.i + " (multipage)"; } else { jxjs.dbg_ctrl = "Missing " + defObj.i + " (multipage)"; } } else if (defObj.t == "tab") { var tabObj = document.getElementById(defObj.i); var tabCont = tabObj.parentNode; if (defObj.v) { tabCont.style.display = ""; tabObj.style.width = defObj.w + 'px'; tabObj.style.height = defObj.h + 'px'; tabCont.style.left = defObj.x + 'px'; tabCont.style.top = defObj.y + 'px'; if (defObj.code) { if (tabCont.innerHTML != defObj.code) { tabCont.innerHTML = defObj.code; jxjs.runScripts(tabCont); } } else if (defObj.rowList) { var tRows = document.getElementById(defObj.i + "_tab"). getElementsByTagName("tbody")[0].rows; var rowNum = defObj.lastRow; var lastRow = tRows[rowNum]; if (defObj.foot && (pseudoF = document.getElementById(defObj.i + '_pseudoF'))) { var myFoot = pseudoF.getElementsByTagName('tfoot')[0]. getElementsByTagName('tr'); } for (var cellId in defObj.rowList) { var valObj = null; var newCell = defObj.rowList[cellId]; var oldCell = tRows[rowNum + newCell.r].cells[newCell.c]; if (typeof oldCell != "undefined") { if (valObj = oldCell.getElementsByTagName("div")[0]) { valObj.innerHTML = (newCell.v != "" ? newCell.v : "&nbsp;"); if (valObj.className && valObj.className != newCell.t) { valObj.className = newCell.t; } } else if (valObj = oldCell.getElementsByTagName("input")[0]) { valObj.checked = (newCell.v == "1"); valObj.value = newCell.v; if (valObj.className && valObj.className != newCell.t) { valObj.className = newCell.t; } } else if (valObj = oldCell.getElementsByTagName("img")[0]) { valObj.src = newCell.v; } if (oldCell.className != newCell.s) { oldCell.className = newCell.s; } var tdObj = valObj.parentNode; tdObj.onmouseover = null; tdObj.onmouseout = null; } } if (myFoot) { for (var footC in defObj.foot) { myFootC = defObj.foot[footC]; myFoot[myFootC.r].getElementsByTagName('td')[myFootC.c]. innerText = myFootC.l; } } lastRow.o2 = defObj.rowprop; if (lastRow.className != defObj.rowprop.cssc) { lastRow.className = defObj.rowprop.cssc; } } if (defObj.hs) { sE = document.getElementById(defObj.i + '_tab').parentNode; sE.scrollLeft = defObj.hs; } if (defObj.vs) { sE = document.getElementById(defObj.i + '_tab').parentNode; sE.scrollTop = defObj.vs; } } else { tabCont.style.display = "none"; } } else if (defObj.t == "doc") { var docFrame = document.getElementById(defObj.i); if (defObj.v) { docFrame.style.display = ""; docFrame.style.width = defObj.w + 'px'; docFrame.style.height = defObj.h + 'px'; docFrame.parentNode.style.left = defObj.x + 'px'; docFrame.parentNode.style.top = defObj.y + 'px'; if (defObj.u) { docFrame.src = defObj.u; } } else { docFrame.style.display = "none"; } } else { if (defObj.r && defObj.t != "listcombo" && o2jse.infoForm[defObj.i]) { if (!(ctrlObj = o2jse.infoForm[defObj.i][defObj.r - 1])) { ctrlObj = o2jse.infoForm[defObj.i]; } } else if (!(ctrlObj = o2jse.infoForm[defObj.i] || document.getElementById(defObj.i))) { jxjs.dbg_ctrl = "Missing " + defObj.i + " (" + defObj.t + ")"; return; } if (typeof(ctrlObj.o2) == 'undefined') { o2jse.ctrl.init(ctrlObj); } o2_save = ctrlObj.o2; ctrlObj.o2 = defObj.p; switch (defObj.t) { case "label": if (defObj.v) { ctrlObj.style.display = ""; if (defObj.p.pT != 'tab') { ctrlObj.parentNode.style.left = defObj.x + 'px'; ctrlObj.parentNode.style.top = defObj.y + 'px'; ctrlObj.style.width = defObj.w + 'px'; } else if (o2_save.cT != 'label') { ctrlObj.style.maxWidth = defObj.w + 'px'; } else { ctrlObj.style.width = defObj.w + 'px'; } ctrlObj.style.height = defObj.h + 'px'; if (ctrlObj.className != defObj.s) { ctrlObj.className = defObj.s; } if (ctrlObj.innerHTML != defObj.l) { ctrlObj.innerHTML = defObj.l; } } else { ctrlObj.style.display = "none"; } break; case "edit": if (defObj.v) { ctrlObj.style.display = ""; ctrlObj.style.width = defObj.w + 'px'; ctrlObj.style.height = defObj.h + 'px'; if (defObj.p.pT != 'tab') { ctrlObj.parentNode.style.left = defObj.x + 'px'; ctrlObj.parentNode.style.top = defObj.y + 'px'; } var disabled = ctrlObj.nodeName != "INPUT"; if (disabled == defObj.e) { if (defObj.e) { var newEl = document.createElement("input"); newEl.style.width = ctrlObj.style.width; newEl.style.height = ctrlObj.style.height; newEl.name = ctrlObj.id; newEl.o2 = defObj.p; newEl.onchange = function() { o2jse.ctrl.c(this); }; newEl.onfocus = function() { o2jse.ctrl.f(this); }; newEl.onblur = function() { o2jse.ctrl.b(this); }; if (defObj.p.puexp) { newEl.onmouseover = function(e) { o2jse.pu.i(e); }; newEl.onmouseout = function() { o2jse.pu.o(); }; } ctrlObj.parentNode.replaceChild(newEl, ctrlObj); ctrlObj = newEl; } else { var newEl = document.createElement("div"); newEl.style.width = ctrlObj.style.width; newEl.style.height = ctrlObj.style.height; newEl.id = ctrlObj.name; newEl.o2 = defObj.p; if (defObj.p.puexp) { newEl.onmouseover = function(e) { o2jse.pu.i(e); }; newEl.onmouseout = function() { o2jse.pu.o(); }; } if ((document.activeElement.name == ctrlObj.name) && o2jse.ctrl.focusFallBack) { o2jse.cmd.focus(o2jse.ctrl.focusFallBack); } ctrlObj.parentNode.replaceChild(newEl, ctrlObj); ctrlObj = newEl; } newEl = null; if (defObj.p.z) { ctrlObj.ondblclick = function(e) { o2jse.ctrl.zoom(e); }; } } if (defObj.e) { if (ctrlObj.maxLength != defObj.p.s) { ctrlObj.maxLength = defObj.p.s; } if (!ctrlObj.inEdit && modFields.value.indexOf(defObj.p.c) < 0) { if (ctrlObj.value != defObj.d) { ctrlObj.value = defObj.d; } } } else { if (ctrlObj.innerText != defObj.d) { ctrlObj.innerText = defObj.d; } } if (ctrlObj.style.textAlign != defObj.a) { ctrlObj.style.textAlign = defObj.a; } if (ctrlObj.className != defObj.s) { ctrlObj.className = defObj.s; } } else { ctrlObj.style.display = "none"; } break; case "text": if (defObj.v) { if (defObj.p.rte) { ctrlObj.parentNode.style.display = ""; if (ctrlObj.className != defObj.p.cssc) { ctrlObj.className = defObj.p.cssc; } if (ctrlObj.value != defObj.text) { ctrlObj.value = defObj.text; } } else { ctrlObj.style.display = ""; ctrlObj.style.width = defObj.w + 'px'; ctrlObj.style.height = defObj.h + 'px'; if (defObj.p.pT != 'tab') { ctrlObj.parentNode.style.left = defObj.x + 'px'; ctrlObj.parentNode.style.top = defObj.y + 'px'; } var zoom = defObj.p.z; var disabled = ctrlObj.nodeName != "TEXTAREA"; if (disabled == defObj.e) { if (defObj.e) { var newEl = document.createElement("textarea"); newEl.style.width = ctrlObj.style.width; newEl.style.height = ctrlObj.style.height; newEl.name = ctrlObj.id; newEl.id = ctrlObj.id; newEl.o2 = defObj.p; newEl.onchange = function() { o2jse.ctrl.c(this); }; newEl.onfocus = function() { o2jse.ctrl.f(this); }; newEl.onblur = function() { o2jse.ctrl.b(this); }; if (defObj.p.puexp) { newEl.onmouseover = function(e) { o2jse.pu.i(e); }; newEl.onmouseout = function() { o2jse.pu.o(); }; } ctrlObj.parentNode.replaceChild(newEl, ctrlObj); ctrlObj = newEl; } else { var newEl = document.createElement("div"); newEl.style.width = ctrlObj.style.width; newEl.style.height = ctrlObj.style.height; newEl.id = ctrlObj.name; newEl.o2 = defObj.p; if (defObj.p.puexp) { newEl.onmouseover = function(e) { o2jse.pu.i(e); }; newEl.onmouseout = function() { o2jse.pu.o(); }; } if ((document.activeElement.name == ctrlObj.name) && o2jse.ctrl.focusFallBack) { o2jse.cmd.focus(o2jse.ctrl.focusFallBack); } ctrlObj.parentNode.replaceChild(newEl, ctrlObj); ctrlObj = newEl; } newEl = null; if (defObj.p.z) { ctrlObj.ondblclick = function(e) { o2jse.ctrl.zoom(e); }; } } if (defObj.e) { if (!ctrlObj.inEdit && modFields.value.indexOf(defObj.p.c) < 0) { if (ctrlObj.value != defObj.text) { ctrlObj.value = defObj.text; } } } else { if (ctrlObj.innerText != defObj.text) { ctrlObj.innerText = defObj.text; } } if (ctrlObj.className != defObj.s) { ctrlObj.className = defObj.s; } } } else { if (defObj.p.rte) { ctrlObj.parentNode.style.display = "none"; } else { ctrlObj.style.display = "none"; } } break; case "checkbox": if (defObj.v) { ctrlObj.style.display = ""; if (defObj.p.pT != 'tab') { ctrlObj.parentNode.style.left = defObj.x + 'px'; ctrlObj.parentNode.style.top = defObj.y + 'px'; } if (ctrlObj.disabled == defObj.e) { if (defObj.e) { ctrlObj.disabled = false; ctrlObj.onclick = function() { o2jse.cb.c(this, defObj.vS); }; } else { ctrlObj.disabled = true; ctrlObj.onclick = null; } } if (ctrlObj.className != defObj.s) { ctrlObj.className = defObj.s; } if (ctrlObj.checked != defObj.d) { ctrlObj.checked = defObj.d; } } else { ctrlObj.style.display = "none"; } break; case "listcombo": if (defObj.boxtype != "lookup") { divObj = document.getElementById(defObj.i); if (defObj.v) { divObj.style.display = ""; divObj.style.width = defObj.w + 'px'; divObj.style.height = defObj.h + 'px'; if (defObj.p.pT != 'tab') { divObj.parentNode.style.left = defObj.x + 'px'; divObj.parentNode.style.top = defObj.y + 'px'; } var zoom = defObj.p.z; if (defObj.e) { divObj.onclick = function(e) { o2jse.lb.m(e); }; } else { divObj.onclick = null; } var opts = divObj.getElementsByTagName("div"); var icode; var itext; divObj.innerHTML = ""; for (var i = 0; i < defObj.items.length; i++) { icode = defObj.items[i][0]; itext = defObj.items[i][1]; opts[i] = o2jse.createEl(divObj, "DIV", "", itext); opts[i].dataset.code = icode; if (icode == defObj.d) { opts[i].className = "jxlsr"; o2jse.lb.showByScroll(opts[i]); } } if (ctrlObj.value != defObj.d && modFields.value.indexOf(defObj.p.c) < 0) { ctrlObj.value = defObj.d; } if (divObj.className != defObj.s) { divObj.className = defObj.s; } } else { divObj.style.display = "none"; } } else { var descField = document.getElementById(defObj.i + "_desc"); o2jse.ctrl.init(descField); if (defObj.v) { descField.style.display = ""; descField.style.width = defObj.w + 'px'; descField.style.height = defObj.h + 'px'; if (defObj.p.pT != 'tab') { descField.parentNode.parentNode.style.left = defObj.x + 'px'; descField.parentNode.parentNode.style.top = defObj.y + 'px'; } var disabled = descField.nodeName != "INPUT"; if (disabled == defObj.e) { if (defObj.e) { var newEl = document.createElement("input"); newEl.style.width = descField.style.width; newEl.style.height = descField.style.height; newEl.id = descField.id; newEl.o2 = defObj.p; descField.onkeydown = function(e){ o2jse.lu.k(e, this); }; descField.onclick = function() { o2jse.lu.ck(this); }; descField.onpaste = function() { o2jse.lu.p(this); }; descField.onfocus = function() { o2jse.lu.f(this); }; descField.onblur = function() { o2jse.lu.b(this); }; if (defObj.p.puexp) { descField.onmouseover = function(e){ o2jse.pu.i(e); }; descField.onmouseout = function() { o2jse.pu.o(); }; } descField.parentNode.replaceChild(newEl, descField); descField = newEl; } else { var newEl = document.createElement("div"); newEl.style.width = descField.style.width; newEl.style.height = descField.style.height; newEl.id = descField.id; newEl.o2 = defObj.p; if (defObj.p.puexp) { newEl.onmouseover = function(e){ o2jse.pu.i(e); }; newEl.onmouseout = function() { o2jse.pu.o(); }; } if ((document.activeElement.id == descField.id) && o2jse.ctrl.focusFallBack) { o2jse.cmd.focus(o2jse.ctrl.focusFallBack); } descField.parentNode.replaceChild(newEl, descField); descField = newEl; } newEl = null; if (defObj.p.z) { descField.ondblclick = function(e){ o2jse.ctrl.zoom(e); }; } } var zoom = defObj.p.z; if (defObj.e) { if (defObj.dyn) { descField.o2.dyn = true; } else { descField.o2.items = defObj.items; descField.o2.dyn = false; } descField.o2.rows = defObj.p.rows; descField.onkeydown = function(e) { o2jse.lu.k(e, this); }; descField.onpaste = function() { o2jse.lu.p(this); }; descField.onfocus = function() { o2jse.lu.f(this); }; descField.onblur = function() { o2jse.lu.b(this); }; if (defObj.o) { iObjs = descField.parentNode.getElementsByTagName('div'); if (iObjs[0]) { iObj = iObjs[0]; } else { iObj = o2jse.createEl(descField.parentNode, 'DIV', defObj.s + '_handler', '&nbsp;'); iObj.style.width = defObj.h + 'px'; iObj.style.height = defObj.h + 'px'; } iObj.onclick = function() { o2jse.lu.ick(this); }; iObj.style.display = 'block'; descField.style.cursor = 'auto'; } else { descField.onclick = function() { o2jse.lu.ck(this); }; descField.style.cursor = 'pointer'; } } else { descField.style.cursor = "default"; o2jse.lu.listOff(descField); if (defObj.o) { iObjs = descField.parentNode.getElementsByTagName('div'); if (iObjs[1]) { o2jse.removeEl(iObjs[1]); } } } if (modFields.value.indexOf(defObj.p.c) < 0) { if (ctrlObj.value != defObj.d) { ctrlObj.value = defObj.d; delete descField.saveValue; } if (defObj.e) { if (descField.value != defObj.desc && !descField.inEdit) { descField.value = defObj.desc; descField.scrollLeft = 0; } } else { if (descField.innerText != defObj.d) { descField.innerText = defObj.desc; } } } if (descField.className != defObj.p.cssf) { descField.className = defObj.p.cssf; } } else { descField.style.display = 'none'; if (defObj.o) { iObjs = descField.parentNode.getElementsByTagName('div'); if (iObjs[0]) { iObj = iObjs[0]; iObj.style.display = 'none'; } } } } break; case "button": if (defObj.v) { ctrlObj.style.display = ""; ctrlObj.style.width = defObj.w + 'px'; ctrlObj.style.height = defObj.h + 'px'; if (defObj.p.pT != 'tab') { ctrlObj.parentNode.style.left = defObj.x + 'px'; ctrlObj.parentNode.style.top = defObj.y + 'px'; } if (defObj.e) { ctrlObj.onclick = function() { o2jse.ctrl.btnExe(this); }; ctrlObj.onfocus = function() { o2jse.ctrl.f(this); }; ctrlObj.onblur = function() { o2jse.ctrl.b(this); }; ctrlObj.tabIndex = "0"; } else { ctrlObj.onclick = null; ctrlObj.onfocus = null; ctrlObj.onblur = null; ctrlObj.removeAttribute("tabIndex"); } if (ctrlObj.className != defObj.s) { ctrlObj.className = defObj.s; } if (ctrlObj.innerHTML != defObj.l) { ctrlObj.innerHTML = defObj.l; } } else { ctrlObj.style.display = "none"; } break; case "img": if (defObj.v) { ctrlObj.style.display = ""; ctrlObj.style.width = defObj.w + 'px'; ctrlObj.style.height = defObj.h + 'px'; if (defObj.p.pT != 'tab') { ctrlObj.parentNode.style.left = defObj.x + 'px'; ctrlObj.parentNode.style.top = defObj.y + 'px'; } if (ctrlObj.src != defObj.src) { ctrlObj.src = defObj.src; } if (defObj.e) { if (!ctrlObj.onclick) { ctrlObj.onclick = function() { o2jse.ctrl.btnExe(this); }; ctrlObj.style.cursor = "pointer"; } if (defObj.srcover && !ctrlObj.onmouseover) { ctrlObj.onmouseover = function() { this.src = defObj.srcover; }; ctrlObj.onmouseout = function() { this.src = defObj.src; }; } } else { ctrlObj.onclick = null; ctrlObj.onmouseover = null; ctrlObj.onmouseout = null; ctrlObj.style.cursor = "default"; } if (ctrlObj.className != defObj.s) { ctrlObj.className = defObj.s; } if (ctrlObj.title != defObj.l) { ctrlObj.alt = defObj.l; ctrlObj.title = defObj.l; } } else { ctrlObj.style.display = "none"; } break; case "html": if (defObj.v) { ctrlObj.style.display = ""; ctrlObj.style.width = defObj.w + 'px'; ctrlObj.style.height = defObj.h + 'px'; if (defObj.p.pT != 'tab') { ctrlObj.parentNode.style.left = defObj.x + 'px'; ctrlObj.parentNode.style.top = defObj.y + 'px'; } if (ctrlObj.className != defObj.s) { ctrlObj.className = defObj.s; } if (ctrlObj.innerHTML != defObj.code) { ctrlObj.innerHTML = defObj.code; jxjs.runScripts(ctrlObj); } } else { ctrlObj.style.display = "none"; } break; case "tree": if (defObj.v) { ctrlObj.style.display = ""; ctrlObj.style.width = defObj.w + 'px'; ctrlObj.style.height = defObj.h + 'px'; if (defObj.p.pT != 'tab') { ctrlObj.parentNode.style.left = defObj.x + 'px'; ctrlObj.parentNode.style.top = defObj.y + 'px'; } if (ctrlObj.className != defObj.s) { ctrlObj.className = defObj.s; } if (ctrlObj.innerHTML != defObj.code) { ctrlObj.innerHTML = defObj.code; } } else { ctrlObj.style.display = "none"; } break; case "imglist": if (defObj.v) { ctrlObj.style.display = ""; ctrlObj.style.width = defObj.w + 'px'; ctrlObj.style.height = defObj.h + 'px'; if (defObj.p.pT != 'tab') { ctrlObj.parentNode.style.left = defObj.x + 'px'; ctrlObj.parentNode.style.top = defObj.y + 'px'; } if (ctrlObj.className != defObj.s) { ctrlObj.className = defObj.s; } if (ctrlObj.innerHTML != defObj.code) { ctrlObj.innerHTML = defObj.code; } } else { ctrlObj.style.display = "none"; } break; case "progress": if (defObj.v) { ctrlObj.style.display = ""; ctrlObj.style.width = defObj.w + 'px'; ctrlObj.style.height = defObj.h + 'px'; if (defObj.p.pT != 'tab') { ctrlObj.parentNode.style.left = defObj.x + 'px'; ctrlObj.parentNode.style.top = defObj.y + 'px'; } if (ctrlObj.className != defObj.s) { ctrlObj.className = defObj.s; } o2jse.progress.set(ctrlObj.id, defObj.vl); if (defObj.a) { o2jse.progress.start(); } } else { ctrlObj.style.display = "none"; } break; case "flowbox": if (defObj.v) { ctrlObj.style.display = ""; ctrlObj.style.width = defObj.w + 'px'; ctrlObj.style.height = defObj.h + 'px'; if (defObj.p.pT != 'tab') { ctrlObj.parentNode.style.left = defObj.x + 'px'; ctrlObj.parentNode.style.top = defObj.y + 'px'; } if (ctrlObj.className != defObj.s) { ctrlObj.className = defObj.s; } } else { ctrlObj.style.display = "none"; } break; case "frame": if (defObj.v) { ctrlObj.style.display = ""; intDiv = ctrlObj.getElementsByTagName('div')[0]; intDiv.style.width = defObj.w + 'px'; intDiv.style.height = defObj.h + 'px'; if (ctrlObj.className != defObj.s) { ctrlObj.className = defObj.s; } } else { ctrlObj.style.display = "none"; } break; case "navigator": var ctrlObjDiv = ctrlObj.parentNode; if (defObj.v) { ctrlObjDiv.style.display = ""; if (defObj.p.pT != 'tab') { ctrlObj.style.width = defObj.w + 'px'; ctrlObj.style.height = defObj.h + 'px'; ctrlObjDiv.style.left = defObj.x + 'px'; ctrlObjDiv.style.top = defObj.y + 'px'; } if (defObj.code) { ctrlObjDiv.innerHTML = defObj.code; } } else { ctrlObjDiv.style.display = "none"; } break; case "file": if (defObj.v) { ctrlObj.style.display = ""; ctrlObj.style.width = defObj.w + 'px'; ctrlObj.style.height = defObj.h + 'px'; if (defObj.p.pT != 'tab') { ctrlObj.parentNode.style.left = defObj.x + 'px'; ctrlObj.parentNode.style.top = defObj.y + 'px'; } } else { ctrlObj.style.display = "none"; } break; } jxjs.dbg_ctrl = "Processed " + defObj.i + " (" + defObj.t + ")"; } }; jxv = function(formName, seleValue) { if (o2jse.infoForm[formName]) { o2jse.infoForm[formName].value = seleValue; } else { seleField = document.createElement("input"); seleField.setAttribute("type", "hidden"); seleField.setAttribute("name", formName); seleField.setAttribute("value", seleValue); o2jse.infoForm.appendChild(seleField); } }; jxp_old = function(pageCode) { var oHTML = document.getElementsByTagName('html')[0]; var nHTML = document.createElement("html"); nHTML.innerHTML = pageCode; oHTML.parentNode.replaceChild(nHTML, oHTML); oHTML = null; o2jse.started = false; o2jse.fastMsg.frameObj = null; if (o2jse.devName && o2jse.lab) { o2jse.lab.contWin = null; } jxjs.runScripts(nHTML); }; jxp = function(pageCode) { var oBody = document.getElementsByTagName('body')[0]; var nBody = document.createElement('body'); nBody.innerHTML = pageCode; nBody.className = "o2_sfondo"; nBody.onload = o2jse.init; nBody.onBeforeUnload = o2jse.cmd.showClock; oBody.parentNode.replaceChild(nBody, oBody); oBody = null; o2jse.started = false; o2jse.fastMsg.frameObj = null; if (o2jse.devName && o2jse.lab) { o2jse.lab.contWin = null; } jxjs.runScripts(nBody); }; jxe = function(errCode) { contDiv = o2jse.createEl(document.getElementById("jxjsinsert"), "div"); contDiv.innerHTML = errCode; o2jse.submitting = false; o2jse.cliMode = false; }; o2jse.menu = { menuList : [], openMenus : [], timeout : null, lastBarItem : null, accList : [], docByMenu : false }; o2jse.menu.addMenu = function(menuId, label) { var newMenu = { id : menuId, label : label, shown : false, items : [], outBox : null, inBox : null, frame : null, width : 0, height : 0 }; newMenu.outBox = document.createElement("DIV"); newMenu.outBox.className = "winshadow"; newMenu.outBox.style.position = "fixed"; newMenu.outBox.onmouseover = function() { if (o2jse.menu.timeout) { clearTimeout(o2jse.menu.timeout); } }; newMenu.outBox.onmouseout = o2jse.menu.closeByTime; newMenu.inBox = o2jse.createEl(newMenu.outBox, "DIV", "o2menu"); newMenu.frame = o2jse.createEl(newMenu.inBox, "TABLE"); newMenu.frame.cellPadding = "0"; newMenu.frame.cellSpacing = "0"; newMenu.addItem = function(itemType, elementId, labelTxt, dataStr, imgFile) { itemType = String(itemType).toUpperCase(); var newItem = {}; var newItemId = newMenu.items.length; newItem.row = newMenu.frame.insertRow(-1); newItem.row.o2 = {c : elementId, cT : "menuitem", itemType : itemType, prgName : (itemType == "P" ? dataStr : ""), itemLabel : labelTxt, itemImg : imgFile, fret : true}; switch (itemType) { case "P": buildActiveItem(); newItem.row.onclick = function() { o2jse.menu. openMenus[o2jse.menu.openMenus.length] = { label: labelTxt }; o2jse.cmd.run(dataStr); }; newItem.labelCell.colSpan = "2"; break; case "M": if (!o2jse.menu.menuList[elementId]) { o2jse.menu.addMenu(elementId, labelTxt); } buildActiveItem(); newItem.arrowCell = newItem.row.insertCell(-1); newItem.arrowCell.className = "o2menuArrow"; break; case "S": newItem.row.className = "o2menuSep"; newItem.labelCell = newItem.row.insertCell(-1); newItem.labelCell.colSpan = "3"; newItem.labelCell.className = "o2menuSep"; break; case "J": buildActiveItem(); if (typeof dataStr == "function") { newItem.row.onclick = dataStr; } else { newItem.row.onclick = new Function("event", dataStr); } newItem.labelCell.colSpan = "2"; break; case "U": buildActiveItem(); newItem.row.onclick = function() { window.location.href = dataStr; }; newItem.labelCell.colSpan = "2"; break; case "R": newItem.row.innerHTML = labelTxt; break; default: buildActiveItem(); newItem.row.onclick = function() { alert(dataStr); }; newItem.labelCell.colSpan = "2"; break; } newMenu.items[newItemId] = newItem; function buildActiveItem() { newItem.row.className = "o2menuItem"; newItem.row.itemType = itemType; newItem.row.elementId = elementId; newItem.row.parentId = newMenu.id; newItem.row.onmouseover = newMenu.onMenuItem; newItem.row.onmouseout = function() { this.className = "o2menuItem"; }; newItem.imgCell = newItem.row.insertCell(-1); if (imgFile) { newItem.imgCell.className = "o2menuImg"; newItem.img = o2jse.createEl(newItem.imgCell, "IMG"); newItem.img.src = imgFile; } newItem.labelCell = newItem.row.insertCell(-1); newItem.labelCell.className = "o2menuLabel"; newItem.labelCell.innerHTML = labelTxt; }; }; newMenu.clear = function() { newMenu.inBox.innerHTML = ""; newMenu.frame = o2jse.createEl(newMenu.inBox, "TABLE"); newMenu.frame.cellPadding = "0"; newMenu.frame.cellSpacing = "0"; }; newMenu.context = function(menuContext) { newMenu.inBox.innerHTML = ""; newMenu.frame = null; if (typeof menuContext == "object") { newMenu.inBox.appendChild(menuContext); } else { newMenu.inBox.innerHTML = menuContext; } }; newMenu.show = function(posObj, parentObj, barObj) { o2jse.elBody.appendChild(newMenu.outBox); if (barObj) { if (posObj.x < (o2jse.cli.width - newMenu.outBox.offsetWidth)) { newMenu.outBox.style.left = posObj.x + "px"; } else { newMenu.outBox.style.left = (posObj.x + barObj.parentNode.offsetLeft + barObj.offsetWidth - newMenu.outBox.offsetWidth) + "px"; } if (posObj.y < (o2jse.cli.height - newMenu.outBox.offsetHeight)) { newMenu.outBox.style.top = posObj.y + "px"; } else { newMenu.outBox.style.top = (o2jse.cli.height - newMenu.outBox.offsetHeight - 10) + "px"; } if (o2jse.menuStyle != 'T') { if (newMenu.inBox.className.indexOf('o2menuVert') < 0) { newMenu.inBox.className+= ' o2menuVert'; } } } else if (parentObj) { if (posObj.x < (o2jse.cli.width - newMenu.outBox.offsetWidth)) { newMenu.outBox.style.left = posObj.x + "px"; } else { newMenu.outBox.style.left = (posObj.x - parentObj.offsetWidth - newMenu.outBox.offsetWidth) + "px"; } if (posObj.y < (o2jse.cli.height - newMenu.outBox.offsetHeight)) { newMenu.outBox.style.top = posObj.y + "px"; } else { newMenu.outBox.style.top = (o2jse.cli.height - newMenu.outBox.offsetHeight - 10) + "px"; } if (newMenu.inBox.className.indexOf('o2menuFloat') < 0) { newMenu.inBox.className+= ' o2menuFloat'; } } else { if (posObj.x < (o2jse.cli.width - newMenu.outBox.offsetWidth)) { newMenu.outBox.style.left = posObj.x + "px"; } else { newMenu.outBox.style.left = (o2jse.cli.width - newMenu.outBox.offsetWidth - 10) + "px"; } if (posObj.y < (o2jse.cli.height - newMenu.outBox.offsetHeight)) { newMenu.outBox.style.top = posObj.y + "px"; } else { newMenu.outBox.style.top = (o2jse.cli.height - newMenu.outBox.offsetHeight - 10) + "px"; } if (newMenu.inBox.className.indexOf('o2menuFloat') < 0) { newMenu.inBox.className+= ' o2menuFloat'; } } if (newMenu.outBox.offsetHeight > (o2jse.cli.height - 20)) { newMenu.outBox.style.height = (o2jse.cli.height - 20) + "px"; newMenu.outBox.style.top = "10px"; newMenu.outBox.style.overflowY = "scroll"; newMenu.outBox.style.overflowX = "hidden"; } o2jse.menu.openMenus[o2jse.menu.openMenus.length] = newMenu; newMenu.shown = true; }; newMenu.onMenuItem = function() { this.className = "o2menuItemOn"; o2jse.menu.closeDownNode(this.parentId); if (this.itemType == "M") { var posObj = {x : 0, y : 0}; var menuFrom = this.parentNode.parentNode.parentNode; var shadowFrom = menuFrom.parentNode; posObj.x = shadowFrom.offsetLeft + menuFrom.offsetLeft + menuFrom.offsetWidth - 1; posObj.y = shadowFrom.offsetTop + menuFrom.offsetTop + this.offsetTop; o2jse.menu.menuList[this.elementId].show(posObj, menuFrom); } }; o2jse.menu.menuList[menuId] = newMenu; return newMenu; }; o2jse.menu.menuBtn = function() { menuBar = document.getElementById('jxMenuBar'); menuBtn = document.getElementById('jxMenuButton'); if (menuBar.style.display == 'none') { menuBtn.className = 'o2menuClose'; menuBar.style.display = 'block'; } else { menuBtn.className = 'o2menuButton'; menuBar.style.display = 'none'; } }; o2jse.menu.onOverBarItem = function(targetObj, itemType, elementId) { if (o2jse.menu.openMenus.length) { o2jse.menu.activateBarItem(targetObj, itemType, elementId); } }; o2jse.menu.onOutBarItem = function(targetObj, itemType, elementId) { o2jse.menu.lastBarItem = targetObj; }; o2jse.menu.onClickBarItem = function(targetObj, itemType, elementId, dataStr) { switch (itemType) { case "M": if (o2jse.menu.openMenus.length) { for (var menuId in o2jse.menu.openMenus) { var menu = o2jse.menu.openMenus[menuId]; if ((menu.id == elementId) && menu.shown) { targetObj.className = "o2menuItem"; o2jse.menu.closeAll(); return; } } } break; case "P": o2jse.menu.openMenus[o2jse.menu.openMenus.length] = { id: targetObj.textContent }; o2jse.cmd.run(dataStr); break; default: alert(itemType); break; } o2jse.menu.activateBarItem(targetObj, itemType, elementId); }; o2jse.menu.activateBarItem = function(targetObj, itemType, elementId) { if (o2jse.menu.lastBarItem) { o2jse.menu.lastBarItem.className = "o2menuItem"; } if (o2jse.menu.timeout) { clearTimeout(o2jse.menu.timeout); } o2jse.menu.loadAppMenu(); o2jse.menu.closeDownNode(); targetObj.className = "o2menuItemOn"; if (itemType == "M") { var posObj = {x:0, y:0}; var menuBar = targetObj.parentNode; if (o2jse.menuStyle == 'T') { posObj.x = targetObj.offsetLeft; posObj.y = menuBar.offsetTop + targetObj.offsetTop + targetObj.offsetHeight - 1; } else { posObj.x = targetObj.offsetLeft + targetObj.offsetWidth; posObj.y = menuBar.offsetTop - menuBar.scrollTop + targetObj.offsetTop; } o2jse.menu.menuList[elementId].show(posObj, null, targetObj); } else { o2jse.menu.openMenus[o2jse.menu.openMenus.length] = true; } }; o2jse.menu.closeDownNode = function(menuId) { var openMenus = o2jse.menu.openMenus; if (openMenus.length > 0) { for (var ancestorId = openMenus.length; ancestorId > 0; ancestorId--) { ancMenu = openMenus[ancestorId - 1]; if (ancMenu.id != menuId) { o2jse.removeEl(ancMenu.outBox); ancMenu.shown = false; openMenus.pop(); } else { break; } } } }; o2jse.menu.closeByTime = function() { if (o2jse.menu.timeout) { clearTimeout(o2jse.menu.timeout); } o2jse.menu.timeout = setTimeout(o2jse.menu.closeAll, 1000); }; o2jse.menu.closeAll = function() { if (o2jse.menu.lastBarItem) { o2jse.menu.lastBarItem.className = "o2menuItem"; } if (o2jse.menu.openMenus.length > 0) { for (var ancestorId = o2jse.menu.openMenus.length; ancestorId > 0; ancestorId--) { o2jse.removeEl(o2jse.menu.openMenus[ancestorId - 1].outBox); o2jse.menu.openMenus[ancestorId - 1].shown = false; o2jse.menu.openMenus.pop(); } } o2jse.menu.openMenus = []; o2jse.win.showMenu = false; }; o2jse.menu.loadAppMenu = function() { if (o2jse.menu.appMainMenu && !o2jse.menu.menuList[o2jse.menu.appMainMenu]) { o2jse.menu.appMenu(); } }; o2jse.menu.accSet = function() { let menus = o2jse.menu.accList; let menu = o2jse.menu.appMainMenu; if (menus) { while (menu = menus[menu]) { radioEl = document.getElementById(menu); if (radioEl) { radioEl.checked = true; } } } }; o2jse.cMenu = o2jse.menu.addMenu("o2cmenu"); o2jse.cMenu.shown = false; o2jse.cMenu.target = null; o2jse.cMenu.partnersB = []; o2jse.cMenu.partnersA = []; o2jse.cMenu.setOn = function(eventObj) { var stdEvent = o2jse.event.std(eventObj); if ((stdEvent.target.className == 'o2statusinfo') && o2jse.ctrl.focusCtrl) { stdEvent.target = document.getElementsByName(o2jse.ctrl.focusCtrl)[0]; } else if (stdEvent.target.name) { o2jse.ctrl.focusCtrl = stdEvent.target.name; } o2jse.cMenu.target = stdEvent.target; if (o2jse.cMenu.loadItems()) { o2jse.cMenu.stdEdit(stdEvent); stdEvent.stop(); o2jse.cMenu.show(stdEvent); } return true; }; o2jse.cMenu.setOff = function() { o2jse.removeEl(o2jse.menu.menuList["o2cmenu"].outBox); o2jse.menu.menuList["o2cmenu"].outBox = null; o2jse.menu.menuList["o2cmenu"].shown = false; }; o2jse.cMenu.mouseOver = function() { clearTimeout(o2jse.cMenu.timeout); }; o2jse.cMenu.mouseOut = function() { o2jse.cMenu.timeout = setTimeout(o2jse.cMenu.setOff, 1000); }; o2jse.cMenu.loadItems = function() { var somethingIn = false; o2jse.cMenu.clear(); if (o2jse.cMenu.partnersB.length > 0) { for (var partnerId = o2jse.cMenu.partnersB.length; partnerId > 0; partnerId--) { somethingIn = (o2jse.cMenu.partnersB[partnerId - 1]() || somethingIn); } } o2jse.ctrl.init(o2jse.cMenu.target); if (o2jse.cMenu.target.o2.log) { o2jse.cMenu.addItem("J", "jxdatalog", "Data history", function() { o2jse.ctrl.log(o2jse.cMenu.target); }, o2jse.rntAlias + "img/history.png"); somethingIn = true; } if (o2jse.contMenuApp) { appSubMenu = false; if (o2jse.menu.menuList[o2jse.menu.appMainMenu]) { appSubMenu = true; } else if (o2jse.menu.appMenu) { o2jse.menu.appMenu(); appSubMenu = true; } if (appSubMenu) { o2jse.cMenu.addItem("M", o2jse.menu.appMainMenu, "App menu", "", o2jse.rntAlias + "img/appmenu.gif"); somethingIn = true; } } if (o2jse.superUser) { o2jse.cMenu.addAdmin(); somethingIn = true; } if (o2jse.contMenuNewSess) { o2jse.cMenu.addItem("J", "jxnewsess", "Open new session", function() { o2jse.requester.exe("sessopen", "", o2jse.cMenu, jxjs.jsEval); return false; }, o2jse.rntAlias + "img/sess_new.png"); somethingIn = true; } if (o2jse.cMenu.partnersA.length > 0) { for (var partnerId = o2jse.cMenu.partnersA.length; partnerId > 0; partnerId--) { somethingIn = (o2jse.cMenu.partnersA[partnerId - 1]() || somethingIn); } } return somethingIn; }; o2jse.cMenu.stdEdit = function(stdEvent) { if (typeof navigator.clipboard == "undefined") { return; } s = false; f = false; t = stdEvent.target; if (t.value) { s = t.value.substring(t.selectionStart, t.selectionEnd); f = s.length > 0; } else { s = document.getSelection().toString() } o2jse.cMenu.addItem('S'); if (s && navigator.clipboard.writeText) { o2jse.cachedText = s; o2jse.cMenu.addItem('J', 'jxCopy', 'Copy', function() { navigator.clipboard.writeText(o2jse.cachedText); o2jse.menu.closeAll(); }, o2jse.rntAlias + 'img/edit_copy.png'); if (f) { o2jse.cMenu.addItem('J', 'jxCut', 'Cut', function() { navigator.clipboard.writeText(o2jse.cachedText); t.value = t.value.slice(0, t.selectionStart) + t.value.slice(t.selectionEnd); o2jse.menu.closeAll(); }, o2jse.rntAlias + 'img/edit_cut.png'); } s = false; } if (navigator.clipboard.readText && (t.tagName === 'INPUT' || t.tagName === 'TEXTAREA')) { navigator.clipboard.readText().then( function (s) { if (s) { o2jse.cMenu.addItem('J', 'jxPaste', 'Paste', function() { t.value = t.value.slice(0, t.selectionStart) + s + t.value.slice(t.selectionEnd + 1); o2jse.menu.closeAll(); }, o2jse.rntAlias + 'img/edit_paste.png')}; }); } }; o2jse.cMenu.addAdmin = function() { o2jse.cMenu.addItem("M", "o2admin", "Administrator", "", o2jse.rntAlias + "img/admin.png"); o2jse.menu.menuList["o2admin"].clear(); if (o2jse.menu.menuList["o2options"]) { o2jse.menu.menuList["o2options"].clear(); } if (o2jse.menu.menuList["jxdoc_folder"]) { o2jse.menu.menuList["jxdoc_folder"].clear(); } if (o2jse.menu.menuList["jxmultilang"]) { o2jse.menu.menuList["jxmultilang"].clear(); } o2jse.menu.admMenu(); o2jse.ctrl.init(o2jse.cMenu.target); if (o2jse.doc) { o2jse.menu.menuList["o2admin"].addItem("M", "jxdoc_folder", "Documentation", "", o2jse.rntAlias + "img/jxdoc.png"); var pMenu = o2jse.menu.menuList["jxdoc_folder"]; var done = false; if (o2jse.cMenu.target.o2.cT == "menuitem") { var func2exe = function() { o2jse.cmd.run("doc/jxdoc_start", 0, o2jse.cMenu.target.o2.prgName); }; pMenu.addItem("J", "jxdocbymenu", "Document menu item <b>" + o2jse.cMenu.target.o2.itemLabel + "</b>", func2exe, o2jse.rntAlias + "img/jxdoc_bymenu.png"); done = true; } if (o2jse.cMenu.target.o2.f) { pMenu.addItem("J", "jxdocbyctrl", "Document this control, form or program", function() { o2jse.cmd.doc(o2jse.cMenu.target); }, o2jse.rntAlias + "img/jxdoc.png"); done = true; } if (done) { pMenu.addItem("S", "jxdocsep"); } pMenu.addItem("P", "jxdoc_uses", "Uses", "doc/uses_select", o2jse.rntAlias + "img/jxdoc_tool.png"); pMenu.addItem("P", "jxdoc_settings", "Settings", "doc/settings_admin", o2jse.rntAlias + "img/jxdoc_tool.png"); } if (o2jse.profiling) { var pMenu = o2jse.menu.menuList["o2admin"]; switch (o2jse.cMenu.target.o2.cT) { case "menuitem": if (o2jse.profiling == "M" || o2jse.profiling == "B") { var func2exe = function() { o2jse.cmd.run("tools/o2sys_profile_menu", o2jse.cMenu.target.o2.c); }; pMenu.addItem("J", "o2profilemenu", "Profile menu item <b>" + o2jse.cMenu.target.o2.itemLabel + "</b>", func2exe, o2jse.rntAlias + "img/profiling.gif"); } break; case "button": case "edit": case "listcombo": case "checkbox": case "text": case "file": case "img": if (o2jse.profiling == "C" || o2jse.profiling == "B") { var func2exe = function() { o2jse.cmd.run("tools/o2sys_profile_ctrl", o2jse.infoForm['o2_prgname'].value, o2jse.cMenu.target.o2.c); }; pMenu.addItem("J", "o2profilectrl", "Profile <b>"+ o2jse.cMenu.target.o2.cT+ "</b> control", func2exe, o2jse.rntAlias + "img/profiling.gif"); } break; } } }; o2jse.cMenu.regPartner = function(funcObj, before) { if (before) { o2jse.cMenu.partnersB[o2jse.cMenu.partnersB.length] = funcObj; } else { o2jse.cMenu.partnersA[o2jse.cMenu.partnersA.length] = funcObj; } }; function jxCalendar(pD, retObj, posX, posY, framed) { this.mList = new Array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'); this.dList = new Array('Mon', 'Tue', 'Wed', 'Thu', 'Fri ', 'Sat', 'Sun'); this.eList = new Array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31); this.today = new Date(); this.xMonth = 0; this.retObj = (typeof retObj == "object" ? retObj : false); if (framed) { this.outBox = document.createElement("DIV"); this.outBox.className = "caleBox"; this.outBox.style.position = "absolute"; this.outBox.style.left = posX + "px"; this.outBox.style.top = posY + "px"; } if (pD) { this.year = pD.getFullYear(); this.month = pD.getMonth(); this.day = pD.getDate(); } else { this.year = this.today.getFullYear(); this.month = this.today.getMonth(); this.day = this.today.getDate(); } this.action = function(pD, pM, pY) { if (this.retObj) { this.retObj.value = o2jse.cale.dateFormat(pD, pM, pY, this.retObj.o2.m); if (o2jse.cliMode && this.retObj.o2.fret) { jxjs.request(this.retObj, this.retObj.value); } else { o2jse.cmd.ctrlUpd(this.retObj); } } this.close(); }; this.close = function() { o2jse.removeEl(o2jse.ctrl.caleObj.outBox); delete o2jse.ctrl.caleObj; o2jse.menu.closeAll(); }; this.comparedate = function(d1, d2) { return d1.getFullYear() == d2.getFullYear() && d1.getMonth() == d2.getMonth() && d1.getDate() == d2.getDate(); }; this.pasqua = function(aa) { var xx = new Array(22, 22, 23, 23, 24, 24); var yy = new Array(2, 2, 3, 4, 5, 5); var a = aa % 19; var b = aa % 4; var c = aa % 7; var i = Math.floor(aa / 100) - 15; var x = xx[i], y = yy[i]; var d = (19 * a + x) % 30; var e = (2 * b + 4 * c + 6 * d + y) % 7; var p = 22 + d + e; var m = 300; if (p > 31) { m = 400; p = p - 31; } return m + p; }; this.isRed = function(pD) { var reds = new Array(0, 101, 106, 501, 815, 1101, 1225, 1226); if (pD.getDay() == 0) { return true; } var pp = this.pasqua(pD.getFullYear()) + 1; if (pp % 100 > 31) { pp = 401; } reds[0] = pp; for (var i = 0; i < reds.length; i++) { if (Math.floor(reds[i] / 100) == pD.getMonth() + 1) { var gg = reds[i] % 100; if (gg == pD.getDate()) { return true; } } } return false; }; this.calendar = function(currday, pMonth, pYear) { var dx = 2 - (new Date(pYear, pMonth, 1)).getDay(); if (dx == 2) { dx = -5; } var daysInMonth = this.eList[pMonth]; if (pMonth == 1) { if (pYear % 4 == 0 && pYear % 100 != 0 || pYear % 400 == 0) { daysInMonth++; } } var frameTable = document.createElement("TABLE"); frameTable.width = "100%"; frameTable.border = "0"; frameTable.cellPadding = "1px"; frameTable.cellSpacing = "1px"; var rowTitle = frameTable.insertRow(-1); var mLessBtn = rowTitle.insertCell(-1); mLessBtn.innerHTML = "\u00ab"; mLessBtn.className = "caleDmBtn"; mLessBtn.onclick = function() { o2jse.ctrl.caleObj.changeMonth(-1); }; var cellTitle = rowTitle.insertCell(-1); cellTitle.colSpan = "5"; cellTitle.className = "caleTitle"; cellTitle.innerHTML = this.mList[pMonth] + ' ' + pYear; var mPlusBtn = rowTitle.insertCell(-1); mPlusBtn.innerHTML = "\u00bb"; mPlusBtn.className = "caleImBtn"; mPlusBtn.onclick = function() { o2jse.ctrl.caleObj.changeMonth(1); }; var rowWDlabels = frameTable.insertRow(-1); for (var i = 0; i < 7; i++) { var cellWDLabel = rowWDlabels.insertCell(-1); cellWDLabel.className = "caleLabel"; cellWDLabel.innerHTML = this.dList[i]; } for (var j = 0; j < 6; j++) { var rowInCale = frameTable.insertRow(-1); rowInCale.style.textAlign = "right"; for (var i = 0; i < 7; i++) { var cellDay = rowInCale.insertCell(-1); cellDay.className = "cal_label"; cellDay.style.backgroundColor = "#F5F5F5"; cellDay.innerHTML = " &nbsp; "; if (dx > 0 && dx <= daysInMonth) { var ddx = new Date(pYear, pMonth, dx); if (this.isRed(ddx)) { cellDay.style.backgroundColor = "#FF9900"; } var tempdate = ddx.getDate() + ", " + ddx.getMonth() + ", " + ddx.getFullYear(); cellDay.innerHTML = '<a href="javascript:o2jse.ctrl.caleObj.action(' + tempdate + ')" class="caleLabel" ' + 'style="text-decoration:none">' + (this.comparedate(ddx, this.today) ? '<b><u>' + dx + '</u></b>' : dx) + '</a>'; } dx++; } } return frameTable; }; this.dataFrame = function(caleFrame) { var frameTable; if (this.outBox) { this.outBox.removeChild(this.outBox.firstChild); if (this.outBox.tagName == "DIV") { frameTable = o2jse.createEl(this.outBox, "TABLE"); } else { frameTable = this.outBox; } } else { this.outBox = document.createElement("TABLE"); frameTable = this.outBox; } frameTable.className = "caleFrame"; var rowCale = frameTable.insertRow(-1); var cellCale = rowCale.insertCell(-1); var rowCmds = frameTable.insertRow(-1); var cellCmds = rowCmds.insertCell(-1); cellCmds.style.textAlign = "right"; cellCale.appendChild(caleFrame); var todayBtn = o2jse.createInput(cellCmds, "button", "caleTodayBtn"); todayBtn.onclick = function() { o2jse.ctrl.caleObj.changeMonth(9); }; var closeBtn = o2jse.createInput(cellCmds, "button", "caleCloseBtn"); closeBtn.onclick = this.close; }; this.changeMonth = function(x) { if (x == 9) { this.xMonth = 0; } else { this.xMonth += x; } var xday = (this.xMonth == 0) ? this.day : 99; var mm = (this.month + this.xMonth) % 12; while (mm < 0) { mm += 12; } this.dataFrame(this.calendar(xday, mm, this.year + Math.floor((this.month + this.xMonth) / 12))); }; this.changeMonth(this.xMonth); }; o2jse.cale = {}; o2jse.cale.dateFormat = function(pD, pM, pY, maskStr) { function lFormat(x) { return x > 9 ? String(x) : "0" + x; }; maskStr = maskStr.toLowerCase(); var rawValue = ""; var shortY = maskStr.indexOf("2") > -1; if (shortY) { pY = String(pY).substr(-2); } if (maskStr.indexOf("d") == -1 && maskStr.indexOf("m") == -1 && maskStr.indexOf("y") == -1) { rawValue = lFormat(pD) + lFormat(pM + 1) + pY; } else { maskStr = maskStr.replace("2", ""); maskStr = maskStr.replace("z", ""); rawValue = maskStr.replace("d", lFormat(pD)). replace("m", lFormat(pM + 1)).replace("y", lFormat(pY)); } return o2jse.data.fd(rawValue, maskStr); }; o2jse.cale.setToday = function() { var targetObj = o2jse.cMenu.target; o2jse.ctrl.init(targetObj); var pD = new Date(); targetObj.value = o2jse.cale.dateFormat(pD.getDate(), pD.getMonth(), pD.getFullYear(), targetObj.o2.m); if (o2jse.cliMode && targetObj.o2.fret) { jxjs.request(targetObj, targetObj.value); } else { o2jse.cmd.ctrlUpd(targetObj); } o2jse.menu.closeAll(); }; o2jse.cale.initContMenu = function() { if (o2jse.cMenu.target.o2.dT == "D") { var pD = new Date(); var sD = o2jse.cale.dateFormat(pD.getDate(), pD.getMonth(), pD.getFullYear(), o2jse.cMenu.target.o2.m); o2jse.cMenu.addItem("J", "o2caleSetToday", "<b>" + sD + "</b>", o2jse.cale.setToday, o2jse.rntAlias + "img/left.png"); o2jse.cMenu.addItem("M", "o2caleShow", "Calendar", "", o2jse.rntAlias + "img/cale.gif"); o2jse.ctrl.caleObj = new jxCalendar(pD, o2jse.cMenu.target, 0, 0, false); o2jse.menu.menuList["o2caleShow"].context(o2jse.ctrl.caleObj.outBox); return true; } else { return false; } }; o2jse.docInitContMenu = function() { if (document.forms.o2form['o2_prgexeid'].value > 0) { o2jse.cMenu.addItem("J", "o2Help", "Documentation", function() { o2jse.cmd.doc(o2jse.cMenu.target); return false; }, o2jse.rntAlias + "img/jxdoc.png"); return true; } else { return false; } };