<?php
o2def::tab("o2_users", "default", "o2sys_users", "o2user");

	o2def::field("o2user", "o2user", "_o2alpha");
	o2def::field("o2password", "o2password", "_o2sid");
	o2def::field("area", "asp_area", "_o2alpha");
	o2def::field("expire_date", "expire_date", "_o2date");
	o2def::field("last_date", "last_date", "_o2date");
	o2def::field("last_time", "last_time", "_o2time");
	o2def::field("login_type", "login_type", "o2sys_login_type");
	o2def::field("last_pwd_date", "last_pwd_date", "_o2date");
	o2def::field("force_pwd_change", "force_pwd_change", "_o2logical");
	o2def::field("pwds_history", "pwds_history", "o2sys_long_str");
	o2def::field("no_pwd_change", "no_pwd_change", "_o2logical");
	o2def::field("creation_date", "creation_date", "_o2date");
	o2def::field("admin", "admin", "_o2logical");
	o2def::field("poweruser", "poweruser", "_o2logical");
	o2def::field("hidden", "hidden", "_o2logical");

	o2def::index("o2user", "o2user","A");
	o2def::index("asp_area", "area","A", "o2user","A");

o2def::tab("o2_sessions", "default", "o2sys_sessions", "sid");

	o2def::field("sid", "sid", "_o2sid");
	o2def::field("o2user", "o2user", "_o2alpha");
	o2def::field("c_date", "c_date", "_o2date");
	o2def::field("c_time", "c_time", "_o2time");
	o2def::field("a_date", "a_date", "_o2date");
	o2def::field("a_time", "a_time", "_o2time");
	o2def::field("e_date", "e_date", "_o2date");
	o2def::field("e_time", "e_time", "_o2time");
	o2def::field("terminal_id", "terminal_id", "jxterminal_id");
	o2def::field("app_name", "app_name", "_o2alpha");
	o2def::field("run_mode", "run_mode", "o2sys_app_run_mode");
	o2def::field("host", "host", "jxhost");

	o2def::index("sid", "sid","A");
	o2def::index("expire", "e_date","A", "e_time","A", "sid","A");
	o2def::index("creation", "c_date","A", "c_time","A", "sid","A");
	o2def::index("lastupdate", "a_date","A", "a_time","A", "sid","A");
	o2def::index("upd_desc", "a_date","D", "a_time","D", "sid","A");

o2def::tab("o2_options", "demo", "o2sys_options", "id");

	o2def::field("o2user", "o2user", "_o2alpha");
	o2def::field("code", "code", "_o2alpha");
	o2def::field("value", "value", "_o2sid");

	o2def::index("id", "o2user","A", "code","A");

o2def::tab("o2_roles_per_user", "demo", "o2sys_roles_per_user", "o2user");

	o2def::field("o2user", "o2user", "_o2alpha");
	o2def::field("role_name", "role_name", "_o2alpha");

	o2def::index("o2user", "o2user","A", "role_name","A");
	o2def::index("role_name", "role_name","A", "o2user","A");

o2def::tab("o2_rights_per_role", "demo", "o2sys_rights_per_role", "role_name");

	o2def::field("role_name", "role_name", "_o2alpha");
	o2def::field("right_code", "right_code", "_o2alpha");

	o2def::index("role_name", "role_name","A", "right_code","A");
	o2def::index("right_code", "right_code","A", "role_name","A");

o2def::tab("o2_roles", "demo", "o2sys_roles", "role_name");

	o2def::field("role_name", "role_name", "_o2alpha");

	o2def::index("role_name", "role_name","A");

o2def::tab("o2_rights", "demo", "o2sys_rights", "right_code");

	o2def::field("right_code", "right_code", "_o2alpha");

	o2def::index("right_code", "right_code","A");

o2def::tab("o2_tabslog", "demo", "o2sys_tabslog", "log_tabname");

	o2def::field("log_tabname", "log_tabname", "_o2alpha");
	o2def::field("log_level", "log_level", "o2sys_loglevel");
	o2def::field("log_operations", "log_operations", "_o2number");

	o2def::index("log_tabname", "log_tabname","A");

o2def::tab("o2_profiling", "demo", "o2sys_profiling", "obj");

	o2def::field("obj_type", "obj_type", "o2sys_obj_type");
	o2def::field("obj_module", "obj_module", "_o2alpha");
	o2def::field("obj_name", "obj_name", "_o2alpha");
	o2def::field("right_vis", "right_vis", "_o2alpha");
	o2def::field("right_enable", "right_enable", "_o2alpha");

	o2def::index("obj", "obj_type","A", "obj_module","A", "obj_name","A", "right_vis","A", "right_enable","A");

o2def::tab("customers", "demo", "customers", "pk_index");

	o2def::field("id", "CUSTOMERNUMBER", "customer_num");
	o2def::field("name", "CUSTOMERNAME", "name");
	o2def::field("cont_last_name", "CONTACTLASTNAME", "name");
	o2def::field("cont_first_name", "CONTACTFIRSTNAME", "name");
	o2def::field("phone", "PHONE", "phone");
	o2def::field("addr_1", "ADDRESSLINE1", "address");
	o2def::field("addr_2", "ADDRESSLINE2", "address");
	o2def::field("city", "CITY", "name");
	o2def::field("state", "STATE", "name");
	o2def::field("postal_code", "POSTALCODE", "postal_code");
	o2def::field("country", "COUNTRY", "name");
	o2def::field("empl_id", "SALESREPEMPLOYEENUMBER", "empl_num");
	o2def::field("credit_limit", "CREDITLIMIT", "amount");

	o2def::index("pk_index", "id","A");
	o2def::index("cust_name", "name","A", "id","A");
	o2def::index("contact", "cont_last_name","A", "cont_first_name","A", "id","A");
	o2def::index("zone", "country","A", "state","A", "city","A", "id","A");
	o2def::index("city", "city","A", "name","A", "id","A");

o2def::tab("employees", "demo", "employees", "pk_index");

	o2def::field("id", "EMPLOYEENUMBER", "empl_num");
	o2def::field("last_name", "LASTNAME", "name");
	o2def::field("first_name", "FIRSTNAME", "name");
	o2def::field("extension", "EXTENSION", "exten");
	o2def::field("email", "EMAIL", "path");
	o2def::field("office_id", "OFFICECODE", "office_num");
	o2def::field("store_id", "REPORTSTO", "store_id");
	o2def::field("job_title", "JOBTITLE", "address");

	o2def::index("pk_index", "id","A");
	o2def::index("empl_name", "last_name","A", "first_name","A", "id","A");
	o2def::index("office", "office_id","A", "last_name","A", "first_name","A", "id","A");

o2def::tab("offices", "demo", "offices", "pk_index");

	o2def::field("id", "OFFICECODE", "office_num");
	o2def::field("city", "CITY", "name");
	o2def::field("phone", "PHONE", "phone");
	o2def::field("addr_1", "ADDRESSLINE1", "address");
	o2def::field("addr_2", "ADDRESSLINE2", "address");
	o2def::field("state", "STATE", "name");
	o2def::field("country", "COUNTRY", "name");
	o2def::field("postal_code", "POSTALCODE", "postal_code");
	o2def::field("territory", "TERRITORY", "territory");

	o2def::index("pk_index", "id","A");
	o2def::index("zone", "country","A", "state","A", "city","A");

o2def::tab("orderdetails", "demo", "orderdetails", "pk_index");

	o2def::field("ord_number", "ORDERNUMBER", "order_num");
	o2def::field("prod_code", "PRODUCTCODE", "prod_code");
	o2def::field("quantity", "QUANTITYORDERED", "quantity");
	o2def::field("single_price", "PRICEEACH", "amount");
	o2def::field("line_num", "ORDERLINENUMBER", "ord_line_num");
	o2def::field("total_price", "PRICEALL", "amount");

	o2def::index("pk_index", "ord_number","A", "prod_code","A");
	o2def::index("product", "prod_code","A", "ord_number","A");
	o2def::index("line_num", "ord_number","A", "line_num","A", "prod_code","A");

o2def::tab("orders", "demo", "orders", "pk_index");

	o2def::field("ord_num", "ORDERNUMBER", "order_num");
	o2def::field("order_date", "ORDERDATE", "full_date");
	o2def::field("req_date", "REQUIREDDATE", "full_date");
	o2def::field("ship_date", "SHIPPEDDATE", "full_date");
	o2def::field("status", "STATUS", "ord_status");
	o2def::field("notes", "COMMENTS", "path");
	o2def::field("cust_id", "CUSTOMERNUMBER", "customer_num");

	o2def::index("pk_index", "ord_num","A");
	o2def::index("ord_date", "order_date","D", "ord_num","A");
	o2def::index("req_date", "req_date","D", "ord_num","A");
	o2def::index("ship_date", "ship_date","D", "ord_num","A");
	o2def::index("customer", "cust_id","A", "order_date","D", "ord_num","A");
	o2def::index("status", "status","A", "order_date","D", "ord_num","A");

o2def::tab("payments", "demo", "payments", "pk_index");

	o2def::field("cust_id", "CUSTOMERNUMBER", "customer_num");
	o2def::field("check_num", "CHECKNUMBER", "address");
	o2def::field("pay_date", "PAYMENTDATE", "full_date");
	o2def::field("amount", "AMOUNT", "amount");

	o2def::index("pk_index", "cust_id","A", "check_num","A");

o2def::tab("products", "demo", "products", "pk_index");

	o2def::field("code", "PRODUCTCODE", "prod_code");
	o2def::field("prod_name", "PRODUCTNAME", "prod_name");
	o2def::field("prod_line", "PRODUCTLINE", "prod_line");
	o2def::field("prod_scale", "PRODUCTSCALE", "prod_scale");
	o2def::field("vendor", "PRODUCTVENDOR", "vendor");
	o2def::field("prod_descr", "PRODUCTDESCRIPTION", "path");
	o2def::field("stock_qty", "QUANTITYINSTOCK", "quantity");
	o2def::field("buy_price", "BUYPRICE", "amount");
	o2def::field("prod_price", "MSRP", "amount");

	o2def::index("pk_index", "code","A");
	o2def::index("prod_name", "prod_name","A", "code","A");
	o2def::index("prod_line", "prod_line","A", "prod_name","A", "code","A");
	o2def::index("vendor", "vendor","A", "prod_name","A", "code","A");
	o2def::index("prod_scale", "prod_scale","A", "prod_name","A", "code","A");

?>
