<?php

/**
 * Janox Runtime
 * PHP5
 *
 * This file is part of Janox.
 *
 * THIS FILE HAS BEEN COMPRESSED TO SPEED UP EXECUTION.
 * See file src/jxsql.inc for a readable version of this script.
 */

 class JXSQLparser { public $dbengine = 'sqlite3'; protected $databasename = ''; protected $dbserver = ''; protected $db_phys_name = ''; protected $qualifier_o = '"'; protected $qualifier_c = '"'; protected $fully_qualify_columns = false; protected $tab_qprefix = ''; protected $aliases = array(); protected $JXTAB = 'JXTAB'; protected $JXCOL = 'JXCOL'; protected $JXCONCAT = 'JXCONCAT'; protected $JXSUBSTRING = 'JXSUBSTRING'; public function __construct($dbname, $fq_columns = false) { if (o2db_name($dbname) === false) { throw new o2_exception('Unknown database <i>'.$dbname.'</i>'. ' for parsing JXSQL code', o2error_UNKNOWNDBSERVER); return false; } $this->databasename = $dbname; $this->dbserver = o2db_server($dbname); $this->dbengine = o2dbs_engine($this->dbserver); $this->db_phys_name = o2db_name($dbname); $this->qualifier_o = constant("o2_".$this->dbengine."_o"); $this->qualifier_c = constant("o2_".$this->dbengine."_c"); $this->fully_qualify_columns = $fq_columns; $this->tab_qprefix = o2db_qprefix($dbname); } private function endsWith($str, $endsWith) { if (trim($str) === '') { return false; } else { return substr(strtolower($str), -strlen($endsWith)) === strtolower($endsWith); } } public function parseSQL($sql, $stage) { $sres = null; $c = 0; $len = strlen($sql); $ch = null; $sql_buf = ''; while ($c < $len) { $ch = $sql[$c]; if ($ch == '(') { $jxsql_function = null; if ($stage == 1 && $this->endsWith($sql_buf, $this->JXTAB)) { $jxsql_function = $this->JXTAB; } elseif ($stage == 2 && $this->endsWith($sql_buf, $this->JXCOL)) { $jxsql_function = $this->JXCOL; } elseif ($stage == 3 && $this->endsWith($sql_buf, $this->JXCONCAT)) { $jxsql_function = $this->JXCONCAT; } elseif ($stage == 3 && $this->endsWith($sql_buf, $this->JXSUBSTRING)) { $jxsql_function = $this->JXSUBSTRING; } if ($jxsql_function != null) { $func_len = strlen($jxsql_function); $sres .= substr($sql_buf, 0, (strlen($sql_buf) - $func_len)); $end_par = $this->find_corresponding_parenthesis($sql, $c); if ($end_par > 0) { $start_pos = $c - $func_len; $length = $end_par - $start_pos + 1; $jx_sql_command = substr($sql, $start_pos, $length); switch ($jxsql_function) { case $this->JXTAB: $sres.= $this->replace_JXTAB(strtolower($jx_sql_command)); break; case $this->JXCOL: $sres.= $this->replace_JXCOL(strtolower($jx_sql_command)); break; case $this->JXCONCAT: $sres.= $this->replace_JXCONCAT(strtolower($jx_sql_command)); break; case $this->JXSUBSTRING: $sres.= $this->replace_JXSUBSTRING(strtolower($jx_sql_command)); break; } $c = $end_par; } else { $sres.= '--MISSING_CLOSE_PARENTHESIS--'; } } else { $sres.= $sql_buf.'('; } $sql_buf = ''; } else { $sql_buf.= $ch; } $c++; } if (strlen($sql_buf) > 0) { $sres.= $sql_buf; } return $sres; } private function find_corresponding_parenthesis($mystr, $startpos) { $c = $startpos + 1; $ch = ''; $open_pars = 0; $ret = 0; $len = strlen($mystr); while ($c < $len) { $ch = $mystr[$c]; if ($ch == '(') { $open_pars++; } elseif ($ch == ')') { if ($open_pars > 0) { $open_pars--; } else { $ret = $c; break; } } $c++; } return $ret; } private function replace_JXTAB($sql) { preg_match('/\((.*?)\)/', $sql, $match); list($tabname, $tabalias) = explode(':', $match[1]); if (!$tabalias) { $tabalias = $tabname; } if ($real_tab_name = o2tab_is_defined($tabname)) { $this->aliases[$tabalias] = $real_tab_name; $qname = o2tab_qname($real_tab_name); } else { $this->aliases[$tabalias] = $tabname; $qname = o2_gateway::qualify($this->dbengine, $this->db_phys_name, o2db_schema($this->databasename), $tabname); } return $qname.($tabname != $tabalias ? ' '.$tabalias : ''); } private function replace_JXCOL($sql) { $sret = ''; preg_match('/\((.*?)\)/', $sql, $match); if (count($match) > 0) { $stok = explode(':', $match[1]); if (count($stok) == 2) { $aliasname = $stok[0]; $colname = $stok[1]; $tabname = $this->aliases[$aliasname]; if ($colname != '*') { $col_phys_name = o2field_name($tabname, $colname); if ($col_phys_name == 'O2ASPID') { $col_phys_name = 'o2aspid'; } elseif ($col_phys_name == '') { $col_phys_name = '--WRONG-COL-NAME--'; } $sret = (($tabname != $aliasname) || $this->fully_qualify_columns ? $aliasname.'.' : ''). $this->qualifier_o.$col_phys_name.$this->qualifier_c; } else { $sret = $aliasname.'.*'; } } else { $colname = $stok[0]; $sret = $this->qualifier_o.$colname.$this->qualifier_c; } } else { $sret = '--PARSE_ERROR--'; } return $sret; } private function replace_JXCONCAT($sql) { $concatop = ''; if ($this->dbengine == 'mssql') { $concatop = '+'; } elseif ($this->dbengine == 'mysql') { $concatop = ','; } else { $concatop = '||'; } $sret = ''; $start_pos = strlen($this->JXCONCAT); $end_par = $this->find_corresponding_parenthesis($sql, $start_pos); $length = $end_par - $start_pos + 1; $jx_sql_command = substr($sql, $start_pos + 1, $length - 2); if (strlen($jx_sql_command) > 0) { $stok = explode(',', $jx_sql_command); $i = 0; if ($this->dbengine == 'mysql') { $sret = 'CONCAT'; } $sret.= '('; $tlen = count($stok); while ($i < $tlen) { $argval = $stok[$i]; if ($i > 0) { $sret.= ' '.$concatop.' '.$argval; } else { $sret.= $argval; } $i++; } $sret.= ')'; } else { $sret = '--PARSE_ERROR--'; } return $sret; } private function replace_JXSUBSTRING($sql) { $sret = ''; $start_pos = strlen($this->JXSUBSTRING); $end_par = $this->find_corresponding_parenthesis($sql, $start_pos); $length = $end_par - $start_pos + 1; $jx_sql_command = substr($sql, $start_pos + 1, $length - 2); if (strlen($jx_sql_command) > 0) { $stok = explode(',', $jx_sql_command); $i = 0; $index_from = 0; $index_to = 0; $sret = 'SUBSTRING'; $sret .= '('; $tlen = count($stok); while ($i < $tlen) { $argval = $stok[$i]; if ($i == 0) { $sret.= $argval; } elseif ($i == 1) { $index_from = $argval; } elseif ($i == 2) { $index_to = $argval; if ($this->dbengine == 'postgres') { $sret.= ' from '.$index_from. ' for '.($index_to - $index_from + 1); } else { $sret.= ','.$index_from.','.$index_to; } } $i++; } $sret.= ')'; } else { $sret = '--PARSE_ERROR--'; } return $sret; } } function jxsql_parse($dbname, $sql, $fq_columns = false) { $parser = new JXSQLparser($dbname, $fq_columns); if (strtolower($parser->dbengine) != 'jxsdb') { $sql = $parser->parseSQL($sql, 1); $sql = $parser->parseSQL($sql, 2); $sql = $parser->parseSQL($sql, 3); } return $sql; } function jxsql($dbname, $sql, $fq_columns = false) { return jxsql_parse($dbname, $sql, $fq_columns); } ?>
