<?php

/**
 * Janox Runtime
 * PHP5
 *
 * This file is part of Janox.
 *
 * THIS FILE HAS BEEN COMPRESSED TO SPEED UP EXECUTION.
 * See file src/jxdb_mysql.inc for a readable version of this script.
 */

 if (!extension_loaded("pdo_mysql")) { throw new o2_exception("<b>MySQL PDO</b> driver not loaded:<br>". "check your PHP configuration for ". "<i>pdo</i> and <i>pdo_mysql</i> extensions.", o2error_DBCONNECT); } define("o2_mysql_o", "`"); define("o2_mysql_c", "`"); $GLOBALS['o2_mysql_conn'] = array(); $GLOBALS['o2_mysql_trans'] = array(); function o2_mysql_normalize($string, $untrim = false) { return addslashes($untrim ? $string : rtrim($string)); } function o2_mysql_concat($strings) { return 'CONCAT('.implode(',', $strings).')'; } function o2_mysql_qualify($database, $owner, $name = "") { return o2_mysql_o.$database.o2_mysql_c. ($name ? ".".o2_mysql_o.$name.o2_mysql_c : ""); } function o2_mysql_connect($server, $user, $password, $trans) { $app = $_SESSION['o2_app']; $key = $server.$user; if (!$server) { $server = "localhost"; } if (!isset($GLOBALS['o2_mysql_conn'][$key])) { $opt = array(PDO::ATTR_PERSISTENT => true, PDO::ATTR_ERRMODE => PDO::ERRMODE_SILENT); if ($app->chr_encoding) { switch (strtolower(str_replace(array("-", "_"), "", $app->chr_encoding))) { case "windows1252": case "cp1252": $opt[PDO::MYSQL_ATTR_INIT_COMMAND] = 'SET NAMES latin1'; break; case "utf8": $opt[PDO::MYSQL_ATTR_INIT_COMMAND] = 'SET NAMES utf8'; break; } } if (!($conn_local = new PDO("mysql:host=".$server, $user, $password, $opt))) { $err = $conn_local->errorInfo(); throw new o2_exception("<b>MySQL</b> server: <i>".$server."</i><hr>". $err[2], o2error_DBCONNECT); } if ($trans) { if (!$conn_local->beginTransaction()) { $err = $conn_local->errorInfo(); throw new o2_exception("<b>MySQL</b> server: <i>".$server."</i><hr>". $err[2], o2error_DBCONNECT); } else { $GLOBALS['o2_mysql_trans'][$key] = true; } } $GLOBALS['o2_mysql_conn'][$key] = $conn_local; } elseif ($trans && !isset($GLOBALS['o2_mysql_trans'][$key])) { $conn_local = $GLOBALS['o2_mysql_conn'][$key]; if (!$conn_local->beginTransaction()) { $err = $conn_local->errorInfo(); throw new o2_exception("<b>MySQL</b> server: <i>".$server."</i><hr />". $err[2], o2error_DBCONNECT); } else { $GLOBALS['o2_mysql_trans'][$key] = true; } } return $GLOBALS['o2_mysql_conn'][$key]; } function o2_mysql_execute($query, $server, $user, $password, $only_exe = false, $trans = true) { if ($_SESSION['o2_app']->sqltrace) { o2log($query); } $conn = o2_mysql_connect($server, $user, $password, $trans); if ($only_exe) { $res = $conn->exec($query); if ($res === false) { $err = $conn->errorInfo(); $rb = $conn->rollBack; $rb && @$rb(); throw new o2_exception("<b>MySQL</b> server: <i>".$server. "</i><br>query: <code>".$query."</code><hr>". $err[2], o2error_DBEXECUTE); return false; } return $res; } else { if (!($res = $conn->query($query))) { $err = $conn->errorInfo(); $rb = $conn->rollBack; $rb && @$rb(); throw new o2_exception("<b>MySQL</b> server: <i>".$server. "</i><br>query: <code>".$query."</code><hr>". $err[2], o2error_DBDATAQUERY); return false; } return $res->fetchAll(PDO::FETCH_ASSOC); } } function o2_mysql_tables($server, $user, $password, $database, $owner) { $arr_local = array(); $conn_local = o2_mysql_connect($server, $user, $password, false); $query_local = "SHOW TABLES FROM ".o2_mysql_o.$database.o2_mysql_c; $res_local = $conn_local->query($query_local); if ($res_local === false) { $err = $conn_local->errorInfo(); throw new o2_exception("<b>MySQL</b> server: <i>".$server."</i><hr>".$err[2], o2error_DBTABLES); } while ($single_tab = $res_local->fetchColumn()) { $arr_local[] = $single_tab; } return $arr_local; } function o2_mysql_tabexists($server, $user, $password, $database, $owner, $table) { $conn_local = o2_mysql_connect($server, $user, $password, false); $query_local = "SHOW TABLES FROM ".o2_mysql_o.$database.o2_mysql_c. " LIKE '".$table."'"; $res_local = $conn_local->query($query_local); if ($res_local === false) { $err = $conn_local->errorInfo(); throw new o2_exception("<b>MySQL</b> server: <i>".$server."</i><hr>".$err[2], o2error_DBTABEXISTS); } return ($res_local->fetchColumn() ? true : false); } function o2_mysql_tablefields($server, $user, $password, $database, $owner, $table) { $fields_list = array(); $query_local = "SHOW FIELDS FROM ".o2_mysql_o.$database.o2_mysql_c.".". o2_mysql_o.$table.o2_mysql_c; try { $res_local = o2_mysql_execute($query_local, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEINFO); throw $o2e; } foreach ($res_local as $single_field) { $single_field = array_change_key_case($single_field); $fields_list[] = array('field' => $single_field['field'], 'type' => $single_field['type'], 'default' => $single_field['default']); } return $fields_list; } function o2_mysql_tableindexes($server, $user, $password, $database, $owner, $table) { $ret_val = array(); $query_local = "SHOW KEYS FROM ".o2_mysql_o.$database.o2_mysql_c.".". o2_mysql_o.$table.o2_mysql_c; try { $res_local = o2_mysql_execute($query_local, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEINFO); throw $o2e; } foreach ($res_local as $single_segment) { if ($single_segment['Key_name'] != "PRIMARY") { if (!isset($ret_val[$single_segment['Key_name']])) { $ret_val[$single_segment['Key_name']] = array(); } $ret_val[$single_segment['Key_name']]+= array(($single_segment['Seq_in_index'] - 1) => array('column' => $single_segment['Column_name'], 'dir' => "")); } } return $ret_val; } function o2_mysql_insertfrom($server, $user, $password, $database_from, $owner_from, $table_from, $database_to, $owner_to, $table_to, $values, $where = "") { $list_from = ""; $list_to = ""; foreach ($values as $field_from => $field_to) { $sep = ($list_from ? "," : ""); if ($field_from == "@o2CloneArea") { $list_from.= $sep.$field_to; $list_to .= $sep."O2ASPID"; } else { $list_from.= $sep.$field_from; $list_to .= $sep.$field_to; } } $query_local = "INSERT INTO ".o2_mysql_o.$database_to.o2_mysql_c.".". o2_mysql_o.$table_to.o2_mysql_c." (".$list_to. ") SELECT ".$list_from." FROM ".o2_mysql_o.$database_from.o2_mysql_c. ".".o2_mysql_o.$table_from.o2_mysql_c; if ($where) { $query_local.= " WHERE ".$where; } try { $aff_rows = o2_mysql_execute($query_local, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLECOPY); throw $o2e; return false; } return $aff_rows; } function o2_mysql_droptable($server, $user, $password, $database, $owner, $table) { $query_local = "DROP TABLE ".o2_mysql_o.$database.o2_mysql_c.".". o2_mysql_o.$table.o2_mysql_c; try { o2_mysql_execute($query_local, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEDROP); throw $o2e; } o2_mysql_commit($server, $user, $password, $database); return true; } function o2_mysql_renametable($server, $user, $password, $database, $owner, $table, $new_name) { $query_local = "RENAME TABLE ".o2_mysql_o.$database.o2_mysql_c.".". o2_mysql_o.$table.o2_mysql_c." TO ". o2_mysql_o.$database.o2_mysql_c.".". o2_mysql_o.$new_name.o2_mysql_c; try { o2_mysql_execute($query_local, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEREBUILD); throw $o2e; } o2_mysql_commit($server, $user, $password, $database); return true; } function o2_mysql_createtable($server, $user, $password, $database, $owner, $table, $structure, $execute = true) { $query = "CREATE TABLE IF NOT EXISTS ".o2_mysql_o.$database.o2_mysql_c.".". o2_mysql_o.$table.o2_mysql_c." (\n"; $type = ""; $default = ""; foreach ($structure["fields"] as $field_name => $field_prop) { $query.= o2_mysql_field_create($field_name, $field_prop['type'], $field_prop['size'], $field_prop['int'], $field_prop['dec']).",\n"; } $arr_local = array(); foreach ($structure["primary"] as $pk_name => $pk_segments) { break; } $query.= "PRIMARY KEY (".o2_mysql_indexfields_create($pk_segments)."),\n"; foreach ($structure["keys"] as $index_name => $index_segs) { $query.= o2_mysql_index_create($index_name, $index_segs).",\n"; } $query = substr($query, 0, -2).")\nENGINE = MYISAM"; if ($execute) { try { o2_mysql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLECREATE); throw $o2e; } o2_mysql_commit($server, $user, $password, $database); return true; } else { return $query; } } function o2_mysql_field_create($name, $type, $size, $int, $dec, $for_change = false) { switch ($type) { case "A": if ($size <= 255) { $fld_type = "varchar(".$size.")"; $fld_default = "''"; } elseif ($size <= 65530) { $fld_type = "text"; $fld_default = false; } else { $fld_type = "longtext"; $fld_default = false; } break; case "N": if ($dec) { $fld_type = "decimal(".($int + $dec).", ".$dec.")"; } elseif ($int < 3) { $fld_type = "TINYINT"; } elseif ($int < 5) { $fld_type = "SMALLINT"; } elseif ($int < 7) { $fld_type = "MEDIUMINT"; } elseif ($int < 10) { $fld_type = "INT"; } else { $fld_type = "BIGINT"; } $fld_default = "0"; break; case "L": $fld_type = "char(1)"; $fld_default = "'0'"; break; case "D": $fld_type = "char(8)"; $fld_default = "'00000000'"; break; case "T": $fld_type = "char(6)"; $fld_default = "'000000'"; break; case "S": $fld_type = "text"; $fld_default = false; break; } return $name." ".$fld_type.($fld_default !== false ? " NOT NULL DEFAULT ".$fld_default : ""); } function o2_mysql_index_create($key_name, $key_segs, $table = "", $database = "", $owner = "", $unique = true) { return ($unique ? 'UNIQUE ' : 'INDEX ').o2_mysql_o.$key_name.o2_mysql_c. " (".o2_mysql_indexfields_create($key_segs).")"; } function o2_mysql_indexfields_create($fields) { $str = ''; foreach ($fields as $field => $direction) { $str.= ($str ? ',' : '').$field; } return $str; } function o2_mysql_field_add($server, $user, $password, $database, $owner, $table, $field_name, $field_type, $field_size, $field_int, $field_dec) { $query = "ALTER TABLE ".o2_mysql_o.$database.o2_mysql_c.".". o2_mysql_o.$table.o2_mysql_c. " ADD COLUMN ".o2_mysql_field_create(o2_mysql_o.$field_name.o2_mysql_c, $field_type, $field_size, $field_int, $field_dec); try { $res = o2_mysql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; } } function o2_mysql_field_remove($server, $user, $password, $database, $owner, $table, $field_name) { $query = "ALTER TABLE ".o2_mysql_o.$database.o2_mysql_c.".". o2_mysql_o.$table.o2_mysql_c. " DROP COLUMN ".o2_mysql_o.$field_name.o2_mysql_c; try { $res = o2_mysql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; } } function o2_mysql_field_change($server, $user, $password, $database, $owner, $table, $field_name, $field_type, $field_size, $field_int, $field_dec) { $query = "ALTER TABLE ".o2_mysql_o.$database.o2_mysql_c.".". o2_mysql_o.$table.o2_mysql_c. " MODIFY ".o2_mysql_field_create(o2_mysql_o.$field_name.o2_mysql_c, $field_type, $field_size, $field_int, $field_dec, true); try { $res = o2_mysql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; } } function o2_mysql_field_rename($server, $user, $password, $database, $owner, $table, $old_name, $new_name) { $query = "ALTER TABLE ".o2_mysql_o.$database.o2_mysql_c.".". o2_mysql_o.$table.o2_mysql_c. " CHANGE COLUMN ".o2_mysql_o.$old_name.o2_mysql_c." ". o2_mysql_o.$new_name.o2_mysql_c; $flds = o2_mysql_tablefields($server, $user, $password, $database, $owner, $table); $fld_def = false; foreach ($flds as $fld) { if ($fld["field"] == $old_name) { $type = strtoupper($fld["type"]); if (strpos($type, "CHAR") !== false) { $default = " NOT NULL DEFAULT ''"; } elseif (strpos($type, "TEXT") !== false) { $default = ""; } else { $default = " NOT NULL DEFAULT 0"; } $query .= " ".$type.$default; $fld_def = true; break; } } if ($fld_def) { try { $res = o2_mysql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; } } else { throw new o2_exception("Unknown field <i>".$old_name."</i> in table <i>".$table. "</i>", o2error_DBTABLEALTER); } } function o2_mysql_index_add($server, $user, $password, $database, $owner, $table, $index_name, $key_segs, $unique = true) { $quoted_segs = array(); foreach ($key_segs as $field_name => $direction) { $quoted_segs[o2_mysql_o.$field_name.o2_mysql_c] = $direction; } $query = "ALTER TABLE ".o2_mysql_o.$database.o2_mysql_c.".". o2_mysql_o.$table.o2_mysql_c. " ADD ".o2_mysql_index_create($index_name, $quoted_segs, $table, $database, $owner, $unique); try { $res = o2_mysql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; } } function o2_mysql_index_remove($server, $user, $password, $database, $owner, $table, $index_name) { $query = "ALTER TABLE ".o2_mysql_o.$database.o2_mysql_c.".". o2_mysql_o.$table.o2_mysql_c. " DROP INDEX ".o2_mysql_o.$index_name.o2_mysql_c; try { $res = o2_mysql_execute($query, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBTABLEALTER); throw $o2e; } } function o2_mysql_aggregate($server, $user, $password, $database, $owner, $table, $table_alias, $where, $functions, $links = null) { $functions_list = ""; foreach ($functions as $func_name => $single_func) { $functions_list.= ($functions_list ? "," : ""). $single_func["func"]."(". $single_func["field"].") AS ".o2_mysql_o.$func_name.o2_mysql_c; } if (substr($table, 0, 1) != "(") { $table = o2_mysql_o.$database.o2_mysql_c.".".o2_mysql_o.$table.o2_mysql_c; } $query = "SELECT ".$functions_list." FROM ".$table. " AS ".o2_mysql_o.$table_alias.o2_mysql_c; if ($links) { foreach ($links as $linktab => $linkon) { $query.= " LEFT JOIN ".$linktab." ON ".$linkon; } } if ($where) { $query.= " WHERE ".$where; } try { $res = o2_mysql_execute($query, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBAGGREGATE); throw $o2e; } return $res[0]; } function o2_mysql_verifyrec($server, $user, $password, $database, $owner, $table, $table_alias, $select_str, $where, $order_by) { if (substr($table, 0, 1) != "(") { $table = o2_mysql_o.$database.o2_mysql_c.".".o2_mysql_o.$table.o2_mysql_c; } $query_local = "SELECT ".$select_str." FROM ".$table. " AS ".o2_mysql_o.$table_alias.o2_mysql_c; if (trim($where) != "") { $query_local.= " WHERE ".$where; } if (trim($order_by) != "") { $query_local.= " ORDER BY ".$order_by; } $query_local.=" LIMIT 1"; try { $res_local = o2_mysql_execute($query_local, $server, $user, $password, false, false); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECQUERY); throw $o2e; } if (!$res_local || $res_local === array()) { return false; } else { return $res_local[0]; } } function o2_mysql_modifyrec($server, $user, $password, $database, $owner, $table, $table_alias, $sets, $where) { $upd_str = ''; foreach ($sets as $field => $value) { $upd_str.= ($upd_str != "" ? "," : "").$field." = ".$value; } $query_local = "UPDATE ".o2_mysql_o.$database.o2_mysql_c.".". o2_mysql_o.$table.o2_mysql_c. " AS ".o2_mysql_o.$table_alias.o2_mysql_c. " SET ".$upd_str." WHERE ".$where; try { o2_mysql_execute($query_local, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECUPDATE); throw $o2e; } return true; } function o2_mysql_insertrec($server, $user, $password, $database, $owner, $table, $table_alias, $fields, $values) { $query_local = "INSERT INTO ".o2_mysql_o.$database.o2_mysql_c.".". o2_mysql_o.$table.o2_mysql_c. "(".implode(",", $fields).") VALUES (".implode(",", $values).")"; try { o2_mysql_execute($query_local, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECINSERT); throw $o2e; } return true; } function o2_mysql_deleterec($server, $user, $password, $database, $owner, $table, $table_alias, $where) { $query_local = "DELETE FROM ".o2_mysql_o.$database.o2_mysql_c.".". o2_mysql_o.$table.o2_mysql_c; if ($where) { $where = str_replace(o2_mysql_o.$table_alias.o2_mysql_c.".", "", $where); $query_local.= " WHERE ".$where; } if (isset($GLOBALS['jxviewsql'])) { $GLOBALS['jxviewsql'] = $query_local; return true; } try { o2_mysql_execute($query_local, $server, $user, $password, true, true); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBRECDELETE); throw $o2e; } return true; } function o2_mysql_count($server, $user, $password, $database, $owner, $table, $table_alias, $where, $links = null) { if (substr($table, 0, 1) != "(") { $table = o2_mysql_o.$database.o2_mysql_c.".".o2_mysql_o.$table.o2_mysql_c; } $query = "SELECT COUNT(*) AS COMPUTED FROM ".$table. " AS ".o2_mysql_o.$table_alias.o2_mysql_c; if ($links) { foreach ($links as $linktab => $linkon) { $query.= " LEFT JOIN ".$linktab." ON ".$linkon; } } if ($where) { $query.= " WHERE ".$where; } if ($_SESSION['o2_app']->sqltrace) { o2log($query); } $conn = o2_mysql_connect($server, $user, $password, false); if (!($res = $conn->query($query))) { $err = $conn->errorInfo(); $rb = $conn->rollBack; $rb && @$rb(); throw new o2_exception("<b>MySQL</b> server: <i>".$server. "</i><br>Error counting dataset.<hr>". $err[2], o2error_DBCOUNT); return false; } $dset = $res->fetchAll(PDO::FETCH_ASSOC); return intval($dset[0]['COMPUTED']); } function o2_mysql_recordset($server, $user, $password, $database, $owner, $table, $table_alias, $select_str, $where, $order_by, $recs, $links = null, $lock = false, $page_where = false, $stm_id = false) { $where = $page_where.$where; if (substr($table, 0, 1) != "(") { $table = o2_mysql_o.$database.o2_mysql_c.".".o2_mysql_o.$table.o2_mysql_c; } $query = "SELECT ".$select_str." FROM ".$table. " AS ".o2_mysql_o.$table_alias.o2_mysql_c; if ($links) { foreach ($links as $linktab => $linkon) { $query.= " LEFT JOIN ".$linktab." ON ".$linkon; } } if ($where) { $query.= " WHERE ".$where; } if ($order_by && (!isset($GLOBALS['jxviewsql']) || (strpos($GLOBALS['jxviewsql'], 'O') !== false))) { $query.= " ORDER BY ".$order_by; } if (!isset($GLOBALS['jxviewsql']) || (strpos($GLOBALS['jxviewsql'], 'L') !== false)) { $query.= " LIMIT ".abs($recs); } if (isset($GLOBALS['jxviewsql'])) { $GLOBALS['jxviewsql'] = $query; return array(); } if ($lock) { $query.= " FOR UPDATE"; } try { $res = o2_mysql_execute($query, $server, $user, $password, false, $lock); } catch (o2_exception $o2e) { $o2e->set_error_class(o2error_DBDATAQUERY); throw $o2e; } return $res; } function o2_mysql_fkeyadd($server, $user, $password, $main_db, $main_owner, $main_table, $main_fields, $ref_db, $ref_owner, $ref_table, $ref_fields, $key_name) { return false; } function o2_mysql_fkeyremove($server, $user, $password, $database, $owner, $table, $key_name) { return false; } function o2_mysql_fkeyvalidate($server, $user, $password, $database, $owner, $table, $key_name) { return false; } function o2_mysql_fkeystablist($server, $user, $password, $database, $owner, $table) { return array(); } function o2_mysql_commit($server, $user, $password, $end = false) { $key = $server.$user; if (!$server) { $server = "localhost"; } if (isset($GLOBALS['o2_mysql_trans'][$key])) { if (isset($GLOBALS['o2_mysql_error'][$key])) { $GLOBALS['o2_mysql_conn'][$key]->rollBack(); unset($GLOBALS['o2_mysql_error'][$key]); } elseif (!$GLOBALS['o2_mysql_conn'][$key]->commit()) { $err = $GLOBALS['o2_mysql_conn'][$key]->errorInfo(); throw new o2_exception("<b>MySQL</b> server: <i>".$server."</i><hr>". $err[2], o2error_DBCOMMIT); } unset($GLOBALS['o2_mysql_trans'][$key]); } if ($end && isset($GLOBALS['o2_mysql_conn'][$key])) { unset($GLOBALS['o2_mysql_conn'][$key]); } } ?>
